/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CGUtils;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstructorExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsInvalidExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsUndefinedExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTupleExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.generator.LocalContext;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisVisitor
extends AbstractExtendingCGModelVisitor<Object, CodeGenAnalyzer> {
    public AnalysisVisitor(@NonNull CodeGenAnalyzer analyzer) {
        super(analyzer);
    }

    @Override
    @Nullable
    public Object visitCGCollectionExp(@NonNull CGCollectionExp cgCollectionExp) {
        super.visitCGCollectionExp(cgCollectionExp);
        if (cgCollectionExp.isInvalid()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgCollectionExp, cgCollectionExp.getValue());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGConstructorExp(@NonNull CGConstructorExp cgConstructorExp) {
        LocalContext localContext;
        EObject eTarget;
        ConstructorExp pConstructorExp = (ConstructorExp)cgConstructorExp.getPivot();
        Type pType = pConstructorExp.getType();
        if (pType != null && (eTarget = pType.getETarget()) instanceof EClass && (localContext = ((CodeGenAnalyzer)this.context).getCodeGenerator().getGlobalContext().getLocalContext(cgConstructorExp)) != null) {
            CGExecutorType cgExecutorType = localContext.getExecutorType(pType);
            cgConstructorExp.getDependsOn().add(cgExecutorType);
        }
        if (cgConstructorExp.isInvalid()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgConstructorExp, cgConstructorExp.getValue());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGElement(@NonNull CGElement cgElement) {
        for (CGElement cGElement : cgElement.getChildren()) {
            cGElement.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIfExp(@NonNull CGIfExp cgIfExp) {
        super.visitCGIfExp(cgIfExp);
        CGValuedElement condition = ((CodeGenAnalyzer)this.context).getExpression(cgIfExp.getCondition());
        CGValuedElement thenExpression = ((CodeGenAnalyzer)this.context).getExpression(cgIfExp.getThenExpression());
        CGValuedElement elseExpression = ((CodeGenAnalyzer)this.context).getExpression(cgIfExp.getElseExpression());
        if (condition.isInvalid()) {
            CGUtils.replace(cgIfExp, condition);
        } else if (condition.isNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIfExp, ((CodeGenAnalyzer)this.context).getInvalid("Null condition", new Object[0]));
        } else if (thenExpression.isInvalid() && elseExpression.isInvalid()) {
            CGUtils.replace(cgIfExp, thenExpression);
        } else if (condition.isConstant()) {
            if (condition.isTrue()) {
                CGUtils.replace(cgIfExp, thenExpression);
            } else if (condition.isFalse()) {
                CGUtils.replace(cgIfExp, elseExpression);
            } else {
                ElementId pivotTypeId = condition.getTypeId().getElementId();
                ((CodeGenAnalyzer)this.context).setConstant(cgIfExp, ((CodeGenAnalyzer)this.context).getInvalid(EvaluatorMessages.TypedValueRequired, "Boolean", pivotTypeId));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIsInvalidExp(@NonNull CGIsInvalidExp cgIsInvalidExp) {
        super.visitCGIsInvalidExp(cgIsInvalidExp);
        if (cgIsInvalidExp.isConstant()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsInvalidExp, ((CodeGenAnalyzer)this.context).getBoolean(cgIsInvalidExp.isTrue()));
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIsUndefinedExp(@NonNull CGIsUndefinedExp cgIsUndefinedExp) {
        super.visitCGIsUndefinedExp(cgIsUndefinedExp);
        if (cgIsUndefinedExp.isConstant()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsUndefinedExp, ((CodeGenAnalyzer)this.context).getBoolean(cgIsUndefinedExp.isTrue()));
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLetExp(@NonNull CGLetExp cgLetExp) {
        super.visitCGLetExp(cgLetExp);
        CGValuedElement in = ((CodeGenAnalyzer)this.context).getExpression(cgLetExp.getIn());
        if (cgLetExp.getInit().isGlobal()) {
            CGUtils.replace(cgLetExp, in);
        } else if (in.isConstant()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgLetExp, in.getValue());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIterationCallExp(@NonNull CGIterationCallExp cgIterationCallExp) {
        super.visitCGIterationCallExp(cgIterationCallExp);
        CGValuedElement source = ((CodeGenAnalyzer)this.context).getExpression(cgIterationCallExp.getSource());
        if (source.isInvalid()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIterationCallExp, source.getValue());
            return null;
        }
        if (source.isNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIterationCallExp, ((CodeGenAnalyzer)this.context).getInvalid(EvaluatorMessages.TypedValueRequired, "Collection", ValuesUtil.getTypeName(null)));
            return null;
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGOperation(@NonNull CGOperation cgOperation) {
        super.visitCGOperation(cgOperation);
        CGValuedElement cgBody = ((CodeGenAnalyzer)this.context).getExpression(cgOperation.getBody());
        for (CGVariable cGVariable : cgOperation.getParameters()) {
            if (!cGVariable.isInvalid()) continue;
            ((CodeGenAnalyzer)this.context).setConstant(cgBody, cGVariable.getValue());
            return null;
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGOperationCallExp(@NonNull CGOperationCallExp cgOperationCallExp) {
        super.visitCGOperationCallExp(cgOperationCallExp);
        CGValuedElement source = ((CodeGenAnalyzer)this.context).getExpression(cgOperationCallExp.getSource());
        if (!cgOperationCallExp.isValidating()) {
            if (source.isInvalid()) {
                ((CodeGenAnalyzer)this.context).setConstant(cgOperationCallExp, source.getValue());
                return null;
            }
            for (CGValuedElement cgArgument : cgOperationCallExp.getArguments()) {
                if (!cgArgument.isInvalid()) continue;
                ((CodeGenAnalyzer)this.context).setConstant(cgOperationCallExp, cgArgument.getValue());
                return null;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGParameter(@NonNull CGParameter object) {
        return null;
    }

    @Override
    @Nullable
    public Object visitCGPropertyCallExp(@NonNull CGPropertyCallExp cgPropertyCallExp) {
        super.visitCGPropertyCallExp(cgPropertyCallExp);
        CGValuedElement source = ((CodeGenAnalyzer)this.context).getExpression(cgPropertyCallExp.getSource());
        if (source.isInvalid()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgPropertyCallExp, source.getValue());
        } else if (source.isNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgPropertyCallExp, ((CodeGenAnalyzer)this.context).getInvalid());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTupleExp(@NonNull CGTupleExp cgTupleExp) {
        if (cgTupleExp.isInvalid()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgTupleExp, cgTupleExp.getValue());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTypeExp(@NonNull CGTypeExp cgTypeExp) {
        LocalContext localContext;
        TypeExp pTypeExp = (TypeExp)cgTypeExp.getPivot();
        Type referredType = pTypeExp.getReferredType();
        if (referredType != null && (localContext = ((CodeGenAnalyzer)this.context).getCodeGenerator().getGlobalContext().getLocalContext(cgTypeExp)) != null) {
            CGExecutorType cgExecutorType = localContext.getExecutorType(referredType);
            cgTypeExp.setReferredType(cgExecutorType);
            cgTypeExp.setTypeId(cgExecutorType.getUnderlyingTypeId());
            cgTypeExp.getDependsOn().add(cgExecutorType);
        }
        return super.visitCGTypeExp(cgTypeExp);
    }

    @Override
    @Nullable
    public Object visitCGVariable(@NonNull CGVariable cgVariable) {
        CGValuedElement init = cgVariable.getInit();
        if (init != null) {
            init.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGVariableExp(@NonNull CGVariableExp cgVariableExp) {
        super.visitCGVariableExp(cgVariableExp);
        if (cgVariableExp.isConstant() && !(cgVariableExp.getReferredVariable() instanceof CGParameter)) {
            ((CodeGenAnalyzer)this.context).setConstant(cgVariableExp, cgVariableExp.getValue());
        }
        return null;
    }

    @Override
    @Nullable
    public CGElement visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }
}

