/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CGUtils;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstructorPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEqualsExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGGuardExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterateCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.library.LibraryIteration;
import org.eclipse.ocl.examples.library.iterator.IterateIteration;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxingAnalyzer
extends AbstractExtendingCGModelVisitor<Object, CodeGenAnalyzer> {
    @NonNull
    protected final CodeGenerator codeGenerator;

    public BoxingAnalyzer(@NonNull CodeGenAnalyzer analyzer) {
        super(analyzer);
        this.codeGenerator = analyzer.getCodeGenerator();
    }

    protected boolean hasOclVoidOperation(@NonNull OperationId operationId) {
        MetaModelManager metaModelManager = this.codeGenerator.getMetaModelManager();
        TypeServer typeServer = metaModelManager.getTypeServer((DomainType)metaModelManager.getOclVoidType());
        DomainOperation memberOperation = typeServer.getMemberOperation(operationId);
        if (memberOperation == null) {
            return false;
        }
        DomainType owningType = memberOperation.getOwningType();
        if (owningType == null) {
            return false;
        }
        TypeServer owningTypeServer = metaModelManager.getTypeServer(owningType);
        return typeServer == owningTypeServer;
    }

    protected CGValuedElement rewriteAsBoxed(@Nullable CGValuedElement cgChild) {
        TypeDescriptor unboxedTypeDescriptor;
        TypeDescriptor boxedTypeDescriptor;
        if (cgChild == null || cgChild.isBoxed()) {
            return cgChild;
        }
        CGTypeId cgTypeId = cgChild.getTypeId();
        ElementId elementId = cgTypeId.getElementId();
        if (elementId != null && (boxedTypeDescriptor = this.codeGenerator.getTypeDescriptor(elementId, true)) == (unboxedTypeDescriptor = this.codeGenerator.getTypeDescriptor(elementId, false))) {
            return cgChild;
        }
        CGBoxExp cgBoxExp = CGModelFactory.eINSTANCE.createCGBoxExp();
        CGUtils.wrap(cgBoxExp, cgChild);
        return cgBoxExp;
    }

    @Nullable
    protected CGValuedElement rewriteAsGuarded(@Nullable CGValuedElement cgChild) {
        if (cgChild == null || cgChild.isNonNull()) {
            return cgChild;
        }
        CGGuardExp cgGuardExp = CGModelFactory.eINSTANCE.createCGGuardExp();
        CGUtils.wrap(cgGuardExp, cgChild);
        return cgGuardExp;
    }

    protected CGValuedElement rewriteAsUnboxed(@Nullable CGValuedElement cgChild) {
        TypeDescriptor unboxedTypeDescriptor;
        TypeDescriptor boxedTypeDescriptor;
        if (cgChild == null || cgChild.isUnboxed()) {
            return cgChild;
        }
        CGTypeId cgTypeId = cgChild.getTypeId();
        ElementId elementId = cgTypeId.getElementId();
        if (elementId != null && (boxedTypeDescriptor = this.codeGenerator.getTypeDescriptor(elementId, true)) == (unboxedTypeDescriptor = this.codeGenerator.getTypeDescriptor(elementId, false))) {
            return cgChild;
        }
        CGUnboxExp cgUnboxExp = CGModelFactory.eINSTANCE.createCGUnboxExp();
        CGUtils.wrap(cgUnboxExp, cgChild);
        return cgUnboxExp;
    }

    @Override
    @Nullable
    public Object visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    @Override
    @Nullable
    public Object visitCGBuiltInIterationCallExp(@NonNull CGBuiltInIterationCallExp cgElement) {
        super.visitCGBuiltInIterationCallExp(cgElement);
        this.rewriteAsBoxed(this.rewriteAsGuarded(cgElement.getSource()));
        CGValuedElement cgBody = cgElement.getBody();
        if (cgBody.isRequired()) {
            this.rewriteAsBoxed(this.rewriteAsGuarded(cgBody));
        } else {
            this.rewriteAsBoxed(cgBody);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGConstructorPart(@NonNull CGConstructorPart cgConstructorPart) {
        this.rewriteAsUnboxed(cgConstructorPart.getInit());
        return super.visitCGConstructorPart(cgConstructorPart);
    }

    @Override
    @Nullable
    public Object visitCGEcoreOperationCallExp(@NonNull CGEcoreOperationCallExp cgElement) {
        super.visitCGEcoreOperationCallExp(cgElement);
        CGValuedElement cgSource = cgElement.getSource();
        this.rewriteAsGuarded(cgSource);
        this.rewriteAsUnboxed(cgSource);
        List<CGValuedElement> cgArguments = cgElement.getArguments();
        int iMax = cgArguments.size();
        int i = 0;
        while (i < iMax) {
            this.rewriteAsUnboxed(cgArguments.get(i));
            ++i;
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGEqualsExp(@NonNull CGEqualsExp cgElement) {
        super.visitCGEqualsExp(cgElement);
        CGValuedElement cgSource = cgElement.getSource();
        CGValuedElement cgArgument = cgElement.getArgument();
        boolean sourceIsBoxed = cgSource.isBoxed();
        boolean argumentIsBoxed = cgArgument.isBoxed();
        if (sourceIsBoxed != argumentIsBoxed) {
            if (!sourceIsBoxed) {
                this.rewriteAsBoxed(cgSource);
            }
            if (!argumentIsBoxed) {
                this.rewriteAsBoxed(cgArgument);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorPropertyCallExp(@NonNull CGExecutorPropertyCallExp cgElement) {
        super.visitCGExecutorPropertyCallExp(cgElement);
        this.rewriteAsUnboxed(cgElement.getSource());
        CGTypedElement cgParent = (CGTypedElement)cgElement.getParent();
        if (cgParent != null) {
            this.rewriteAsBoxed(cgElement);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGElement(@NonNull CGElement cgElement) {
        for (CGElement cGElement : cgElement.getChildren()) {
            cGElement.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIfExp(@NonNull CGIfExp cgElement) {
        super.visitCGIfExp(cgElement);
        this.rewriteAsGuarded(cgElement.getCondition());
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLibraryIterateCallExp(@NonNull CGLibraryIterateCallExp cgElement) {
        super.visitCGLibraryIterateCallExp(cgElement);
        this.rewriteAsGuarded(cgElement.getSource());
        this.rewriteAsBoxed(cgElement.getSource());
        LibraryIteration libraryIteration = cgElement.getLibraryIteration();
        if (!(libraryIteration instanceof IterateIteration)) {
            this.rewriteAsBoxed(cgElement.getBody());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLibraryIterationCallExp(@NonNull CGLibraryIterationCallExp cgElement) {
        super.visitCGLibraryIterationCallExp(cgElement);
        this.rewriteAsGuarded(cgElement.getSource());
        this.rewriteAsBoxed(cgElement.getSource());
        LibraryIteration libraryIteration = cgElement.getLibraryIteration();
        if (!(libraryIteration instanceof IterateIteration)) {
            this.rewriteAsBoxed(cgElement.getBody());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLibraryOperationCallExp(@NonNull CGLibraryOperationCallExp cgElement) {
        super.visitCGLibraryOperationCallExp(cgElement);
        this.rewriteAsBoxed(cgElement.getSource());
        List<CGValuedElement> cgArguments = cgElement.getArguments();
        int iMax = cgArguments.size();
        int i = 0;
        while (i < iMax) {
            this.rewriteAsBoxed(cgArguments.get(i));
            ++i;
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGOperation(@NonNull CGOperation cgElement) {
        CGValuedElement body;
        super.visitCGOperation(cgElement);
        if (cgElement.isRequired() && (body = cgElement.getBody()) != null) {
            this.rewriteAsGuarded(body);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGProperty(@NonNull CGProperty cgElement) {
        CGValuedElement body;
        super.visitCGProperty(cgElement);
        if (cgElement.isRequired() && (body = cgElement.getBody()) != null) {
            this.rewriteAsGuarded(body);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGPropertyCallExp(@NonNull CGPropertyCallExp cgElement) {
        super.visitCGPropertyCallExp(cgElement);
        this.rewriteAsGuarded(cgElement.getSource());
        return null;
    }
}

