/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CGUtils;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCatchExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstant;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEqualsExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsInvalidExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsUndefinedExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterateCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGThrowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldingAnalyzer {
    @NonNull
    protected final CodeGenAnalyzer analyzer;
    @NonNull
    private final Set<CGVariable> caughtVariables = new HashSet<CGVariable>();

    public FieldingAnalyzer(@NonNull CodeGenAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void analyze(@NonNull CGElement cgTree, boolean mustBeCaught) {
        AnalysisVisitor analysisVisitor = this.createAnalysisVisitor();
        cgTree.accept(analysisVisitor);
        RewriteVisitor rewriteVisitor = this.createRewriteVisitor(this.caughtVariables);
        cgTree.accept(rewriteVisitor);
    }

    @NonNull
    protected AnalysisVisitor createAnalysisVisitor() {
        return new AnalysisVisitor(this);
    }

    @NonNull
    protected RewriteVisitor createRewriteVisitor(@NonNull Set<CGVariable> caughtVariables) {
        return new RewriteVisitor(this.analyzer, caughtVariables);
    }

    protected boolean isValidating(EObject eObject) {
        OperationCallExp operationCall;
        Operation operation;
        return eObject instanceof OperationCallExp && (operation = (operationCall = (OperationCallExp)eObject).getReferredOperation()).isValidating();
    }

    public void setCaught(@Nullable Set<CGVariable> catchers) {
        if (catchers != null) {
            for (CGVariable catcher : catchers) {
                if (catcher.isNonInvalid()) continue;
                this.caughtVariables.add(catcher);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnalysisVisitor
    extends AbstractExtendingCGModelVisitor<Set<CGVariable>, FieldingAnalyzer> {
        public AnalysisVisitor(@NonNull FieldingAnalyzer context) {
            super(context);
        }

        @Override
        @Nullable
        public Set<CGVariable> visiting(@NonNull CGElement visitable) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        @Override
        @Nullable
        public Set<CGVariable> visitCGElement(@NonNull CGElement cgElement) {
            Set<CGVariable> childExternals = null;
            for (CGElement cGElement : cgElement.getChildren()) {
                Set<CGVariable> childExternal;
                if (cGElement == null || (childExternal = cGElement.accept(this)) == null) continue;
                if (childExternals == null) {
                    childExternals = childExternal;
                    continue;
                }
                childExternals.addAll(childExternal);
            }
            return childExternals;
        }

        @Override
        @Nullable
        public Set<CGVariable> visitCGIsInvalidExp(@NonNull CGIsInvalidExp cgElement) {
            Set childExternals = (Set)super.visitCGIsInvalidExp(cgElement);
            ((FieldingAnalyzer)this.context).setCaught(childExternals);
            return childExternals;
        }

        @Override
        @Nullable
        public Set<CGVariable> visitCGIsUndefinedExp(@NonNull CGIsUndefinedExp cgElement) {
            Set childExternals = (Set)super.visitCGIsUndefinedExp(cgElement);
            ((FieldingAnalyzer)this.context).setCaught(childExternals);
            return childExternals;
        }

        @Override
        @Nullable
        public Set<CGVariable> visitCGLetExp(@NonNull CGLetExp cgElement) {
            Set childExternals = (Set)super.visitCGLetExp(cgElement);
            CGVariable cgInit = cgElement.getInit();
            if (childExternals != null) {
                childExternals.remove(cgInit);
            }
            return childExternals;
        }

        @Override
        @Nullable
        public Set<CGVariable> visitCGOperationCallExp(@NonNull CGOperationCallExp cgElement) {
            Set childExternals = (Set)super.visitCGOperationCallExp(cgElement);
            if (cgElement.isValidating()) {
                ((FieldingAnalyzer)this.context).setCaught(childExternals);
            }
            return childExternals;
        }

        @Override
        @Nullable
        public Set<CGVariable> visitCGVariableExp(@NonNull CGVariableExp cgElement) {
            HashSet<CGVariable> childExternal = null;
            CGVariable cgVariable = cgElement.getReferredVariable();
            if (cgVariable != null) {
                childExternal = new HashSet<CGVariable>();
                childExternal.add(cgVariable);
            }
            return childExternal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RewriteVisitor
    extends AbstractExtendingCGModelVisitor<Boolean, CodeGenAnalyzer> {
        @NonNull
        protected final Set<CGVariable> caughtVariables;

        public RewriteVisitor(@NonNull CodeGenAnalyzer context, @NonNull Set<CGVariable> caughtVariables) {
            super(context);
            this.caughtVariables = caughtVariables;
        }

        protected void insertCatch(@NonNull CGValuedElement cgChild) {
            assert (!(cgChild instanceof CGCatchExp));
            if (!cgChild.isNonInvalid()) {
                CGCatchExp cgCatchExp = CGModelFactory.eINSTANCE.createCGCatchExp();
                CGUtils.wrap(cgCatchExp, cgChild);
            }
        }

        protected void insertThrow(@NonNull CGValuedElement cgChild) {
            assert (!(cgChild instanceof CGThrowExp));
            if (!cgChild.isNonInvalid()) {
                CGThrowExp cgThrowExp = CGModelFactory.eINSTANCE.createCGThrowExp();
                CGUtils.wrap(cgThrowExp, cgChild);
            }
        }

        protected void rewriteAsCaught(@Nullable CGValuedElement cgChild) {
            if (cgChild != null) {
                Boolean isCaught = cgChild.accept(this);
                assert (isCaught != null);
                if (isCaught == Boolean.FALSE) {
                    this.insertCatch(cgChild);
                }
            }
        }

        protected void rewriteAsThrown(@Nullable CGValuedElement cgChild) {
            if (cgChild != null) {
                Boolean isCaught = cgChild.accept(this);
                assert (isCaught != null);
                if (isCaught == Boolean.TRUE) {
                    this.insertThrow(cgChild);
                }
            }
        }

        @Override
        @NonNull
        public Boolean safeVisit(@Nullable CGElement cgElement) {
            if (cgElement != null && cgElement.accept(this).booleanValue()) {
                return true;
            }
            return false;
        }

        @Override
        @NonNull
        public Boolean visiting(@NonNull CGElement visitable) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        @Override
        @Nullable
        public Boolean visitCGConstant(@NonNull CGConstant cgConstant) {
            return false;
        }

        @Override
        @Nullable
        public Boolean visitCGConstantExp(@NonNull CGConstantExp cgElement) {
            return this.safeVisit(cgElement.getReferredConstant());
        }

        @Override
        @NonNull
        public Boolean visitCGElement(@NonNull CGElement cgElement) {
            boolean isCaught = false;
            for (CGElement cGElement : cgElement.getChildren()) {
                if (cGElement == null || !cGElement.accept(this).booleanValue()) continue;
                isCaught = true;
            }
            return isCaught;
        }

        @Override
        @NonNull
        public Boolean visitCGEqualsExp(@NonNull CGEqualsExp cgElement) {
            this.rewriteAsThrown(cgElement.getSource());
            this.rewriteAsThrown(cgElement.getArgument());
            cgElement.setCaught(false);
            return false;
        }

        @Override
        @NonNull
        public Boolean visitCGIfExp(@NonNull CGIfExp cgElement) {
            boolean elseIsCaught;
            CGValuedElement cgCondition = cgElement.getCondition();
            CGValuedElement cgThen = cgElement.getThenExpression();
            CGValuedElement cgElse = cgElement.getElseExpression();
            boolean conditionIsCaught = cgCondition != null && cgCondition.accept(this) != false;
            boolean thenIsCaught = cgThen != null && cgThen.accept(this) != false;
            boolean bl = elseIsCaught = cgElse != null && cgElse.accept(this) != false;
            if (!conditionIsCaught || thenIsCaught != elseIsCaught) {
                if (cgThen != null && thenIsCaught) {
                    this.insertThrow(cgThen);
                }
                if (cgElse != null && elseIsCaught) {
                    this.insertThrow(cgElse);
                }
            }
            boolean isCaught = conditionIsCaught && thenIsCaught && elseIsCaught;
            cgElement.setCaught(false);
            return isCaught;
        }

        @Override
        @Nullable
        public Boolean visitCGInvalid(@NonNull CGInvalid object) {
            return true;
        }

        @Override
        @NonNull
        public Boolean visitCGIsInvalidExp(@NonNull CGIsInvalidExp cgElement) {
            this.rewriteAsCaught(cgElement.getSource());
            cgElement.setCaught(false);
            return false;
        }

        @Override
        @NonNull
        public Boolean visitCGIsUndefinedExp(@NonNull CGIsUndefinedExp cgElement) {
            this.rewriteAsCaught(cgElement.getSource());
            cgElement.setCaught(false);
            return false;
        }

        @Override
        @NonNull
        public Boolean visitCGIterationCallExp(@NonNull CGIterationCallExp cgElement) {
            this.rewriteAsThrown(cgElement.getSource());
            for (CGIterator cgIterator : cgElement.getIterators()) {
                cgIterator.accept(this);
            }
            this.rewriteAsThrown(cgElement.getBody());
            cgElement.setCaught(false);
            return false;
        }

        @Override
        @NonNull
        public Boolean visitCGIterator(@NonNull CGIterator cgElement) {
            this.rewriteAsThrown(cgElement.getInit());
            cgElement.setCaught(false);
            return false;
        }

        @Override
        @NonNull
        public Boolean visitCGLetExp(@NonNull CGLetExp cgElement) {
            this.safeVisit(cgElement.getInit());
            boolean isCaught = this.safeVisit(cgElement.getIn());
            cgElement.setCaught(false);
            return isCaught;
        }

        @Override
        @NonNull
        public Boolean visitCGLibraryIterateCallExp(@NonNull CGLibraryIterateCallExp cgElement) {
            this.safeVisit(cgElement.getResult());
            boolean isCaught = super.visitCGLibraryIterateCallExp(cgElement) == Boolean.TRUE;
            return isCaught;
        }

        @Override
        @NonNull
        public Boolean visitCGOperationCallExp(@NonNull CGOperationCallExp cgElement) {
            List<CGValuedElement> cgArguments = cgElement.getArguments();
            int iSize = cgArguments.size();
            if (cgElement.isValidating()) {
                this.rewriteAsCaught(cgElement.getSource());
                int i = 0;
                while (i < iSize) {
                    this.rewriteAsCaught(cgArguments.get(i));
                    ++i;
                }
            } else {
                this.rewriteAsThrown(cgElement.getSource());
                int i = 0;
                while (i < iSize) {
                    this.rewriteAsThrown(cgArguments.get(i));
                    ++i;
                }
            }
            cgElement.setCaught(false);
            return false;
        }

        @Override
        @NonNull
        public Boolean visitCGPropertyCallExp(@NonNull CGPropertyCallExp cgElement) {
            this.rewriteAsThrown(cgElement.getSource());
            cgElement.setCaught(false);
            return false;
        }

        @Override
        @NonNull
        public Boolean visitCGValuedElement(@NonNull CGValuedElement cgElement) {
            boolean isCaught = super.visitCGValuedElement(cgElement) == Boolean.TRUE;
            cgElement.setCaught(isCaught);
            return isCaught;
        }

        @Override
        @NonNull
        public Boolean visitCGVariable(@NonNull CGVariable cgElement) {
            boolean isCaught = false;
            CGValuedElement cgInit = cgElement.getInit();
            if (cgInit != null) {
                if (cgInit.accept(this).booleanValue()) {
                    isCaught = true;
                } else if (this.caughtVariables.contains(cgElement)) {
                    this.insertCatch(cgInit);
                    isCaught = true;
                }
            }
            cgElement.setCaught(isCaught);
            return isCaught;
        }

        @Override
        @NonNull
        public Boolean visitCGVariableExp(@NonNull CGVariableExp cgElement) {
            boolean isCaught = this.caughtVariables.contains(cgElement.getReferredVariable());
            return isCaught;
        }
    }
}

