/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCatchExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGGuardExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGString;
import org.eclipse.ocl.examples.codegen.cgmodel.CGThrowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.ids.ClassId;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.DataTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.EnumerationId;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.LambdaTypeId;
import org.eclipse.ocl.examples.domain.ids.MetaclassId;
import org.eclipse.ocl.examples.domain.ids.NestedPackageId;
import org.eclipse.ocl.examples.domain.ids.NsURIPackageId;
import org.eclipse.ocl.examples.domain.ids.OclInvalidTypeId;
import org.eclipse.ocl.examples.domain.ids.OclVoidTypeId;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.RootPackageId;
import org.eclipse.ocl.examples.domain.ids.TemplateBinding;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TemplateableTypeId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.ids.UnspecifiedId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.InvalidValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.pivot.BagType;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LiteralExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.OrderedSetType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.SequenceType;
import org.eclipse.ocl.examples.pivot.SetType;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;

public class NameManager {
    public static final String BAG_NAME_HINT_PREFIX = "BAG";
    public static final String COLLECTION_NAME_HINT_PREFIX = "COL";
    public static final String DEFAULT_NAME_PREFIX = "symbol";
    public static final String EXPRESSION_IN_OCL_NAME_HINT_PREFIX = "result";
    public static final String INTEGER_NAME_HINT_PREFIX = "INT_";
    public static final String INVALID_NAME_HINT_PREFIX = "IVE_";
    public static final String ITERATION_NAME_HINT_PREFIX = "";
    public static final String OPERATION_NAME_HINT_PREFIX = "OP_";
    public static final String OPERATION_CALL_EXP_NAME_HINT_PREFIX = "";
    public static final String ORDERED_SET_NAME_HINT_PREFIX = "ORD";
    public static final String PROPERTY_NAME_HINT_PREFIX = "";
    public static final String REAL_NAME_HINT_PREFIX = "REA_";
    public static final String RANGE_NAME_HINT_PREFIX = "RNG";
    public static final String SEQUENCE_NAME_HINT_PREFIX = "SEQ";
    public static final String SET_NAME_HINT_PREFIX = "SET";
    public static final String STRING_NAME_HINT_PREFIX = "STR_";
    public static final String TYPE_NAME_HINT_PREFIX = "TYP_";
    public static final String VARIABLE_DECLARATION_NAME_HINT_PREFIX = "";
    public static final Set<String> reservedJavaNames = new HashSet<String>();
    @NonNull
    public static IdVisitor<String> idVisitor = new IdVisitor<String>(){

        @NonNull
        public String visitClassId(@NonNull ClassId id) {
            return "CLSSid_" + id.getName();
        }

        @NonNull
        public String visitCollectionTypeId(@NonNull CollectionTypeId id) {
            CollectionTypeId generalizedId = id.getGeneralizedId();
            String idPrefix = generalizedId == TypeId.BAG ? "BAG_" : (generalizedId == TypeId.ORDERED_SET ? "ORD_" : (generalizedId == TypeId.SEQUENCE ? "SEQ_" : (generalizedId == TypeId.SET ? "SET_" : "COL_")));
            if (generalizedId == id) {
                return idPrefix;
            }
            return String.valueOf(idPrefix) + (String)id.getElementTypeId().accept((IdVisitor)this);
        }

        @NonNull
        public String visitDataTypeId(@NonNull DataTypeId id) {
            return "DATAid_" + id.getName();
        }

        @NonNull
        public String visitEnumerationId(@NonNull EnumerationId id) {
            return "ENUMid_" + id.getName();
        }

        @NonNull
        public String visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
            return "ELITid_" + id.getName();
        }

        @NonNull
        public String visitInvalidId(@NonNull OclInvalidTypeId id) {
            return "INVid";
        }

        @NonNull
        public String visitLambdaTypeId(@NonNull LambdaTypeId id) {
            return "LAMBid_" + id.getName();
        }

        @NonNull
        public String visitMetaclassId(@NonNull MetaclassId id) {
            return "METAid_" + id.getName();
        }

        @NonNull
        public String visitNestedPackageId(@NonNull NestedPackageId id) {
            return "PACKid_" + id.getName();
        }

        @NonNull
        public String visitNsURIPackageId(@NonNull NsURIPackageId id) {
            return "PACKid_" + id.getNsURI();
        }

        @NonNull
        public String visitNullId(@NonNull OclVoidTypeId id) {
            return "NULLid";
        }

        @NonNull
        public String visitOperationId(@NonNull OperationId id) {
            return "OPid_" + id.getName();
        }

        @NonNull
        public String visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
            return "PRIMid_" + id.getName();
        }

        @NonNull
        public String visitPropertyId(@NonNull PropertyId id) {
            return "PROPid_" + id.getName();
        }

        @NonNull
        public String visitRootPackageId(@NonNull RootPackageId id) {
            return "PACKid_" + id.getName();
        }

        @NonNull
        public String visitTemplateBinding(@NonNull TemplateBinding id) {
            return "BINDid_";
        }

        @NonNull
        public String visitTemplateParameterId(@NonNull TemplateParameterId id) {
            return "TMPLid_";
        }

        @NonNull
        public String visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
            return "TYPEid_";
        }

        @NonNull
        public String visitTuplePartId(@NonNull TuplePartId id) {
            return "PARTid_";
        }

        @NonNull
        public String visitTupleTypeId(@NonNull TupleTypeId id) {
            return "TUPLid_";
        }

        @NonNull
        public String visitUnspecifiedId(@NonNull UnspecifiedId id) {
            return "UNSPid_";
        }
    };
    @NonNull
    private Context context;

    protected static void appendJavaCharacters(StringBuilder s, String string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                s.append(c);
            } else {
                s.append('_');
            }
            ++i;
        }
    }

    protected static void appendJavaCharacters(StringBuilder s, String string, int iMax) {
        int i = 0;
        while (i < Math.min(iMax, string.length())) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                s.append(c);
            } else {
                s.append('_');
            }
            ++i;
        }
    }

    @NonNull
    private static String getValidJavaIdentifier(@NonNull String nameHint, boolean hasPrefix, @Nullable Object anObject) {
        if (nameHint.equals("<")) {
            return "lt";
        }
        if (nameHint.equals("<=")) {
            return "le";
        }
        if (nameHint.equals("=")) {
            return "eq";
        }
        if (nameHint.equals("<>")) {
            return "ne";
        }
        if (nameHint.equals(">=")) {
            return "ge";
        }
        if (nameHint.equals(">")) {
            return "gt";
        }
        if (nameHint.equals("+")) {
            return "sum";
        }
        if (nameHint.equals("-")) {
            return anObject instanceof Operation && ((Operation)anObject).getOwnedParameter().size() <= 0 ? "neg" : "diff";
        }
        if (nameHint.equals("*")) {
            return "prod";
        }
        if (nameHint.equals("/")) {
            return "quot";
        }
        if (nameHint.equals("1_")) {
            return "_1";
        }
        if (nameHint.equals("2_")) {
            return "_2";
        }
        StringBuilder s = new StringBuilder();
        Character prefix = null;
        int length = nameHint.length();
        int i = 0;
        while (i < length) {
            char c = nameHint.charAt(i);
            if (i == 0 && !hasPrefix ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c)) {
                if (prefix != null) {
                    s.append(prefix);
                    prefix = null;
                }
                s.append(c);
            } else {
                if (c == '*') {
                    s.append("_a");
                } else if (c == ':') {
                    s.append("_c");
                } else if (c == '.') {
                    if (prefix != null) {
                        s.append(prefix);
                        prefix = null;
                    }
                } else if (c == ')') {
                    s.append("_e");
                } else if (c == '>') {
                    s.append("_g");
                } else if (c == '<') {
                    s.append("_l");
                } else if (c == '-') {
                    s.append("_m");
                } else if (c == '(') {
                    s.append("_o");
                } else if (c == '+') {
                    s.append("_p");
                } else if (c == '=') {
                    s.append("_q");
                } else if (c == '/') {
                    s.append("_s");
                } else {
                    s.append(String.valueOf('_') + Integer.toString(c));
                }
                prefix = Character.valueOf('_');
            }
            ++i;
        }
        String string = s.toString();
        return string;
    }

    public NameManager() {
        reservedJavaNames.add("Boolean");
        reservedJavaNames.add("Character");
        reservedJavaNames.add("Class");
        reservedJavaNames.add("Double");
        reservedJavaNames.add("Float");
        reservedJavaNames.add("Integer");
        reservedJavaNames.add("List");
        reservedJavaNames.add("Long");
        reservedJavaNames.add("Map");
        reservedJavaNames.add("Package");
        reservedJavaNames.add("String");
        reservedJavaNames.add("boolean");
        reservedJavaNames.add("byte");
        reservedJavaNames.add("char");
        reservedJavaNames.add("double");
        reservedJavaNames.add("float");
        reservedJavaNames.add("int");
        reservedJavaNames.add("long");
        reservedJavaNames.add("short");
        reservedJavaNames.add("void");
        reservedJavaNames.add("abstract");
        reservedJavaNames.add("assert");
        reservedJavaNames.add("break");
        reservedJavaNames.add("case");
        reservedJavaNames.add("catch");
        reservedJavaNames.add("class");
        reservedJavaNames.add("const");
        reservedJavaNames.add("continue");
        reservedJavaNames.add("default");
        reservedJavaNames.add("do");
        reservedJavaNames.add("else");
        reservedJavaNames.add("enum");
        reservedJavaNames.add("extends");
        reservedJavaNames.add("final");
        reservedJavaNames.add("finally");
        reservedJavaNames.add("for");
        reservedJavaNames.add("goto");
        reservedJavaNames.add("if");
        reservedJavaNames.add("implements");
        reservedJavaNames.add("import");
        reservedJavaNames.add("instanceof");
        reservedJavaNames.add("interface");
        reservedJavaNames.add("native");
        reservedJavaNames.add("new");
        reservedJavaNames.add("package");
        reservedJavaNames.add("private");
        reservedJavaNames.add("protected");
        reservedJavaNames.add("public");
        reservedJavaNames.add("return");
        reservedJavaNames.add("static");
        reservedJavaNames.add("strictfp");
        reservedJavaNames.add("switch");
        reservedJavaNames.add("synchronized");
        reservedJavaNames.add("throw");
        reservedJavaNames.add("throws");
        reservedJavaNames.add("transient");
        reservedJavaNames.add("try");
        reservedJavaNames.add("volatile");
        reservedJavaNames.add("while");
        reservedJavaNames.add("false");
        reservedJavaNames.add("null");
        reservedJavaNames.add("super");
        reservedJavaNames.add("this");
        reservedJavaNames.add("true");
        this.context = new Context();
    }

    @NonNull
    public Context createNestedContext() {
        return new Context(this.context);
    }

    @NonNull
    public String getExplicitName(@Nullable Object anObject) {
        if (anObject == null) {
            return "null";
        }
        if (anObject instanceof Boolean) {
            return (Boolean)anObject != false ? "true" : "false";
        }
        return "<null-" + anObject.getClass().getSimpleName() + ">";
    }

    @NonNull
    public String getGlobalSymbolName(@Nullable Object anObject, String ... nameHints) {
        if (nameHints != null && nameHints.length > 0) {
            return this.getGlobalUniqueName(anObject, nameHints);
        }
        return this.getGlobalUniqueName(anObject, anObject != null ? this.getNameHint(anObject) : null);
    }

    @NonNull
    protected String getGlobalUniqueName(@Nullable Object anObject, String ... nameHints) {
        return this.context.getGlobalUniqueName(anObject, nameHints);
    }

    protected String getIterationNameHint(@NonNull Iteration anIteration) {
        String string = anIteration.getName();
        return NameManager.getValidJavaIdentifier(string, "".length() > 0, anIteration);
    }

    protected String getKindHint(@NonNull String kind) {
        if ("Bag".equals(kind)) {
            return BAG_NAME_HINT_PREFIX;
        }
        if ("OrderedSet".equals(kind)) {
            return ORDERED_SET_NAME_HINT_PREFIX;
        }
        if ("Sequence".equals(kind)) {
            return SEQUENCE_NAME_HINT_PREFIX;
        }
        if ("Set".equals(kind)) {
            return SET_NAME_HINT_PREFIX;
        }
        return COLLECTION_NAME_HINT_PREFIX;
    }

    @Nullable
    public String getNameHint(@NonNull Object anObject) {
        if (anObject instanceof CGValuedElement) {
            anObject = ((CGValuedElement)anObject).getValue();
        }
        if (anObject instanceof CollectionLiteralExp) {
            Type type = ((CollectionLiteralExp)anObject).getType();
            return type != null ? this.getTypeNameHint((DomainType)type) : null;
        }
        if (anObject instanceof CollectionRange) {
            return RANGE_NAME_HINT_PREFIX;
        }
        if (anObject instanceof CGCollectionPart) {
            return RANGE_NAME_HINT_PREFIX;
        }
        if (anObject instanceof InvalidValue) {
            return INVALID_NAME_HINT_PREFIX;
        }
        if (anObject instanceof CollectionValue) {
            String kind = ((CollectionValue)anObject).getKind();
            return kind != null ? this.getKindHint(kind) : null;
        }
        if (anObject instanceof CGCollectionExp) {
            String kind = ((CGCollectionExp)anObject).getName();
            return kind != null ? this.getKindHint(kind) : null;
        }
        if (anObject instanceof ElementId) {
            String nameHint = (String)((ElementId)anObject).accept(idVisitor);
            return nameHint;
        }
        if (anObject instanceof ExpressionInOCL) {
            return EXPRESSION_IN_OCL_NAME_HINT_PREFIX;
        }
        if (anObject instanceof IntegerLiteralExp) {
            Number numberSymbol = ((IntegerLiteralExp)anObject).getIntegerSymbol();
            return numberSymbol != null ? this.getNumericNameHint(numberSymbol) : null;
        }
        if (anObject instanceof IntegerRange) {
            return RANGE_NAME_HINT_PREFIX;
        }
        if (anObject instanceof IntegerValue) {
            Number numberSymbol = ((IntegerValue)anObject).asNumber();
            return this.getNumericNameHint(numberSymbol);
        }
        if (anObject instanceof LoopExp) {
            Iteration referredIteration = ((LoopExp)anObject).getReferredIteration();
            return referredIteration != null ? this.getIterationNameHint(referredIteration) : null;
        }
        if (anObject instanceof Number) {
            return this.getNumericNameHint((Number)anObject);
        }
        if (anObject instanceof Operation) {
            return this.getOperationNameHint((Operation)anObject);
        }
        if (anObject instanceof OperationCallExp) {
            Operation referredOperation = ((OperationCallExp)anObject).getReferredOperation();
            return referredOperation != null ? this.getOperationCallExpNameHint(referredOperation) : null;
        }
        if (anObject instanceof PropertyCallExp) {
            Property referredProperty = ((PropertyCallExp)anObject).getReferredProperty();
            return referredProperty != null ? this.getPropertyNameHint(referredProperty) : null;
        }
        if (anObject instanceof CGCallExp) {
            if (anObject instanceof CGPropertyCallExp) {
                Property referredProperty = ((PropertyCallExp)((CGPropertyCallExp)anObject).getPivot()).getReferredProperty();
                return referredProperty != null ? this.getPropertyNameHint(referredProperty) : null;
            }
            if (anObject instanceof CGIterationCallExp) {
                Iteration referredIteration = ((LoopExp)((CGIterationCallExp)anObject).getPivot()).getReferredIteration();
                return referredIteration != null ? this.getIterationNameHint(referredIteration) : null;
            }
            if (anObject instanceof CGOperationCallExp) {
                Operation referredOperation = ((OperationCallExp)((CGOperationCallExp)anObject).getPivot()).getReferredOperation();
                return referredOperation != null ? this.getOperationCallExpNameHint(referredOperation) : null;
            }
            if (anObject instanceof CGBoxExp) {
                return "BOXED_" + ((CGCallExp)anObject).getReferredValuedElement().getValueName();
            }
            if (anObject instanceof CGUnboxExp) {
                return "UNBOXED_" + ((CGCallExp)anObject).getReferredValuedElement().getValueName();
            }
            if (anObject instanceof CGCatchExp) {
                return "CAUGHT_" + ((CGCallExp)anObject).getReferredValuedElement().getValueName();
            }
            if (anObject instanceof CGGuardExp) {
                return "GUARDED_" + ((CGCallExp)anObject).getReferredValuedElement().getValueName();
            }
            if (anObject instanceof CGThrowExp) {
                return "THROWN_" + ((CGCallExp)anObject).getReferredValuedElement().getValueName();
            }
            return null;
        }
        if (anObject instanceof RealLiteralExp) {
            Number numberSymbol = ((RealLiteralExp)anObject).getRealSymbol();
            return numberSymbol != null ? this.getNumericNameHint(numberSymbol) : null;
        }
        if (anObject instanceof RealValue) {
            Number numberSymbol = ((RealValue)anObject).asNumber();
            return this.getNumericNameHint(numberSymbol);
        }
        if (anObject instanceof String) {
            return this.getStringNameHint((String)anObject);
        }
        if (anObject instanceof CGString) {
            String stringValue = ((CGString)anObject).getStringValue();
            return stringValue != null ? this.getStringNameHint(stringValue) : null;
        }
        if (anObject instanceof StringLiteralExp) {
            String stringSymbol = ((StringLiteralExp)anObject).getStringSymbol();
            return stringSymbol != null ? this.getStringNameHint(stringSymbol) : null;
        }
        if (anObject instanceof DomainType) {
            return this.getTypeNameHint((DomainType)anObject);
        }
        if (anObject instanceof CGTypeId) {
            NamedElement type = ((CGTypeId)anObject).getPivot();
            return type instanceof DomainType ? this.getTypeNameHint((DomainType)type) : null;
        }
        if (anObject instanceof TypeExp) {
            Type referredType = ((TypeExp)anObject).getType();
            return referredType != null ? this.getTypeNameHint((DomainType)referredType) : null;
        }
        if (anObject instanceof UnlimitedNaturalLiteralExp) {
            Number numberSymbol = ((UnlimitedNaturalLiteralExp)anObject).getUnlimitedNaturalSymbol();
            return numberSymbol != null ? this.getNumericNameHint(numberSymbol) : null;
        }
        if (anObject instanceof VariableExp) {
            VariableDeclaration referredVariable = ((VariableExp)anObject).getReferredVariable();
            return referredVariable != null ? this.getVariableDeclarationNameHint(referredVariable) : null;
        }
        if (anObject instanceof LiteralExp) {
            return "literal";
        }
        if (anObject instanceof Nameable) {
            String name = ((Nameable)anObject).getName();
            return name != null ? NameManager.getValidJavaIdentifier(name, false, anObject) : null;
        }
        return null;
    }

    protected String getNumericNameHint(@NonNull Number aNumber) {
        String string = aNumber.toString();
        if (aNumber instanceof BigInteger || aNumber instanceof Long || aNumber instanceof Integer || aNumber instanceof Short) {
            return INTEGER_NAME_HINT_PREFIX + string;
        }
        if (aNumber instanceof BigDecimal || aNumber instanceof Double || aNumber instanceof Float) {
            return REAL_NAME_HINT_PREFIX + NameManager.getValidJavaIdentifier(string, REAL_NAME_HINT_PREFIX.length() > 0, aNumber);
        }
        return null;
    }

    protected String getOperationNameHint(@NonNull Operation anOperation) {
        String string = anOperation.toString();
        return OPERATION_NAME_HINT_PREFIX + NameManager.getValidJavaIdentifier(string, OPERATION_NAME_HINT_PREFIX.length() > 0, anOperation);
    }

    protected String getOperationCallExpNameHint(@NonNull Operation anOperation) {
        String string = anOperation.getName();
        return NameManager.getValidJavaIdentifier(string, "".length() > 0, anOperation);
    }

    protected String getPropertyNameHint(@NonNull Property aProperty) {
        String string = aProperty.getName();
        return NameManager.getValidJavaIdentifier(string, "".length() > 0, aProperty);
    }

    protected String getStringNameHint(@NonNull String aString) {
        String string = aString.length() > 20 ? aString.substring(0, 20) : aString;
        return STRING_NAME_HINT_PREFIX + NameManager.getValidJavaIdentifier(string, STRING_NAME_HINT_PREFIX.length() > 0, aString);
    }

    protected String getTypeNameHint(@NonNull DomainType aType) {
        if (aType instanceof CollectionType) {
            if (aType instanceof OrderedSetType) {
                return ORDERED_SET_NAME_HINT_PREFIX;
            }
            if (aType instanceof SetType) {
                return SET_NAME_HINT_PREFIX;
            }
            if (aType instanceof SequenceType) {
                return SEQUENCE_NAME_HINT_PREFIX;
            }
            if (aType instanceof BagType) {
                return BAG_NAME_HINT_PREFIX;
            }
            return COLLECTION_NAME_HINT_PREFIX;
        }
        String string = aType.toString();
        return TYPE_NAME_HINT_PREFIX + NameManager.getValidJavaIdentifier(string, TYPE_NAME_HINT_PREFIX.length() > 0, aType);
    }

    protected String getVariableDeclarationNameHint(@NonNull VariableDeclaration aVariableDeclaration) {
        String string = (String)DomainUtil.nonNullModel((Object)aVariableDeclaration.getName());
        return NameManager.getValidJavaIdentifier(string, "".length() > 0, aVariableDeclaration);
    }

    @NonNull
    public String reserveName(@NonNull String name, @Nullable Object anObject) {
        return this.context.getSymbolName(anObject, name);
    }

    public class Context {
        @Nullable
        private final Context context;
        @NonNull
        private final Map<String, Object> name2object;
        @NonNull
        private final Map<Object, String> object2name;
        private Map<String, Integer> name2counter;

        public Context() {
            this.context = null;
            this.name2object = new HashMap<String, Object>();
            this.object2name = new HashMap<Object, String>();
            this.name2counter = null;
        }

        public Context(Context context) {
            this.context = context;
            this.name2object = new HashMap<String, Object>(context.name2object);
            this.object2name = new HashMap<Object, String>(context.object2name);
            this.name2counter = context.name2counter != null ? new HashMap<String, Integer>(context.name2counter) : null;
        }

        @NonNull
        public Context createNestedContext() {
            return new Context(this);
        }

        @NonNull
        public Context getContext() {
            return (Context)DomainUtil.nonNullState((Object)this.context);
        }

        @NonNull
        protected String getGlobalUniqueName(@Nullable Object anObject, String ... nameHints) {
            if (this.context != null) {
                return this.context.getGlobalUniqueName(anObject, nameHints);
            }
            return this.getUniqueName(anObject, nameHints);
        }

        @NonNull
        public String getSymbolName(@Nullable Object anObject, String ... nameHints) {
            if (nameHints != null && nameHints.length > 0 && nameHints[0] != null) {
                return this.getUniqueName(anObject, nameHints);
            }
            return this.getUniqueName(anObject, anObject != null ? NameManager.this.getNameHint(anObject) : null);
        }

        @NonNull
        public String getUniqueName(@Nullable Object anObject, String ... nameHints) {
            Integer counter;
            int count;
            String knownName;
            if (anObject instanceof RealValue && !(anObject instanceof InvalidValue)) {
                anObject = ((RealValue)anObject).asNumber();
            }
            if (anObject != null && (knownName = this.object2name.get(anObject)) != null) {
                return knownName;
            }
            String lastResort = null;
            if (nameHints != null) {
                String[] stringArray = nameHints;
                int n = nameHints.length;
                int n2 = 0;
                while (n2 < n) {
                    String validHint;
                    String nameHint = stringArray[n2];
                    if (nameHint != null && !reservedJavaNames.contains(validHint = NameManager.getValidJavaIdentifier(nameHint, false, anObject))) {
                        if (anObject != null) {
                            Object oldElement = this.name2object.get(validHint);
                            if (oldElement == anObject) {
                                return validHint;
                            }
                            if (oldElement == null && !this.name2object.containsKey(validHint)) {
                                this.install(validHint, anObject);
                                return validHint;
                            }
                        } else if (!this.name2object.containsKey(validHint)) {
                            this.install(validHint, anObject);
                            return validHint;
                        }
                        if (lastResort == null) {
                            lastResort = validHint;
                        }
                    }
                    ++n2;
                }
            }
            if (lastResort == null) {
                lastResort = NameManager.DEFAULT_NAME_PREFIX;
            }
            if (this.name2counter == null) {
                this.name2counter = new HashMap<String, Integer>();
            }
            int n = count = (counter = this.name2counter.get(lastResort)) != null ? counter : 0;
            while (true) {
                String attempt;
                if (!this.name2object.containsKey(attempt = String.valueOf(lastResort) + "_" + Integer.toString(count))) {
                    this.install(attempt, anObject);
                    this.name2counter.put(lastResort, ++count);
                    return attempt;
                }
                ++count;
            }
        }

        private void install(@NonNull String name, @Nullable Object anObject) {
            assert (!(anObject instanceof RealValue) || anObject instanceof InvalidValue);
            this.name2object.put(name, anObject);
            if (anObject != null) {
                this.object2name.put(anObject, name);
            }
        }
    }
}

