/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.generator;

import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.GenModelException;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.library.AbstractOperation;
import org.eclipse.ocl.examples.domain.library.AbstractTernaryOperation;
import org.eclipse.ocl.examples.domain.library.AbstractUnaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryTernaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryUnaryOperation;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractGenModelHelper
implements GenModelHelper {
    @NonNull
    public static final String TABLES_CLASS_SUFFIX = "Tables";
    @NonNull
    public static final String TABLES_PACKAGE_NAME = "";
    @NonNull
    protected final MetaModelManager metaModelManager;

    public static String encodeName(@NonNull NamedElement element) {
        int arity = element instanceof DomainOperation ? ((DomainOperation)element).getOwnedParameter().size() : 0;
        String rawEncodeName = AbstractGenModelHelper.rawEncodeName((String)DomainUtil.nonNullModel((Object)element.getName()), arity);
        if (element instanceof DomainOperation) {
            int sameNames = 0;
            int myIndex = 0;
            for (DomainOperation operation : ((DomainOperation)element).getOwningType().getOwnedOperation()) {
                String rawName = AbstractGenModelHelper.rawEncodeName((String)DomainUtil.nonNullModel((Object)operation.getName()), (Integer)DomainUtil.nonNullModel((Object)operation.getOwnedParameter().size()));
                if (!rawName.equals(rawEncodeName)) continue;
                if (operation == element) {
                    myIndex = sameNames;
                }
                ++sameNames;
            }
            if (sameNames > 1) {
                return String.valueOf(myIndex) + "_" + rawEncodeName;
            }
        }
        return rawEncodeName;
    }

    @NonNull
    public static String rawEncodeName(@NonNull String name, @NonNull Integer arity) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch == '<') {
                s.append("_lt_");
            } else if (ch == '>') {
                s.append("_gt_");
            } else if (ch == '=') {
                s.append("_eq_");
            } else if (ch == '+') {
                s.append("_add_");
            } else if (ch == '-') {
                if (arity == 0) {
                    s.append("_neg_");
                } else {
                    s.append("_sub_");
                }
            } else if (ch == '*') {
                s.append("_mul_");
            } else if (ch == '/') {
                s.append("_div_");
            } else if (!Character.isJavaIdentifierPart(ch)) {
                s.append("_" + Integer.toString(ch) + "_");
            } else {
                s.append(ch);
            }
            ++i;
        }
        String string = s.toString();
        return string;
    }

    public AbstractGenModelHelper(@NonNull MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    @Override
    @NonNull
    public Class<?> getAbstractOperationClass(@NonNull List<?> parameters) {
        switch (parameters.size()) {
            case 0: {
                return AbstractUnaryOperation.class;
            }
            case 1: {
                return AbstractBinaryOperation.class;
            }
            case 2: {
                return AbstractTernaryOperation.class;
            }
        }
        return AbstractOperation.class;
    }

    @Override
    @NonNull
    public Class<?> getEcoreInterfaceClass(@NonNull Type type) throws GenModelException {
        String qualifiedInterfaceName;
        GenClassifier genClassifier = this.getGenClassifier(type);
        if (genClassifier instanceof GenDataType) {
            qualifiedInterfaceName = ((GenDataType)genClassifier).getQualifiedInstanceClassName();
            Class<?> primitiveClass = JavaCodeGenerator.javaPrimitiveNames.get(qualifiedInterfaceName);
            if (primitiveClass != null) {
                return primitiveClass;
            }
        } else {
            qualifiedInterfaceName = ((GenClass)genClassifier).getQualifiedInterfaceName();
        }
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            Class<?> loadedClass = contextClassLoader.loadClass(qualifiedInterfaceName);
            return loadedClass;
        }
        catch (Exception e) {
            throw new GenModelException("Failed to load class for " + type);
        }
    }

    @Override
    @NonNull
    public Class<?> getEcoreInterfaceClass(@NonNull EClass eClass) throws GenModelException {
        String qualifiedInterfaceName;
        GenClass genClassifier = this.getGenClass(eClass);
        if (genClassifier instanceof GenDataType) {
            qualifiedInterfaceName = ((GenDataType)genClassifier).getQualifiedInstanceClassName();
            Class<?> primitiveClass = JavaCodeGenerator.javaPrimitiveNames.get(qualifiedInterfaceName);
            if (primitiveClass != null) {
                return primitiveClass;
            }
        } else {
            qualifiedInterfaceName = genClassifier.getQualifiedInterfaceName();
        }
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            Class<?> loadedClass = contextClassLoader.loadClass(qualifiedInterfaceName);
            return loadedClass;
        }
        catch (Exception e) {
            throw new GenModelException("Failed to load class for " + eClass);
        }
    }

    @Override
    @Nullable
    public String getEcoreInterfaceClassName(@NonNull EClass eClass) throws GenModelException {
        try {
            GenClass genClassifier = this.getGenClass(eClass);
            String qualifiedInterfaceName = genClassifier instanceof GenDataType ? ((GenDataType)genClassifier).getQualifiedInstanceClassName() : genClassifier.getQualifiedInterfaceName();
            return qualifiedInterfaceName;
        }
        catch (GenModelException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public String getEcoreInterfaceClassifierName(@NonNull EClassifier eClassifier) throws GenModelException {
        try {
            GenClassifier genClassifier = this.getGenClassifier(eClassifier);
            String qualifiedInterfaceName = genClassifier instanceof GenDataType ? ((GenDataType)genClassifier).getQualifiedInstanceClassName() : ((GenClass)genClassifier).getQualifiedInterfaceName();
            return qualifiedInterfaceName;
        }
        catch (GenModelException e) {
            return null;
        }
    }

    @NonNull
    protected GenClass getGenClass(@NonNull Type type) throws GenModelException {
        GenPackage genPackage = this.getGenPackage(type);
        if (genPackage != null) {
            String name = type.getName();
            for (GenClass genClass : genPackage.getGenClasses()) {
                String clsName = genClass.getEcoreClass().getName();
                if (!name.equals(clsName)) continue;
                return genClass;
            }
        }
        throw new GenModelException("No GenClass for " + type);
    }

    @NonNull
    protected GenClass getGenClass(@NonNull EClass eClass) throws GenModelException {
        GenPackage genPackage = this.getGenPackage((EClassifier)eClass);
        if (genPackage != null) {
            String name = eClass.getName();
            for (GenClass genClass : genPackage.getGenClasses()) {
                String clsName = genClass.getEcoreClass().getName();
                if (!name.equals(clsName)) continue;
                return genClass;
            }
        }
        throw new GenModelException("No GenClass for " + eClass);
    }

    @NonNull
    protected GenClassifier getGenClassifier(@NonNull EClassifier eClassifier) throws GenModelException {
        GenPackage genPackage = this.getGenPackage(eClassifier);
        if (genPackage != null) {
            String name = eClassifier.getName();
            for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
                String clsName = genClassifier.getEcoreClassifier().getName();
                if (!name.equals(clsName)) continue;
                return genClassifier;
            }
        }
        throw new GenModelException("No GenClassifier for " + eClassifier);
    }

    @Override
    @NonNull
    public GenClassifier getGenClassifier(@NonNull Type type) throws GenModelException {
        GenPackage genPackage = this.getGenPackage(type);
        if (genPackage != null) {
            String name = type.getName();
            for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
                String clsName = genClassifier.getEcoreClassifier().getName();
                if (!name.equals(clsName)) continue;
                return genClassifier;
            }
        }
        throw new GenModelException("No GenClassifier for " + type);
    }

    @NonNull
    public GenFeature getGenFeature(@NonNull Property property) throws GenModelException {
        Type owningType = property.getOwningType();
        if (owningType != null) {
            GenClass genClass = this.getGenClass(owningType);
            String name = property.getName();
            for (GenFeature genFeature : genClass.getGenFeatures()) {
                String featureName = genFeature.getEcoreFeature().getName();
                if (!name.equals(featureName)) continue;
                return genFeature;
            }
        }
        throw new GenModelException("No GenFeature for " + property);
    }

    @NonNull
    public GenFeature getGenFeature(@NonNull EStructuralFeature eStructuralFeature) throws GenModelException {
        EClass eClass = eStructuralFeature.getEContainingClass();
        if (eClass != null) {
            GenClass genClass = this.getGenClass(eClass);
            String name = eStructuralFeature.getName();
            for (GenFeature genFeature : genClass.getGenFeatures()) {
                String featureName = genFeature.getEcoreFeature().getName();
                if (!name.equals(featureName)) continue;
                return genFeature;
            }
        }
        throw new GenModelException("No GenFeature for " + eStructuralFeature);
    }

    @Override
    @NonNull
    public GenOperation getGenOperation(@NonNull Operation operation) throws GenModelException {
        Type owningType = operation.getOwningType();
        if (owningType != null) {
            GenClass genClass = this.getGenClass(owningType);
            String name = operation.getName();
            for (GenOperation genOperation : genClass.getGenOperations()) {
                String operationName = genOperation.getEcoreOperation().getName();
                if (!name.equals(operationName)) continue;
                return genOperation;
            }
        }
        throw new GenModelException("No GenFeature for " + operation);
    }

    @Override
    @Nullable
    public GenPackage getGenPackage(@NonNull Type type) {
        GenPackage genPackage;
        String nsURI;
        Package pPackage = type.getPackage();
        if (pPackage == null) {
            return null;
        }
        EObject eContainer = pPackage.eContainer();
        if (eContainer instanceof Root && (nsURI = ((Root)eContainer).getExternalURI()) != null && (genPackage = this.metaModelManager.getGenPackage(nsURI)) != null) {
            return genPackage;
        }
        nsURI = pPackage.getNsURI();
        if (nsURI == null) {
            return null;
        }
        return this.metaModelManager.getGenPackage(nsURI);
    }

    @Nullable
    public GenPackage getGenPackage(@NonNull EClassifier eClassifier) {
        EPackage ePackage = eClassifier.getEPackage();
        if (ePackage == null) {
            return null;
        }
        return this.getGenPackage(ePackage);
    }

    @Nullable
    public GenPackage getGenPackage(@NonNull EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        if (nsURI == null) {
            return null;
        }
        return this.metaModelManager.getGenPackage(nsURI);
    }

    @Override
    @Nullable
    public GenParameter getGenParameter(@NonNull Parameter parameter) throws GenModelException {
        Operation operation = parameter.getOperation();
        if (operation != null) {
            int index = operation.getOwnedParameter().indexOf(parameter);
            GenOperation genOperation = this.getGenOperation(operation);
            EList genParameters = genOperation.getGenParameters();
            if (index >= 0 && index < genParameters.size()) {
                return (GenParameter)genParameters.get(index);
            }
        }
        throw new GenModelException("No GenParameter for " + parameter);
    }

    @Override
    @NonNull
    public String getGetAccessor(@NonNull Property aProperty) throws GenModelException {
        GenFeature genFeature = this.getGenFeature(aProperty);
        String getAccessor = genFeature.getGetAccessor();
        if (getAccessor != null) {
            return getAccessor;
        }
        throw new GenModelException("No GenFeature for " + aProperty);
    }

    @Override
    @NonNull
    public String getGetAccessor(@NonNull EStructuralFeature eStructuralFeature) throws GenModelException {
        GenFeature genFeature = this.getGenFeature(eStructuralFeature);
        String getAccessor = genFeature.getGetAccessor();
        if (getAccessor != null) {
            return getAccessor;
        }
        throw new GenModelException("No GenFeature for " + eStructuralFeature);
    }

    @Override
    @NonNull
    public String getLiteralName(@NonNull EClassifier eClassifier) {
        String name = eClassifier.getName();
        return CodeGenUtil.upperName((String)(name != null ? name : TABLES_PACKAGE_NAME));
    }

    @Override
    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @Override
    @NonNull
    public String getOperationAccessor(@NonNull Operation anOperation) throws GenModelException {
        GenOperation genOperation = this.getGenOperation(anOperation);
        String operationAccessor = genOperation.getName();
        if (operationAccessor != null) {
            return operationAccessor;
        }
        throw new GenModelException("No GenOperation for " + anOperation);
    }

    @Override
    @NonNull
    public Class<?> getOperationInterface(@NonNull List<? extends TypedElement> parameters) {
        switch (parameters.size()) {
            case 0: {
                return LibraryUnaryOperation.class;
            }
            case 1: {
                return LibraryBinaryOperation.class;
            }
            case 2: {
                return LibraryTernaryOperation.class;
            }
        }
        return LibraryOperation.class;
    }

    @Override
    @NonNull
    public String getOperationReturnType(@NonNull Operation operation) throws GenModelException {
        Type owningType = operation.getOwningType();
        if (owningType == null) {
            throw new GenModelException("No owningType for " + operation);
        }
        GenClass genClass = this.getGenClass(owningType);
        GenOperation genOperation = this.getGenOperation(operation);
        String returnType = genOperation.getType(genClass);
        if (returnType == null) {
            throw new GenModelException("No returnType for " + operation);
        }
        return returnType;
    }

    @Override
    @NonNull
    public String getPropertyResultType(@NonNull Property property) throws GenModelException {
        Type owningType = property.getOwningType();
        if (owningType == null) {
            throw new GenModelException("No owningType for " + property);
        }
        GenClass genClass = this.getGenClass(owningType);
        GenFeature genFeature = this.getGenFeature(property);
        String resultType = genFeature.getQualifiedObjectType(genClass);
        if (resultType == null) {
            throw new GenModelException("No resultType for " + property);
        }
        return resultType;
    }

    @Override
    @Nullable
    public String getQualifiedFactoryInterfaceName(@NonNull EPackage ePackage) {
        GenPackage genPackage = this.getGenPackage(ePackage);
        if (genPackage == null) {
            return null;
        }
        return genPackage.getQualifiedFactoryInterfaceName();
    }

    @Override
    @Nullable
    public String getQualifiedPackageInterfaceName(@NonNull EPackage ePackage) {
        GenPackage genPackage = this.getGenPackage(ePackage);
        if (genPackage == null) {
            return null;
        }
        return genPackage.getQualifiedPackageInterfaceName();
    }

    @Override
    @NonNull
    public String getQualifiedValidatorClassName(@NonNull GenPackage genPackage) {
        return (String)DomainUtil.nonNullEMF((Object)genPackage.getQualifiedValidatorClassName());
    }

    @Override
    @NonNull
    public String getSetAccessor(@NonNull EStructuralFeature eStructuralFeature) throws GenModelException {
        GenFeature genFeature = this.getGenFeature(eStructuralFeature);
        String setAccessor = genFeature.getAccessorName();
        if (setAccessor != null) {
            return "set" + setAccessor;
        }
        throw new GenModelException("No GenFeature for " + eStructuralFeature);
    }

    @Override
    @NonNull
    public String getTablesClassName(@NonNull GenPackage genPackage) {
        return ImportUtils.getAffixedName(String.valueOf(genPackage.getQualifiedPackageName()) + "." + genPackage.getPrefix() + TABLES_CLASS_SUFFIX);
    }
}

