/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.NameManager;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCastParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGText;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.LocalContext;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.AbstractJavaContext;
import org.eclipse.ocl.examples.codegen.java.JavaConstants;
import org.eclipse.ocl.examples.codegen.java.JavaGlobalContext;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaLocalContext
extends AbstractJavaContext
implements LocalContext {
    @NonNull
    protected final JavaGlobalContext globalContext;
    @Nullable
    protected final JavaLocalContext parentContext;
    @NonNull
    protected CGElement cgScope;
    @NonNull
    protected NameManager.Context nameManagerContext;
    private CGText idResolver = null;
    private Set<CGValuedElement> localVariables = null;
    private Map<CGParameter, CGParameter> castParameters = null;
    private CGParameter evaluatorParameter;
    private CGParameter typeIdParameter;
    private CGText standardLibrary;
    @NonNull
    private final Map<PropertyId, CGExecutorProperty> cgProperties = new HashMap<PropertyId, CGExecutorProperty>();
    @NonNull
    private final Map<TypeId, CGExecutorType> cgTypes = new HashMap<TypeId, CGExecutorType>();

    public JavaLocalContext(@NonNull JavaGlobalContext globalContext, @NonNull CGElement cgScope) {
        super(globalContext.getCodeGenerator());
        this.globalContext = globalContext;
        this.parentContext = null;
        this.cgScope = cgScope;
        this.nameManagerContext = this.codeGenerator.getNameManager().createNestedContext();
    }

    public JavaLocalContext(@NonNull JavaLocalContext parentContext, @NonNull CGElement cgScope) {
        super(parentContext.getCodeGenerator());
        this.globalContext = parentContext.getGlobalContext();
        this.parentContext = parentContext;
        this.cgScope = cgScope;
        this.nameManagerContext = parentContext.nameManagerContext.createNestedContext();
        if (cgScope instanceof CGIterationCallExp) {
            for (CGIterator cgIterator : ((CGIterationCallExp)cgScope).getIterators()) {
                this.nameManagerContext.getSymbolName(cgIterator, new String[0]);
            }
        }
    }

    protected void addCastParameter(@NonNull CGParameter cgParameter, @NonNull CGParameter cgCastParameter) {
        assert (this.parentContext != null || !(cgParameter instanceof CGIterator));
        if (this.castParameters == null) {
            this.castParameters = new HashMap<CGParameter, CGParameter>();
        }
        this.castParameters.put(cgParameter, cgCastParameter);
        this.addDependency(cgCastParameter, cgParameter);
    }

    public void addDependency(@NonNull CGValuedElement cgElement, @NonNull CGValuedElement cgDependency) {
        List<CGValuedElement> dependsOns = cgElement.getDependsOn();
        if (!dependsOns.contains(cgDependency)) {
            dependsOns.add(cgDependency);
        }
    }

    public void addLocalVariable(@NonNull CGValuedElement cgVariable) {
        if (this.localVariables == null) {
            this.localVariables = new HashSet<CGValuedElement>();
        }
        this.localVariables.add(cgVariable);
    }

    @Nullable
    public CGParameter basicGetCastParameter(@NonNull CGParameter cgParameter) {
        if (cgParameter instanceof CGCastParameter) {
            return cgParameter;
        }
        if (this.castParameters == null) {
            return null;
        }
        return this.castParameters.get(cgParameter);
    }

    @NonNull
    protected CGParameter createCastParameter(@NonNull CGParameter cgParameter) {
        TypedElement pParameter = (TypedElement)cgParameter.getPivot();
        CGTypeId cgTypeId = this.analyzer.getTypeId(pParameter.getTypeId());
        ElementId elementId = cgTypeId.getElementId();
        if (elementId == null) {
            return cgParameter;
        }
        TypeDescriptor unboxedTypeDescriptor = this.codeGenerator.getTypeDescriptor(elementId, false);
        if (cgParameter.getInit() != null) {
            return cgParameter;
        }
        if (unboxedTypeDescriptor.getJavaClass() == Object.class) {
            return cgParameter;
        }
        CGCastParameter cgCastParameter = CGModelFactory.eINSTANCE.createCGCastParameter();
        cgCastParameter.setName(cgParameter.getName());
        cgCastParameter.setPivot((NamedElement)pParameter);
        cgCastParameter.setTypeId(cgTypeId);
        cgCastParameter.setReferredParameter(cgParameter);
        return cgCastParameter;
    }

    @NonNull
    protected abstract JavaLocalContext createNestedContext(@NonNull CGElement var1);

    @NonNull
    public CGParameter getCastParameter(@NonNull CGParameter cgParameter) {
        if (cgParameter instanceof CGCastParameter) {
            return cgParameter;
        }
        if (cgParameter instanceof CGIterator && !(cgParameter.eContainer() instanceof CGBuiltInIterationCallExp)) {
            CGParameter cgCastParameter = this.basicGetCastParameter(cgParameter);
            if (cgCastParameter == null) {
                cgCastParameter = this.createCastParameter(cgParameter);
                this.addCastParameter(cgParameter, cgCastParameter);
            }
            return cgCastParameter;
        }
        return cgParameter;
    }

    @NonNull
    public Collection<CGParameter> getCastParameters() {
        if (this.castParameters != null) {
            return this.castParameters.values();
        }
        return Collections.emptyList();
    }

    @NonNull
    public CGValuedElement getEvaluatorParameter() {
        if (this.parentContext != null) {
            return this.parentContext.getEvaluatorParameter();
        }
        CGParameter evaluatorParameter2 = this.evaluatorParameter;
        if (evaluatorParameter2 == null) {
            this.evaluatorParameter = evaluatorParameter2 = CGModelFactory.eINSTANCE.createCGParameter();
            this.setNames(evaluatorParameter2, "evaluator", (TypeId)JavaConstants.EVALUATOR_TYPE_ID);
        }
        return evaluatorParameter2;
    }

    @NonNull
    public CGExecutorProperty getExecutorProperty(@NonNull Property pivotProperty) {
        PropertyId propertyId = pivotProperty.getPropertyId();
        CGExecutorProperty cgProperty = this.cgProperties.get(propertyId);
        if (cgProperty == null) {
            cgProperty = CGModelFactory.eINSTANCE.createCGExecutorNavigationProperty();
            CGElementId cgPropertyId = this.analyzer.getElementId((ElementId)propertyId);
            cgProperty.setPivot((NamedElement)pivotProperty);
            cgProperty.setName(this.analyzer.getNameManager().getGlobalSymbolName(pivotProperty, new String[0]));
            cgProperty.setValueName(cgProperty.getName());
            this.cgProperties.put(propertyId, cgProperty);
            cgProperty.getDependsOn().add(cgPropertyId);
        }
        return cgProperty;
    }

    @Override
    @NonNull
    public CGExecutorType getExecutorType(@NonNull Type pivotType) {
        TypeId typeId = pivotType.getTypeId();
        CGExecutorType cgType = this.cgTypes.get(typeId);
        if (cgType == null) {
            cgType = CGModelFactory.eINSTANCE.createCGExecutorType();
            CGTypeId cgTypeId = this.analyzer.getTypeId(typeId);
            cgType.setUnderlyingTypeId(cgTypeId);
            cgType.setPivot((NamedElement)pivotType);
            cgType.setName(this.analyzer.getNameManager().getGlobalSymbolName(pivotType, new String[0]));
            cgType.setValueName(cgType.getName());
            this.cgTypes.put(typeId, cgType);
            cgType.getDependsOn().add(cgTypeId);
        }
        return cgType;
    }

    @NonNull
    public CGExecutorType getExecutorType(@NonNull TypeId typeId) {
        return (CGExecutorType)DomainUtil.nonNullState((Object)this.cgTypes.get(typeId));
    }

    @NonNull
    public JavaGlobalContext getGlobalContext() {
        return this.globalContext;
    }

    @NonNull
    public CGValuedElement getIdResolverVariable() {
        if (this.parentContext != null) {
            return this.parentContext.getIdResolverVariable();
        }
        CGText idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            CGValuedElement evaluatorParameter = this.getEvaluatorParameter();
            this.idResolver = idResolver2 = CGModelFactory.eINSTANCE.createCGText();
            this.setNames(idResolver2, "idResolver", (TypeId)JavaConstants.ID_RESOLVER_TYPE_ID);
            idResolver2.setTextValue(String.valueOf(evaluatorParameter.getValueName()) + ".getIdResolver()");
            this.addDependency(idResolver2, evaluatorParameter);
            this.addLocalVariable(idResolver2);
        }
        return idResolver2;
    }

    public Collection<? extends CGValuedElement> getLocalVariables() {
        return this.localVariables;
    }

    @NonNull
    public JavaLocalContext getOuterContext() {
        return this.parentContext != null ? this.parentContext.getOuterContext() : this;
    }

    @Override
    @NonNull
    public NameManager.Context getNameManagerContext() {
        return this.nameManagerContext;
    }

    @NonNull
    public CGText getStandardLibraryVariable() {
        if (this.parentContext != null) {
            return this.parentContext.getStandardLibraryVariable();
        }
        CGText standardLibrary2 = this.standardLibrary;
        if (standardLibrary2 == null) {
            CGValuedElement idResolverVariable = this.getIdResolverVariable();
            this.standardLibrary = standardLibrary2 = CGModelFactory.eINSTANCE.createCGText();
            this.setNames(standardLibrary2, "standardLibrary", (TypeId)JavaConstants.STANDARD_LIBRARY_TYPE_ID);
            standardLibrary2.setTextValue(String.valueOf(idResolverVariable.getValueName()) + ".getStandardLibrary()");
            this.addDependency(standardLibrary2, idResolverVariable);
            this.addLocalVariable(standardLibrary2);
            this.addDependency(standardLibrary2, this.getIdResolverVariable());
        }
        return standardLibrary2;
    }

    @NonNull
    public CGParameter getTypeIdParameter() {
        if (this.parentContext != null) {
            return this.parentContext.getTypeIdParameter();
        }
        CGParameter typeIdParameter2 = this.typeIdParameter;
        if (typeIdParameter2 == null) {
            this.typeIdParameter = typeIdParameter2 = CGModelFactory.eINSTANCE.createCGParameter();
            this.setNames(typeIdParameter2, "typeId", (TypeId)JavaConstants.TYPE_ID_TYPE_ID);
        }
        return typeIdParameter2;
    }

    @NonNull
    public String getValueName(@NonNull CGValuedElement cgElement) {
        CGValuedElement cgValue = cgElement;
        String valueName = cgElement.getValueName();
        if (valueName != null) {
            return valueName;
        }
        assert (cgValue == cgValue.getValue());
        valueName = (cgValue = cgValue.getValue()).getValueName();
        if (valueName == null) {
            valueName = this.nameManagerContext.getSymbolName(cgValue, cgValue.getName());
            cgValue.setValueName(valueName);
        }
        return valueName;
    }

    @Override
    public void setNames(@NonNull CGValuedElement cgValueElement, @NonNull CGValuedElement cgExpression) {
        String name = cgExpression.getName();
        if (name == null) {
            name = this.nameManagerContext.getSymbolName(cgExpression, new String[0]);
        }
        cgValueElement.setName(name);
        cgValueElement.setValueName(name);
    }

    protected void setNames(@NonNull CGValuedElement cgValueElement, @NonNull String nameHint, @NonNull TypeId typeId) {
        String name = this.nameManagerContext.getSymbolName(null, nameHint);
        cgValueElement.setName(name);
        cgValueElement.setValueName(name);
        cgValueElement.setTypeId(this.analyzer.getTypeId(typeId));
        if (!(cgValueElement instanceof CGText)) {
            cgValueElement.setNonInvalid();
            cgValueElement.setNonNull();
        }
    }
}

