/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.iteration;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaConstants;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.iteration.AbstractIteration2Java;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAccumulation2Java
extends AbstractIteration2Java {
    @Override
    public void appendAccumulatorInit(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGTypeId cgAccumulatorId = cgIterationCallExp.getTypeId();
        CollectionTypeId elementId = (CollectionTypeId)cgAccumulatorId.getElementId();
        String name = elementId.getGeneralizedId().getName();
        js.appendClassReference(ValuesUtil.class);
        js.append(".create" + name + "AccumulatorValue(");
        js.appendIdReference((ElementId)elementId);
        js.append(")");
    }

    @Override
    public boolean appendFinalValue(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGIterator cgAccumulator = this.getAccumulator(cgIterationCallExp);
        js.appendAssignment(cgIterationCallExp, cgAccumulator);
        return true;
    }

    @NonNull
    protected CGIterator getAccumulator(@NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        return cgIterationCallExp.getAccumulator();
    }

    @NonNull
    protected Class<?> getAccumulatorClass(@NonNull CodeGenAnalyzer analyzer, @NonNull CollectionTypeId typeId) {
        JavaCodeGenerator codeGenerator = (JavaCodeGenerator)analyzer.getCodeGenerator();
        TypeDescriptor boxedTypeDescriptor = codeGenerator.getTypeDescriptor((ElementId)typeId, true);
        Class<?> boxedClass = boxedTypeDescriptor.getJavaClass();
        Class<?>[] classArray = boxedClass.getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> nestedClass = classArray[n2];
            if ("Accumulator".equals(nestedClass.getSimpleName())) {
                return nestedClass;
            }
            ++n2;
        }
        return Object.class;
    }

    @Override
    @Nullable
    public CGTypeId getAccumulatorTypeId(@NonNull CodeGenAnalyzer analyzer, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGTypeId cgAccumulatorId = cgIterationCallExp.getTypeId();
        ElementId elementId = cgAccumulatorId.getElementId();
        Class<Object> accumulatorClass = elementId instanceof CollectionTypeId ? this.getAccumulatorClass(analyzer, (CollectionTypeId)elementId) : Object.class;
        return analyzer.getTypeId((TypeId)JavaConstants.getJavaTypeId(accumulatorClass));
    }
}

