/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnboxedEObjectsDescriptor
extends AbstractValueDescriptor
implements UnboxedDescriptor {
    @NonNull
    protected final EClass eClass;
    @NonNull
    protected final Class<?> oldJavaClass;

    public UnboxedEObjectsDescriptor(@NonNull CollectionTypeId elementId, @NonNull Class<?> javaClass, @NonNull EClass eClass) {
        super((ElementId)elementId, UnboxedEObjectsDescriptor.reClass(javaClass));
        this.eClass = eClass;
        this.oldJavaClass = javaClass;
    }

    @Override
    public void append(@NonNull JavaStream javaStream) {
        javaStream.appendClassReference(List.class, this.javaClass != this.oldJavaClass, this.javaClass);
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (!(typeDescriptor instanceof UnboxedEObjectsDescriptor)) {
            return false;
        }
        return this.javaClass.isAssignableFrom(typeDescriptor.getJavaClass());
    }

    @Override
    public boolean isAssignableTo(@NonNull Class<?> javaClass) {
        return javaClass.isAssignableFrom(List.class);
    }

    @Override
    @NonNull
    public String toString() {
        return this.elementId + " => List<" + this.javaClass.getName() + ">";
    }
}

