/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.navigation.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.navigation.Activator;
import org.eclipse.papyrus.infra.services.navigation.service.impl.NavigationServiceImpl;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class NavigationServicePreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final int ACTIVATION_COLUMN = 0;
    private Map<NavigationServiceImpl.NavigationContributorDescriptor, Button> checkboxes;
    private NavigationServiceImpl navigation = new NavigationServiceImpl();

    public NavigationServicePreferencesPage() {
        super("Navigation Services", org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImageDescriptor("/icons/papyrus.png"));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Papyrus navigation services configuration.\nSelect the strategies you wish to activate.");
    }

    protected Control createContents(Composite parent) {
        Composite self = new Composite(parent, 0);
        self.setLayout((Layout)new GridLayout(1, true));
        self.setLayoutData((Object)new GridData(1808));
        TableViewer tableViewer = new TableViewer(self, 68354);
        GridData gridData = new GridData(4, 4, true, true);
        tableViewer.getTable().setLayoutData((Object)gridData);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        tableViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        try {
            this.navigation.startService();
        }
        catch (ServiceException ex) {
            return self;
        }
        tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getColumnIndex() != 1) {
                    return;
                }
                super.update(cell);
            }

            public String getToolTipText(Object element) {
                if (element instanceof NavigationServiceImpl.NavigationContributorDescriptor) {
                    return ((NavigationServiceImpl.NavigationContributorDescriptor)element).getDescription();
                }
                return super.getToolTipText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof NavigationServiceImpl.NavigationContributorDescriptor) {
                    return null;
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof NavigationServiceImpl.NavigationContributorDescriptor) {
                    return ((NavigationServiceImpl.NavigationContributorDescriptor)element).getLabel();
                }
                return super.getText(element);
            }
        });
        TableLayout layout = new TableLayout();
        new TableColumn(tableViewer.getTable(), 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 25, false));
        new TableColumn(tableViewer.getTable(), 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 250, true));
        tableViewer.getTable().setLayout((Layout)layout);
        tableViewer.getTable().setHeaderVisible(false);
        tableViewer.setInput(this.navigation.getNavigationContributors());
        this.checkboxes = new HashMap<NavigationServiceImpl.NavigationContributorDescriptor, Button>();
        TableItem[] tableItemArray = tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() instanceof NavigationServiceImpl.NavigationContributorDescriptor) {
                TableEditor editor = new TableEditor(tableViewer.getTable());
                Button button = new Button((Composite)tableViewer.getTable(), 32);
                TableItem currentItem = item;
                NavigationServiceImpl.NavigationContributorDescriptor strategy = (NavigationServiceImpl.NavigationContributorDescriptor)currentItem.getData();
                this.checkboxes.put(strategy, button);
                button.setSelection(strategy.isActive());
                editor.setEditor((Control)button, item, 0);
                editor.horizontalAlignment = 0x1000000;
                editor.grabHorizontal = true;
            }
            ++n2;
        }
        return self;
    }

    protected void performDefaults() {
        this.restoreDefaults();
        super.performDefaults();
    }

    protected void performApply() {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        for (Map.Entry<NavigationServiceImpl.NavigationContributorDescriptor, Button> entry : this.checkboxes.entrySet()) {
            boolean checked = entry.getValue().getSelection();
            String isActiveKey = NavigationServiceImpl.NavigationContributorDescriptor.getIsActiveKey(entry.getKey());
            preferences.setValue(isActiveKey, checked);
        }
        try {
            IEclipsePreferences preferenceStore = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.services.navigation");
            preferenceStore.flush();
        }
        catch (BackingStoreException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void restoreDefaults() {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        for (Map.Entry<NavigationServiceImpl.NavigationContributorDescriptor, Button> entry : this.checkboxes.entrySet()) {
            String isActiveKey = NavigationServiceImpl.NavigationContributorDescriptor.getIsActiveKey(entry.getKey());
            boolean selected = preferences.getDefaultBoolean(isActiveKey);
            entry.getValue().setSelection(selected);
        }
    }
}

