/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.diagram.composite.custom.messages.Messages;
import org.eclipse.papyrus.uml.diagram.composite.custom.ui.InterfaceManagerDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;

public class ManageProvidedInterfacesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        EObject selectedElement;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (selectedElement = EMFHelper.getEObject((Object)(structuredSelection = (IStructuredSelection)selection).getFirstElement())) instanceof Port) {
            Port port = (Port)selectedElement;
            ManageProvidedInterfaceAction action = new ManageProvidedInterfaceAction(port);
            try {
                ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)port).getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(action.getCommand()));
            }
            catch (ServiceException ex) {
                throw new ExecutionException("An unexpected exception occurred", (Throwable)ex);
            }
        }
        return null;
    }

    public class ManageProvidedInterfaceAction {
        private Port port;
        private Type type;

        public ManageProvidedInterfaceAction(Port port) {
            this.port = port;
            this.type = port.getType();
        }

        public org.eclipse.gef.commands.Command getCommand() {
            if (this.type != null && !(this.type instanceof Classifier)) {
                return UnexecutableCommand.INSTANCE;
            }
            if (this.type == null) {
                MessageDialog dialog = new MessageDialog(DisplayUtils.getDefaultShell(), Messages.InterfaceManagerDialog_Title, null, Messages.ManageProvidedInterfacesHandler_TheTypeOfThePortIsNotDefined, 4, new String[]{Messages.ManageProvidedInterfacesHandler_OK}, 0);
                dialog.open();
            } else {
                InterfaceManagerDialog dialog = new InterfaceManagerDialog(DisplayUtils.getDefaultShell(), this.port);
                if (dialog.open() == 0) {
                    return dialog.getCommand();
                }
            }
            return UnexecutableCommand.INSTANCE;
        }
    }
}

