/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.composite/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("CompositeStructure".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"CompositeStructure".equals(containerModelID)) {
            return -1;
        }
        if ("CompositeStructure".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 2060;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 2061;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 2062;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 2063;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 2064;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 2065;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2069;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 2070;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 2071;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2072;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 2073;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 2075;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2076;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 2066;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2067;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 2068;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 2077;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2078;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 2079;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 2080;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 2081;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 2082;
                }
                if (UMLPackage.eINSTANCE.getSignalEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2083;
                }
                if (UMLPackage.eINSTANCE.getCallEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2084;
                }
                if (UMLPackage.eINSTANCE.getAnyReceiveEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2085;
                }
                if (UMLPackage.eINSTANCE.getChangeEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2088;
                }
                if (UMLPackage.eINSTANCE.getTimeEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2089;
                }
                if (UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 2093;
                }
                if (UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 2094;
                }
                if (UMLPackage.eINSTANCE.getLiteralBoolean().isSuperTypeOf(domainElement.eClass())) {
                    return 2095;
                }
                if (UMLPackage.eINSTANCE.getLiteralInteger().isSuperTypeOf(domainElement.eClass())) {
                    return 2096;
                }
                if (UMLPackage.eINSTANCE.getLiteralNull().isSuperTypeOf(domainElement.eClass())) {
                    return 2097;
                }
                if (UMLPackage.eINSTANCE.getLiteralString().isSuperTypeOf(domainElement.eClass())) {
                    return 2098;
                }
                if (UMLPackage.eINSTANCE.getLiteralUnlimitedNatural().isSuperTypeOf(domainElement.eClass())) {
                    return 2099;
                }
                if (UMLPackage.eINSTANCE.getStringExpression().isSuperTypeOf(domainElement.eClass())) {
                    return 2100;
                }
                if (UMLPackage.eINSTANCE.getOpaqueExpression().isSuperTypeOf(domainElement.eClass())) {
                    return 2101;
                }
                if (UMLPackage.eINSTANCE.getTimeExpression().isSuperTypeOf(domainElement.eClass())) {
                    return 2102;
                }
                if (UMLPackage.eINSTANCE.getExpression().isSuperTypeOf(domainElement.eClass())) {
                    return 2103;
                }
                if (UMLPackage.eINSTANCE.getDuration().isSuperTypeOf(domainElement.eClass())) {
                    return 2104;
                }
                if (UMLPackage.eINSTANCE.getTimeInterval().isSuperTypeOf(domainElement.eClass())) {
                    return 2105;
                }
                if (UMLPackage.eINSTANCE.getDurationInterval().isSuperTypeOf(domainElement.eClass())) {
                    return 2106;
                }
                if (UMLPackage.eINSTANCE.getInterval().isSuperTypeOf(domainElement.eClass())) {
                    return 2107;
                }
                if (UMLPackage.eINSTANCE.getInstanceValue().isSuperTypeOf(domainElement.eClass())) {
                    return 2108;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2109;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2110;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2111;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2112;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2113;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 2114;
            }
            case 2060: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2061: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2062: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2063: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2064: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2065: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2069: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2070: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2071: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2072: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2073: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2067: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3066;
            }
            case 3070: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3072: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3073: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3074: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3075: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3076: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3077: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3081: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3082: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3083: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3084: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3085: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3079: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3066;
            }
            case 7033: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3101;
            }
            case 7034: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3102;
            }
            case 7036: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3101;
            }
            case 7037: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3102;
            }
            case 7048: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3066;
            }
            case 7049: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3066;
            }
            case 7050: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7051: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7052: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7053: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7054: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7055: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7056: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7057: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7058: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7059: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7060: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7061: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getConnectableElement().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7063: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7064: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7065: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7066: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7067: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7068: {
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7069: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7070: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7071: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7072: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7073: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (!UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3119;
            }
            case 7075: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getConnectableElement().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7077: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                return 3097;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"CompositeStructure".equals(containerModelID)) {
            return false;
        }
        if ("CompositeStructure".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2060 == nodeVisualID) {
                    return true;
                }
                if (2061 == nodeVisualID) {
                    return true;
                }
                if (2062 == nodeVisualID) {
                    return true;
                }
                if (2063 == nodeVisualID) {
                    return true;
                }
                if (2064 == nodeVisualID) {
                    return true;
                }
                if (2065 == nodeVisualID) {
                    return true;
                }
                if (2069 == nodeVisualID) {
                    return true;
                }
                if (2070 == nodeVisualID) {
                    return true;
                }
                if (2071 == nodeVisualID) {
                    return true;
                }
                if (2072 == nodeVisualID) {
                    return true;
                }
                if (2073 == nodeVisualID) {
                    return true;
                }
                if (2075 == nodeVisualID) {
                    return true;
                }
                if (2076 == nodeVisualID) {
                    return true;
                }
                if (2066 == nodeVisualID) {
                    return true;
                }
                if (2067 == nodeVisualID) {
                    return true;
                }
                if (2068 == nodeVisualID) {
                    return true;
                }
                if (2077 == nodeVisualID) {
                    return true;
                }
                if (2078 == nodeVisualID) {
                    return true;
                }
                if (2079 == nodeVisualID) {
                    return true;
                }
                if (2080 == nodeVisualID) {
                    return true;
                }
                if (2081 == nodeVisualID) {
                    return true;
                }
                if (2082 == nodeVisualID) {
                    return true;
                }
                if (2083 == nodeVisualID) {
                    return true;
                }
                if (2084 == nodeVisualID) {
                    return true;
                }
                if (2085 == nodeVisualID) {
                    return true;
                }
                if (2088 == nodeVisualID) {
                    return true;
                }
                if (2089 == nodeVisualID) {
                    return true;
                }
                if (2093 == nodeVisualID) {
                    return true;
                }
                if (2094 == nodeVisualID) {
                    return true;
                }
                if (2095 == nodeVisualID) {
                    return true;
                }
                if (2096 == nodeVisualID) {
                    return true;
                }
                if (2097 == nodeVisualID) {
                    return true;
                }
                if (2098 == nodeVisualID) {
                    return true;
                }
                if (2099 == nodeVisualID) {
                    return true;
                }
                if (2100 == nodeVisualID) {
                    return true;
                }
                if (2101 == nodeVisualID) {
                    return true;
                }
                if (2102 == nodeVisualID) {
                    return true;
                }
                if (2103 == nodeVisualID) {
                    return true;
                }
                if (2104 == nodeVisualID) {
                    return true;
                }
                if (2105 == nodeVisualID) {
                    return true;
                }
                if (2106 == nodeVisualID) {
                    return true;
                }
                if (2107 == nodeVisualID) {
                    return true;
                }
                if (2108 == nodeVisualID) {
                    return true;
                }
                if (2109 == nodeVisualID) {
                    return true;
                }
                if (2110 == nodeVisualID) {
                    return true;
                }
                if (2111 == nodeVisualID) {
                    return true;
                }
                if (2112 == nodeVisualID) {
                    return true;
                }
                if (2113 == nodeVisualID) {
                    return true;
                }
                if (2114 != nodeVisualID) break;
                return true;
            }
            case 2060: {
                if (5112 == nodeVisualID) {
                    return true;
                }
                if (7063 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2061: {
                if (5113 == nodeVisualID) {
                    return true;
                }
                if (7064 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2062: {
                if (5114 == nodeVisualID) {
                    return true;
                }
                if (7065 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2063: {
                if (5115 == nodeVisualID) {
                    return true;
                }
                if (7066 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2064: {
                if (5116 == nodeVisualID) {
                    return true;
                }
                if (7067 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2065: {
                if (5117 == nodeVisualID) {
                    return true;
                }
                if (7068 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2069: {
                if (5121 == nodeVisualID) {
                    return true;
                }
                if (7069 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2070: {
                if (5122 == nodeVisualID) {
                    return true;
                }
                if (7070 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2071: {
                if (5123 == nodeVisualID) {
                    return true;
                }
                if (7071 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2072: {
                if (5124 == nodeVisualID) {
                    return true;
                }
                if (7072 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2073: {
                if (5156 == nodeVisualID) {
                    return true;
                }
                if (7073 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2075: {
                if (5158 == nodeVisualID) {
                    return true;
                }
                if (7075 != nodeVisualID) break;
                return true;
            }
            case 2076: {
                if (5159 != nodeVisualID) break;
                return true;
            }
            case 2066: {
                if (5118 != nodeVisualID) break;
                return true;
            }
            case 2067: {
                if (5119 == nodeVisualID) {
                    return true;
                }
                if (7048 == nodeVisualID) {
                    return true;
                }
                if (3066 != nodeVisualID) break;
                return true;
            }
            case 2068: {
                if (5120 == nodeVisualID) {
                    return true;
                }
                if (7033 == nodeVisualID) {
                    return true;
                }
                if (7034 != nodeVisualID) break;
                return true;
            }
            case 2077: {
                if (5160 != nodeVisualID) break;
                return true;
            }
            case 2078: {
                if (5161 != nodeVisualID) break;
                return true;
            }
            case 2079: {
                if (5162 != nodeVisualID) break;
                return true;
            }
            case 2080: {
                if (5163 != nodeVisualID) break;
                return true;
            }
            case 2081: {
                if (5164 != nodeVisualID) break;
                return true;
            }
            case 2082: {
                if (5165 != nodeVisualID) break;
                return true;
            }
            case 2083: {
                if (5166 != nodeVisualID) break;
                return true;
            }
            case 2084: {
                if (5167 != nodeVisualID) break;
                return true;
            }
            case 2085: {
                if (5168 != nodeVisualID) break;
                return true;
            }
            case 2088: {
                if (5171 != nodeVisualID) break;
                return true;
            }
            case 2089: {
                if (5172 != nodeVisualID) break;
                return true;
            }
            case 2093: {
                if (5151 == nodeVisualID) {
                    return true;
                }
                if (5152 != nodeVisualID) break;
                return true;
            }
            case 2094: {
                if (5142 == nodeVisualID) {
                    return true;
                }
                if (5143 != nodeVisualID) break;
                return true;
            }
            case 2095: {
                if (5178 != nodeVisualID) break;
                return true;
            }
            case 2096: {
                if (5179 != nodeVisualID) break;
                return true;
            }
            case 2097: {
                if (5180 != nodeVisualID) break;
                return true;
            }
            case 2098: {
                if (5181 != nodeVisualID) break;
                return true;
            }
            case 2099: {
                if (5182 != nodeVisualID) break;
                return true;
            }
            case 2100: {
                if (5183 != nodeVisualID) break;
                return true;
            }
            case 2101: {
                if (5184 != nodeVisualID) break;
                return true;
            }
            case 2102: {
                if (5185 != nodeVisualID) break;
                return true;
            }
            case 2103: {
                if (5186 != nodeVisualID) break;
                return true;
            }
            case 2104: {
                if (5187 != nodeVisualID) break;
                return true;
            }
            case 2105: {
                if (5188 != nodeVisualID) break;
                return true;
            }
            case 2106: {
                if (5189 != nodeVisualID) break;
                return true;
            }
            case 2107: {
                if (5190 != nodeVisualID) break;
                return true;
            }
            case 2108: {
                if (5191 != nodeVisualID) break;
                return true;
            }
            case 2109: {
                if (5192 != nodeVisualID) break;
                return true;
            }
            case 2110: {
                if (5193 == nodeVisualID) {
                    return true;
                }
                if (6035 != nodeVisualID) break;
                return true;
            }
            case 2111: {
                if (5194 == nodeVisualID) {
                    return true;
                }
                if (6036 != nodeVisualID) break;
                return true;
            }
            case 2112: {
                if (5195 == nodeVisualID) {
                    return true;
                }
                if (6037 != nodeVisualID) break;
                return true;
            }
            case 2113: {
                if (5196 == nodeVisualID) {
                    return true;
                }
                if (6038 != nodeVisualID) break;
                return true;
            }
            case 2114: {
                if (5197 == nodeVisualID) {
                    return true;
                }
                if (6039 != nodeVisualID) break;
                return true;
            }
            case 3069: {
                if (5125 == nodeVisualID) {
                    return true;
                }
                if (6029 != nodeVisualID) break;
                return true;
            }
            case 3088: {
                if (6033 == nodeVisualID) {
                    return true;
                }
                if (6034 != nodeVisualID) break;
                return true;
            }
            case 3070: {
                if (5126 == nodeVisualID) {
                    return true;
                }
                if (7077 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3115: {
                if (5198 != nodeVisualID) break;
                return true;
            }
            case 3071: {
                if (5127 != nodeVisualID) break;
                return true;
            }
            case 3072: {
                if (5128 == nodeVisualID) {
                    return true;
                }
                if (7050 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3073: {
                if (5129 == nodeVisualID) {
                    return true;
                }
                if (7051 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3074: {
                if (5130 == nodeVisualID) {
                    return true;
                }
                if (7052 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3075: {
                if (5131 == nodeVisualID) {
                    return true;
                }
                if (7053 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3076: {
                if (5132 == nodeVisualID) {
                    return true;
                }
                if (7054 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3077: {
                if (5133 == nodeVisualID) {
                    return true;
                }
                if (7055 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3081: {
                if (5137 == nodeVisualID) {
                    return true;
                }
                if (7056 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3082: {
                if (5138 == nodeVisualID) {
                    return true;
                }
                if (7057 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3083: {
                if (5139 == nodeVisualID) {
                    return true;
                }
                if (7058 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3084: {
                if (5140 == nodeVisualID) {
                    return true;
                }
                if (7059 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3085: {
                if (5155 == nodeVisualID) {
                    return true;
                }
                if (7060 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3086: {
                if (5141 == nodeVisualID) {
                    return true;
                }
                if (7061 != nodeVisualID) break;
                return true;
            }
            case 3087: {
                if (5154 != nodeVisualID) break;
                return true;
            }
            case 3078: {
                if (5134 != nodeVisualID) break;
                return true;
            }
            case 3079: {
                if (5135 == nodeVisualID) {
                    return true;
                }
                if (7049 == nodeVisualID) {
                    return true;
                }
                if (3066 != nodeVisualID) break;
                return true;
            }
            case 3080: {
                if (5136 == nodeVisualID) {
                    return true;
                }
                if (7036 == nodeVisualID) {
                    return true;
                }
                if (7037 != nodeVisualID) break;
                return true;
            }
            case 3091: {
                if (5144 != nodeVisualID) break;
                return true;
            }
            case 3092: {
                if (5145 != nodeVisualID) break;
                return true;
            }
            case 3093: {
                if (5146 != nodeVisualID) break;
                return true;
            }
            case 3094: {
                if (5147 != nodeVisualID) break;
                return true;
            }
            case 3095: {
                if (5148 != nodeVisualID) break;
                return true;
            }
            case 3096: {
                if (5149 != nodeVisualID) break;
                return true;
            }
            case 3097: {
                if (5150 != nodeVisualID) break;
                return true;
            }
            case 3116: {
                if (6040 == nodeVisualID) {
                    return true;
                }
                if (6041 != nodeVisualID) break;
                return true;
            }
            case 3117: {
                if (6042 == nodeVisualID) {
                    return true;
                }
                if (6043 != nodeVisualID) break;
                return true;
            }
            case 3118: {
                if (6044 == nodeVisualID) {
                    return true;
                }
                if (6045 != nodeVisualID) break;
                return true;
            }
            case 3119: {
                if (6046 == nodeVisualID) {
                    return true;
                }
                if (6047 != nodeVisualID) break;
                return true;
            }
            case 3120: {
                if (6048 == nodeVisualID) {
                    return true;
                }
                if (6049 != nodeVisualID) break;
                return true;
            }
            case 7033: {
                if (3101 != nodeVisualID) break;
                return true;
            }
            case 7034: {
                if (3102 != nodeVisualID) break;
                return true;
            }
            case 7036: {
                if (3101 != nodeVisualID) break;
                return true;
            }
            case 7037: {
                if (3102 != nodeVisualID) break;
                return true;
            }
            case 7048: {
                if (3066 != nodeVisualID) break;
                return true;
            }
            case 7049: {
                if (3066 != nodeVisualID) break;
                return true;
            }
            case 7050: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7051: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7052: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7053: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7054: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7055: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7056: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7057: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7058: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7059: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7060: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3121 != nodeVisualID) break;
                return true;
            }
            case 7061: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7063: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7064: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7065: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7066: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7067: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7068: {
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7069: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7070: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7071: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7072: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7073: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 != nodeVisualID) break;
                return true;
            }
            case 7075: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7077: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3097 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6015 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6016 != nodeVisualID) break;
                return true;
            }
            case 4011: {
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6017 != nodeVisualID) break;
                return true;
            }
            case 4006: {
                if (6004 == nodeVisualID) {
                    return true;
                }
                if (6018 != nodeVisualID) break;
                return true;
            }
            case 4012: {
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6019 != nodeVisualID) break;
                return true;
            }
            case 4007: {
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6020 != nodeVisualID) break;
                return true;
            }
            case 4008: {
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6021 != nodeVisualID) break;
                return true;
            }
            case 4009: {
                if (6008 == nodeVisualID) {
                    return true;
                }
                if (6022 != nodeVisualID) break;
                return true;
            }
            case 4017: {
                if (6027 == nodeVisualID) {
                    return true;
                }
                if (6028 != nodeVisualID) break;
                return true;
            }
            case 4010: {
                if (6009 == nodeVisualID) {
                    return true;
                }
                if (6023 != nodeVisualID) break;
                return true;
            }
            case 4013: {
                if (6025 == nodeVisualID) {
                    return true;
                }
                if (6050 == nodeVisualID) {
                    return true;
                }
                if (6051 == nodeVisualID) {
                    return true;
                }
                if (6052 != nodeVisualID) break;
                return true;
            }
            case 4015: {
                if (6024 != nodeVisualID) break;
                return true;
            }
            case 4020: {
                if (6030 != nodeVisualID) break;
                return true;
            }
            case 4021: {
                if (6031 == nodeVisualID) {
                    return true;
                }
                if (6032 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getComponentRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4005;
        }
        if (UMLPackage.eINSTANCE.getSubstitution().isSuperTypeOf(domainElement.eClass())) {
            return 4011;
        }
        if (UMLPackage.eINSTANCE.getRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4006;
        }
        if (UMLPackage.eINSTANCE.getManifestation().isSuperTypeOf(domainElement.eClass())) {
            return 4012;
        }
        if (UMLPackage.eINSTANCE.getAbstraction().isSuperTypeOf(domainElement.eClass())) {
            return 4007;
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass())) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getDeployment().isSuperTypeOf(domainElement.eClass())) {
            return 4009;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4017((Dependency)domainElement)) {
            return 4017;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4010((Dependency)domainElement)) {
            return 4010;
        }
        if (UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass())) {
            return 4013;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4015;
        }
        if (UMLPackage.eINSTANCE.getInformationFlow().isSuperTypeOf(domainElement.eClass())) {
            return 4021;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isProperty_3070(View containerView, Property domainElement) {
        Collaboration graphicalParent;
        return !(containerView.getElement() instanceof Collaboration) || !(graphicalParent = (Collaboration)containerView.getElement()).getCollaborationRoles().contains((Object)domainElement);
    }

    private static boolean isDependency_4017(Dependency domainElement) {
        CollaborationUse owner;
        return domainElement.getOwner() instanceof CollaborationUse && (owner = (CollaborationUse)domainElement.getOwner()).getRoleBindings().contains((Object)domainElement);
    }

    private static boolean isDependency_4010(Dependency domainElement) {
        CollaborationUse owner;
        return !(domainElement.getOwner() instanceof CollaborationUse) || !(owner = (CollaborationUse)domainElement.getOwner()).getRoleBindings().contains((Object)domainElement);
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7033: 
            case 7034: 
            case 7036: 
            case 7037: 
            case 7048: 
            case 7049: 
            case 7050: 
            case 7051: 
            case 7052: 
            case 7053: 
            case 7054: 
            case 7055: 
            case 7056: 
            case 7057: 
            case 7058: 
            case 7059: 
            case 7060: 
            case 7061: 
            case 7063: 
            case 7064: 
            case 7065: 
            case 7066: 
            case 7067: 
            case 7068: 
            case 7069: 
            case 7070: 
            case 7071: 
            case 7072: 
            case 7073: 
            case 7075: 
            case 7077: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 2066: 
            case 2076: 
            case 2077: 
            case 2078: 
            case 2079: 
            case 2080: 
            case 2081: 
            case 2082: 
            case 2083: 
            case 2084: 
            case 2085: 
            case 2088: 
            case 2089: 
            case 2093: 
            case 2094: 
            case 2095: 
            case 2096: 
            case 2097: 
            case 2098: 
            case 2099: 
            case 2100: 
            case 2101: 
            case 2102: 
            case 2103: 
            case 2104: 
            case 2105: 
            case 2106: 
            case 2107: 
            case 2108: 
            case 2109: 
            case 2110: 
            case 2111: 
            case 2112: 
            case 2113: 
            case 2114: 
            case 3066: 
            case 3069: 
            case 3071: 
            case 3078: 
            case 3087: 
            case 3088: 
            case 3091: 
            case 3092: 
            case 3093: 
            case 3094: 
            case 3095: 
            case 3096: 
            case 3097: 
            case 3100: 
            case 3101: 
            case 3102: 
            case 3103: 
            case 3104: 
            case 3105: 
            case 3106: 
            case 3107: 
            case 3108: 
            case 3109: 
            case 3110: 
            case 3111: 
            case 3112: 
            case 3113: 
            case 3114: 
            case 3115: 
            case 3116: 
            case 3117: 
            case 3118: 
            case 3119: 
            case 3120: 
            case 3121: {
                return true;
            }
        }
        return false;
    }
}

