/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.library;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluationEnvironment;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.library.AbstractIterationManager;
import org.eclipse.ocl.examples.domain.values.CollectionValue;

public abstract class EvaluatorIterationManager
extends AbstractIterationManager {
    @NonNull
    protected final CollectionValue collectionValue;
    @NonNull
    protected final DomainExpression body;
    @Nullable
    protected final DomainTypedElement accumulatorVariable;
    @Nullable
    private Object accumulatorValue;

    protected static ValueIterator[] createIterators(@NonNull DomainTypedElement[] referredIterators, @NonNull DomainEvaluator evaluator, @NonNull CollectionValue collectionValue) {
        int iMax = referredIterators.length;
        ValueIterator[] iterators = new ValueIterator[iMax];
        int i = 0;
        while (i < iMax) {
            DomainTypedElement referredIterator = referredIterators[i];
            if (referredIterator != null) {
                ValueIterator valueIterator = new ValueIterator(evaluator, collectionValue, referredIterator);
                if (!valueIterator.hasCurrent()) {
                    return null;
                }
                iterators[i] = valueIterator;
            }
            ++i;
        }
        return iterators;
    }

    public EvaluatorIterationManager(@NonNull DomainEvaluator evaluator, @NonNull DomainExpression body, @NonNull CollectionValue collectionValue, @Nullable DomainTypedElement accumulatorVariable, @Nullable Object accumulatorValue) {
        super(evaluator);
        this.collectionValue = collectionValue;
        this.body = body;
        this.accumulatorVariable = accumulatorVariable;
        this.accumulatorValue = accumulatorValue;
        if (accumulatorVariable != null) {
            this.getEvaluationEnvironment().add(accumulatorVariable, accumulatorValue);
        }
    }

    public EvaluatorIterationManager(@NonNull EvaluatorIterationManager iterationManager, @NonNull CollectionValue collectionValue) {
        super(iterationManager.evaluator);
        this.body = iterationManager.body;
        this.collectionValue = collectionValue;
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.accumulatorVariable = iterationManager.accumulatorVariable;
    }

    @Nullable
    public Object evaluateBody() {
        return this.evaluator.evaluate(this.body);
    }

    @Nullable
    public Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    @NonNull
    public CollectionValue getCollectionValue() {
        return this.collectionValue;
    }

    @NonNull
    public DomainEvaluationEnvironment getEvaluationEnvironment() {
        return this.evaluator.getEvaluationEnvironment();
    }

    @NonNull
    public CollectionValue getSourceCollection() {
        return this.collectionValue;
    }

    public String toString() {
        return this.body.toString();
    }

    @Nullable
    public Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        DomainTypedElement accumulatorVariable2 = this.accumulatorVariable;
        if (accumulatorVariable2 != null) {
            this.getEvaluationEnvironment().replace(accumulatorVariable2, this.accumulatorValue);
        }
        return null;
    }

    protected static class ValueIterator {
        private final DomainEvaluationEnvironment evaluationEnvironment;
        @NonNull
        private final CollectionValue collectionValue;
        @NonNull
        private final DomainTypedElement variable;
        private Iterator<? extends Object> javaIter;
        private Object value;

        public ValueIterator(@NonNull DomainEvaluator evaluator, @NonNull CollectionValue collectionValue, @NonNull DomainTypedElement variable) {
            this.evaluationEnvironment = evaluator.getEvaluationEnvironment();
            this.collectionValue = collectionValue;
            this.variable = variable;
            this.reset();
        }

        @Nullable
        public Object get() {
            return this.value;
        }

        public boolean hasCurrent() {
            return this.value != this;
        }

        @Nullable
        public Object next() {
            if (!this.javaIter.hasNext()) {
                this.value = this;
            } else {
                this.value = this.javaIter.next();
                this.evaluationEnvironment.replace(this.variable, this.value);
            }
            return this.value;
        }

        public Object reset() {
            this.javaIter = this.collectionValue.iterator();
            return this.next();
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.variable)) + " = " + (this.value != this ? String.valueOf(this.value) : "<<END>>");
        }
    }
}

