/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.library.EvaluatorIterationManager;
import org.eclipse.ocl.examples.domain.values.CollectionValue;

public class EvaluatorSingleIterationManager
extends EvaluatorIterationManager {
    @NonNull
    protected final DomainTypedElement referredIterator;
    @NonNull
    protected final EvaluatorIterationManager.ValueIterator iterator;

    public EvaluatorSingleIterationManager(@NonNull DomainEvaluator invokingEvaluator, @NonNull DomainExpression body, @NonNull CollectionValue collectionValue, @Nullable DomainTypedElement accumulator, @Nullable Object accumulatorValue, @NonNull DomainTypedElement referredIterator) {
        super(invokingEvaluator.createNestedEvaluator(), body, collectionValue, accumulator, accumulatorValue);
        this.referredIterator = referredIterator;
        this.iterator = new EvaluatorIterationManager.ValueIterator(this.evaluator, collectionValue, referredIterator);
    }

    protected EvaluatorSingleIterationManager(@NonNull EvaluatorSingleIterationManager iterationManager, @NonNull CollectionValue value) {
        super(iterationManager, value);
        this.referredIterator = iterationManager.referredIterator;
        this.iterator = new EvaluatorIterationManager.ValueIterator(this.evaluator, this.collectionValue, this.referredIterator);
    }

    public boolean advanceIterators() {
        this.iterator.next();
        return this.hasCurrent();
    }

    @NonNull
    public DomainIterationManager createNestedIterationManager(@NonNull CollectionValue value) {
        return new Nested(this, value);
    }

    @Nullable
    public Object get() {
        return this.iterator.get();
    }

    public int getDepth() {
        return 0;
    }

    @NonNull
    public EvaluatorSingleIterationManager getRootIterationManager() {
        return this;
    }

    public boolean hasCurrent() {
        return this.iterator.hasCurrent();
    }

    public boolean isOuterIteration() {
        return true;
    }

    class Nested
    extends EvaluatorSingleIterationManager {
        @NonNull
        protected final EvaluatorSingleIterationManager rootIterationManager;
        protected final int depth;

        protected Nested(@NonNull EvaluatorSingleIterationManager iterationManager, CollectionValue value) {
            super(iterationManager, value);
            this.rootIterationManager = iterationManager.getRootIterationManager();
            this.depth = iterationManager.getDepth() + 1;
        }

        public int getDepth() {
            return this.depth;
        }

        @NonNull
        public EvaluatorSingleIterationManager getRootIterationManager() {
            return this.rootIterationManager;
        }

        @NonNull
        public CollectionValue getSourceCollection() {
            return this.rootIterationManager.getSourceCollection();
        }

        public boolean isOuterIteration() {
            return false;
        }
    }
}

