/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainMetaclass;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.AbstractSpecializedType;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

public class AbstractMetaclass
extends AbstractSpecializedType
implements DomainMetaclass {
    @NonNull
    protected final DomainType instanceType;
    @NonNull
    protected final TypeId typeId;
    private DomainType metaType = null;
    private DomainType normalizedInstanceType = null;
    private int hashCode;

    public AbstractMetaclass(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType instanceType) {
        super(standardLibrary, DomainUtil.nonNullModel(standardLibrary.getMetaclassType().getName()), standardLibrary.getMetaclassType());
        this.instanceType = instanceType;
        this.typeId = TypeId.METACLASS.getSpecializedId(instanceType.getTypeId());
    }

    public boolean conformsTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        if (this == type) {
            return true;
        }
        DomainType thisMetaType = this.getMetaType();
        DomainType thatMetaType = type;
        return thisMetaType != null ? thisMetaType.conformsTo(standardLibrary, thatMetaType) : false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DomainMetaclass)) {
            return false;
        }
        DomainType thisInstanceType = this.getNormalizedInstanceType();
        DomainType thatInstanceType = ((DomainMetaclass)obj).getInstanceType().getNormalizedType(this.standardLibrary);
        return thisInstanceType.isEqualTo(this.standardLibrary, thatInstanceType);
    }

    @NonNull
    public DomainType getCommonType(@NonNull IdResolver idResolver, @NonNull DomainType type) {
        if (!(type instanceof DomainMetaclass)) {
            return this.standardLibrary.getOclAnyType();
        }
        DomainType thatInstanceType = DomainUtil.nonNullModel(((DomainMetaclass)type).getInstanceType());
        DomainType commonInstanceType = this.instanceType.getCommonType(idResolver, thatInstanceType);
        if (commonInstanceType == this.instanceType) {
            return this;
        }
        if (commonInstanceType == thatInstanceType) {
            return type;
        }
        return this.standardLibrary.getMetaclass(commonInstanceType);
    }

    public DomainType getInstanceType() {
        return this.instanceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected DomainType getMetaType() {
        if (this.metaType == null) {
            AbstractMetaclass abstractMetaclass = this;
            synchronized (abstractMetaclass) {
                if (this.metaType == null) {
                    String metaTypeName = this.instanceType.getMetaTypeName();
                    this.metaType = this.standardLibrary.getOclType(metaTypeName);
                }
            }
        }
        return this.metaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected DomainType getNormalizedInstanceType() {
        DomainType normalizedInstanceType2 = this.normalizedInstanceType;
        if (normalizedInstanceType2 == null) {
            AbstractMetaclass abstractMetaclass = this;
            synchronized (abstractMetaclass) {
                normalizedInstanceType2 = this.normalizedInstanceType;
                if (normalizedInstanceType2 == null) {
                    this.normalizedInstanceType = normalizedInstanceType2 = this.instanceType.getNormalizedType(this.standardLibrary);
                    this.hashCode = normalizedInstanceType2.hashCode();
                }
            }
        }
        return normalizedInstanceType2;
    }

    @NonNull
    public TypeId getTypeId() {
        return this.typeId;
    }

    public int hashCode() {
        if (this.normalizedInstanceType == null) {
            this.getNormalizedInstanceType();
        }
        return this.hashCode;
    }

    public boolean isEqualTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof DomainMetaclass)) {
            return false;
        }
        DomainType thisInstanceType = this.getNormalizedInstanceType();
        DomainType thatInstanceType = ((DomainMetaclass)type).getInstanceType().getNormalizedType(standardLibrary);
        return thisInstanceType.isEqualTo(standardLibrary, thatInstanceType);
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.containerType)) + "(" + String.valueOf(this.instanceType) + ")";
    }
}

