/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import java.lang.ref.WeakReference;
import java.util.Map;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainEnumeration;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainLambdaType;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.IntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardLibrary
implements DomainStandardLibrary {
    protected AbstractStandardLibrary() {
    }

    @Override
    public boolean conformsToCollectionType(@NonNull DomainCollectionType firstCollectionType, @NonNull DomainCollectionType secondCollectionType) {
        IntegerValue secondUpper;
        IntegerValue secondLower;
        IntegerValue firstLower;
        DomainType secondElementType;
        DomainType firstElementType;
        DomainType secondContainerType;
        DomainType firstContainerType = firstCollectionType.getContainerType();
        if (firstContainerType != (secondContainerType = secondCollectionType.getContainerType())) {
            if (firstContainerType == null || secondContainerType == null) {
                return false;
            }
            DomainInheritance firstInheritance = firstContainerType.getInheritance(this);
            DomainInheritance secondInheritance = secondContainerType.getInheritance(this);
            if (!secondInheritance.isSuperInheritanceOf(this, firstInheritance)) {
                return false;
            }
        }
        if ((firstElementType = firstCollectionType.getElementType()) != (secondElementType = secondCollectionType.getElementType())) {
            if (firstElementType == null || secondElementType == null) {
                return false;
            }
            if (!firstElementType.conformsTo(this, secondElementType)) {
                return false;
            }
        }
        if ((firstLower = firstCollectionType.getLowerValue()).compareTo(secondLower = secondCollectionType.getLowerValue()) < 0) {
            return false;
        }
        IntegerValue firstUpper = firstCollectionType.getUpperValue();
        return firstUpper.compareTo(secondUpper = secondCollectionType.getUpperValue()) <= 0;
    }

    @Override
    public boolean conformsToLambdaType(@NonNull DomainLambdaType firstLambdaType, @NonNull DomainLambdaType secondLambdaType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean conformsToTupleType(@NonNull DomainTupleType firstTupleType, @NonNull DomainTupleType secondTupleType) {
        if (this.isEqualToTupleType(firstTupleType, secondTupleType)) {
            return true;
        }
        DomainInheritance firstInheritance = firstTupleType.getInheritance(this);
        DomainInheritance secondInheritance = secondTupleType.getInheritance(this);
        return firstInheritance.isSuperInheritanceOf(this, secondInheritance);
    }

    public void dispose() {
    }

    @NonNull
    public DomainCollectionType getBagType(@NonNull DomainType elementType) {
        return this.getBagType(elementType, null, null);
    }

    @NonNull
    public DomainCollectionType getCollectionType(@NonNull DomainType elementType) {
        return this.getCollectionType(this.getCollectionType(), elementType, null, null);
    }

    @Override
    @NonNull
    public DomainCollectionType getCollectionType(@NonNull DomainType containerType, @NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        boolean isOrdered = containerType.isOrdered();
        boolean isUnique = containerType.isUnique();
        if (isOrdered) {
            if (isUnique) {
                return this.getOrderedSetType(elementType, lower, upper);
            }
            return this.getSequenceType(elementType, lower, upper);
        }
        if (isUnique) {
            return this.getSetType(elementType, lower, upper);
        }
        return this.getBagType(elementType, lower, upper);
    }

    @Override
    public DomainEnumeration getEnumeration(@NonNull Enumerator enumerator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DomainType getMetaType(@NonNull DomainType instanceType) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public DomainPackage getNestedPackage(@NonNull DomainPackage parentPackage, @NonNull String name) {
        return DomainUtil.getNamedElement(parentPackage.getNestedPackage(), name);
    }

    @Override
    @Nullable
    public DomainType getNestedType(@NonNull DomainPackage parentPackage, @NonNull String name) {
        return DomainUtil.getNamedElement(parentPackage.getOwnedType(), name);
    }

    @Override
    @Nullable
    public DomainPackage getNsURIPackage(@NonNull String nsURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public DomainElement getOperationTemplateParameter(@NonNull DomainOperation anOperation, int index) {
        return anOperation.getTypeParameters().get(index);
    }

    @NonNull
    public DomainCollectionType getOrderedSetType(@NonNull DomainType elementType) {
        return this.getOrderedSetType(elementType, null, null);
    }

    @Override
    @Nullable
    public DomainType getPrimitiveType(@NonNull PrimitiveTypeId typeId) {
        if (typeId == TypeId.BOOLEAN) {
            return this.getBooleanType();
        }
        if (typeId == TypeId.INTEGER) {
            return this.getIntegerType();
        }
        if (typeId == TypeId.REAL) {
            return this.getRealType();
        }
        if (typeId == TypeId.STRING) {
            return this.getStringType();
        }
        if (typeId == TypeId.UNLIMITED_NATURAL) {
            return this.getUnlimitedNaturalType();
        }
        if (typeId == TypeId.OCL_ANY) {
            return this.getOclAnyType();
        }
        if (typeId == TypeId.OCL_COMPARABLE) {
            return this.getOclComparableType();
        }
        if (typeId == TypeId.OCL_SELF) {
            return this.getOclSelfType();
        }
        if (typeId == TypeId.OCL_SUMMABLE) {
            return this.getOclSummableType();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DomainPackage getRootPackage(@NonNull String name) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainCollectionType getSequenceType(@NonNull DomainType elementType) {
        return this.getSequenceType(elementType, null, null);
    }

    @NonNull
    public DomainCollectionType getSetType(@NonNull DomainType elementType) {
        return this.getSetType(elementType, null, null);
    }

    @Override
    public boolean isEqualToCollectionType(@NonNull DomainCollectionType firstCollectionType, @NonNull DomainCollectionType secondCollectionType) {
        DomainType secondElementType;
        DomainType firstElementType;
        DomainType secondContainerType;
        DomainType firstContainerType = firstCollectionType.getContainerType();
        if (firstContainerType != (secondContainerType = secondCollectionType.getContainerType())) {
            if (firstContainerType == null || secondContainerType == null) {
                return false;
            }
            if (!firstContainerType.isEqualToUnspecializedType(this, secondContainerType)) {
                return false;
            }
        }
        if ((firstElementType = firstCollectionType.getElementType()) != (secondElementType = secondCollectionType.getElementType())) {
            if (firstElementType == null || secondElementType == null) {
                return false;
            }
            if (!firstElementType.isEqualTo(this, secondElementType)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEqualToTupleType(@NonNull DomainTupleType firstTupleType, @NonNull DomainTupleType secondTupleType) {
        TupleTypeId secondParts;
        TupleTypeId firstParts = firstTupleType.getTypeId();
        return firstParts == (secondParts = secondTupleType.getTypeId());
    }

    protected <K, V> V weakGet(@NonNull Map<K, WeakReference<V>> map, @NonNull K key) {
        WeakReference<V> ref = map.get(key);
        if (ref == null) {
            return null;
        }
        Object value = ref.get();
        if (value == null) {
            map.remove(key);
        }
        return (V)value;
    }
}

