/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.values.Bag;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.BagImpl;
import org.eclipse.ocl.examples.domain.values.impl.BagValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SparseOrderedSetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SparseSequenceValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.TupleValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.ValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionValueImpl
extends ValueImpl
implements CollectionValue,
Iterable<Object> {
    @NonNull
    public static NullIterator EMPTY_ITERATOR = new NullIterator();
    @NonNull
    protected final CollectionTypeId typeId;
    @NonNull
    protected final Collection<? extends Object> elements;
    private int hashCode = 0;

    public static void initStatics() {
    }

    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.COLLECTION_VALUE;
    }

    protected CollectionValueImpl(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> values) {
        this.typeId = typeId;
        this.elements = values;
        assert (this.checkElementsAreValues(values));
    }

    protected boolean checkElementsAreUnique(Iterable<? extends Object> elements) {
        HashSet<Object> knownElements = new HashSet<Object>();
        for (Object object : elements) {
            assert (knownElements.add(object));
        }
        return true;
    }

    private boolean checkElementsAreValues(Iterable<? extends Object> elements) {
        for (Object object : elements) {
            assert (ValuesUtil.isBoxed(object));
        }
        return true;
    }

    @Override
    @NonNull
    public BagValue asBagValue() {
        return new BagValueImpl(this.getBagTypeId(), (Bag<? extends Object>)new BagImpl<Object>(this.elements));
    }

    @Override
    @NonNull
    public Collection<? extends Object> asCollection() {
        return this.elements;
    }

    @Override
    @NonNull
    public CollectionValue asCollectionValue() {
        return this;
    }

    @Override
    @NonNull
    public List<Object> asEcoreObject() {
        Object[] data = new Object[this.intSize()];
        int i = 0;
        for (Object object : this.iterable()) {
            data[i++] = object instanceof Value ? ((Value)object).asEcoreObject() : object;
        }
        return new EcoreEList.UnmodifiableEList(null, null, data.length, data);
    }

    @NonNull
    public List<? extends Object> asList() {
        return new ArrayList<Object>(this.elements);
    }

    @Override
    @NonNull
    public Object asObject() {
        return this.elements;
    }

    @Override
    @NonNull
    public OrderedSetValue asOrderedSetValue() {
        return new SparseOrderedSetValueImpl(this.getOrderedSetTypeId(), this.elements);
    }

    @Override
    @NonNull
    public SequenceValue asSequenceValue() {
        return new SparseSequenceValueImpl(this.getSequenceTypeId(), (List<? extends Object>)new ArrayList<Object>(this.elements));
    }

    @Override
    @NonNull
    public SetValue asSetValue() {
        return new SetValueImpl(this.getSetTypeId(), this.elements);
    }

    @Override
    @NonNull
    public IntegerValue count(@Nullable Object value) {
        long count = 0L;
        if (value == null) {
            for (Object object : this.elements) {
                if (object != null) continue;
                ++count;
            }
        } else {
            for (Object object : this.elements) {
                if (!value.equals(object)) continue;
                ++count;
            }
        }
        return ValuesUtil.integerValueOf(count);
    }

    @Override
    @NonNull
    public Boolean excludes(@Nullable Object value) {
        if (value == null) {
            for (Object object : this.elements) {
                if (object != null) continue;
                return false;
            }
        } else {
            for (Object object : this.elements) {
                if (!value.equals(object)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NonNull
    public Boolean excludesAll(@NonNull CollectionValue c) {
        for (Object object : this.elements) {
            if (object == null) {
                for (Object object2 : c.iterable()) {
                    if (object2 != null) continue;
                    return false;
                }
                continue;
            }
            for (Object object3 : c.iterable()) {
                if (!object.equals(object3)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean flatten(@NonNull Collection<Object> flattenedElements) {
        boolean flattened = false;
        for (Object object : this.elements) {
            CollectionValue collectionElement = ValuesUtil.isCollectionValue(object);
            if (collectionElement != null) {
                flattened = true;
                collectionElement.flatten(flattenedElements);
                continue;
            }
            flattenedElements.add(object);
        }
        return flattened;
    }

    @NonNull
    public CollectionTypeId getBagTypeId() {
        return TypeId.BAG.getSpecializedId(this.getElementTypeId());
    }

    @NonNull
    public TypeId getElementTypeId() {
        return this.getTypeId().getElementTypeId();
    }

    @Override
    @NonNull
    public Collection<? extends Object> getElements() {
        return this.elements;
    }

    @NonNull
    public Collection<? extends Object> getObject() {
        return this.elements;
    }

    @NonNull
    public CollectionTypeId getOrderedSetTypeId() {
        return TypeId.ORDERED_SET.getSpecializedId(this.getElementTypeId());
    }

    @NonNull
    public CollectionTypeId getSequenceTypeId() {
        return TypeId.SEQUENCE.getSpecializedId(this.getElementTypeId());
    }

    @NonNull
    public CollectionTypeId getSetTypeId() {
        return TypeId.SET.getSpecializedId(this.getElementTypeId());
    }

    @Override
    @NonNull
    public CollectionTypeId getTypeId() {
        return this.typeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        if (this.hashCode == 0) {
            CollectionValueImpl collectionValueImpl = this;
            synchronized (collectionValueImpl) {
                if (this.hashCode == 0) {
                    long hash;
                    long l = hash = this.isUnique() ? 0x5555555555555555L : 0x7777777777777777L;
                    if (this.isOrdered()) {
                        for (Object object : this.elements) {
                            hash *= 5L;
                            if (object == null) continue;
                            hash += (long)object.hashCode();
                        }
                    } else {
                        for (Object object : this.elements) {
                            if (object == null) continue;
                            hash += (long)object.hashCode();
                        }
                    }
                    this.hashCode = (int)hash;
                    if (this.hashCode == 0) {
                        this.hashCode = (int)(hash >> 32);
                        if (this.hashCode == 0) {
                            this.hashCode = -1737075662;
                        }
                    }
                }
            }
        }
        return this.hashCode;
    }

    @Override
    @NonNull
    public Boolean includes(@Nullable Object value) {
        return this.elements.contains(value);
    }

    @Override
    @NonNull
    public Boolean includesAll(@NonNull CollectionValue c) {
        for (Object object : c.iterable()) {
            boolean gotIt = false;
            if (object == null) {
                for (Object object2 : this.elements) {
                    if (object2 != null) continue;
                    gotIt = true;
                    break;
                }
            } else {
                for (Object object3 : this.elements) {
                    if (!object.equals(object3)) continue;
                    gotIt = true;
                    break;
                }
            }
            if (gotIt) continue;
            return false;
        }
        return true;
    }

    @Override
    public int intSize() {
        return this.elements.size();
    }

    @Override
    @NonNull
    public CollectionValue intersection(@NonNull CollectionValue that) {
        assert (!this.isUndefined() && !that.isUndefined());
        Collection<? extends Object> theseElements = this.asCollection();
        Collection<? extends Object> thoseElements = that.asCollection();
        int thisSize = theseElements.size();
        int thatSize = thoseElements.size();
        if (this instanceof UniqueCollectionValue || that instanceof UniqueCollectionValue) {
            HashSet<? extends Object> results;
            CollectionTypeId typeId = this.getSetTypeId();
            if (thisSize == 0 || thatSize == 0) {
                return new SetValueImpl(typeId, ValuesUtil.EMPTY_SET);
            }
            if (thisSize <= thatSize) {
                results = new HashSet<Object>(theseElements);
                results.retainAll(thoseElements);
            } else {
                results = new HashSet<Object>(thoseElements);
                results.retainAll(theseElements);
            }
            return new SetValueImpl(typeId, results.size() > 0 ? results : ValuesUtil.EMPTY_SET);
        }
        CollectionTypeId typeId = this.getBagTypeId();
        if (thisSize == 0 || thatSize == 0) {
            return new BagValueImpl(typeId, ValuesUtil.EMPTY_BAG);
        }
        BagImpl results = new BagImpl();
        HashSet<? extends Object> minElements = new HashSet<Object>(thisSize < thatSize ? theseElements : thoseElements);
        for (Object e : minElements) {
            IntegerValue leftCount = this.count(e);
            IntegerValue rightCount = that.count(e);
            int i = Math.min(leftCount.asInteger(), rightCount.asInteger());
            while (i > 0) {
                results.add(e);
                --i;
            }
        }
        return new BagValueImpl(typeId, results.size() > 0 ? results : ValuesUtil.EMPTY_BAG);
    }

    @Override
    @NonNull
    public Boolean isEmpty() {
        if (this.intSize() == 0) {
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public Iterable<? extends Object> iterable() {
        return this.elements;
    }

    @Override
    @NonNull
    public Iterator<Object> iterator() {
        if (this.elements instanceof BasicEList) {
            BasicEList castElements = (BasicEList)this.elements;
            Object[] data = castElements.data();
            return data != null ? new ArrayIterator<Object>(data, this.elements.size()) : EMPTY_ITERATOR;
        }
        if (this.elements instanceof List) {
            List castElements = (List)this.elements;
            return new ListIterator<Object>(castElements);
        }
        Iterator<Object> result = this.elements.iterator();
        return result;
    }

    @Override
    @NonNull
    public Boolean notEmpty() {
        if (this.intSize() != 0) {
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public Set<TupleValue> product(@NonNull CollectionValue c, @NonNull TupleTypeId tupleTypeId) {
        HashSet<TupleValue> result = new HashSet<TupleValue>();
        for (Object object : this.iterable()) {
            for (Object object2 : c.iterable()) {
                result.add(new TupleValueImpl(tupleTypeId, object, object2));
            }
        }
        return result;
    }

    @Override
    @NonNull
    public IntegerValue size() {
        return ValuesUtil.integerValueOf(this.intSize());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        this.toString(s, 100);
        return s.toString();
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("{");
        boolean isFirst = true;
        for (Object object : this.iterable()) {
            if (!isFirst) {
                s.append(",");
            }
            if (s.length() >= lengthLimit) {
                s.append("...");
                break;
            }
            ValuesUtil.toString(object, s, lengthLimit - 1);
            isFirst = false;
        }
        s.append("}");
    }

    @Override
    @NonNull
    public CollectionValue union(@NonNull CollectionValue that) {
        assert (!this.isUndefined() && !that.isUndefined());
        Collection<? extends Object> theseElements = this.asCollection();
        Collection<? extends Object> thoseElements = that.asCollection();
        if (this instanceof UniqueCollectionValue && that instanceof UniqueCollectionValue) {
            if (theseElements.isEmpty()) {
                return that.asSetValue();
            }
            if (thoseElements.isEmpty()) {
                return this.asSetValue();
            }
            HashSet<? extends Object> result = new HashSet<Object>(theseElements);
            result.addAll(thoseElements);
            return new SetValueImpl(this.getSetTypeId(), result);
        }
        if (theseElements.isEmpty()) {
            return that.asBagValue();
        }
        if (thoseElements.isEmpty()) {
            return this.asBagValue();
        }
        BagImpl<? extends Object> result = new BagImpl<Object>(theseElements);
        result.addAll(thoseElements);
        return new BagValueImpl(this.getBagTypeId(), (Bag<? extends Object>)result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayIterator<T>
    implements Iterator<T> {
        @NonNull
        protected final T[] elements;
        protected final int size;
        private int index;

        public ArrayIterator(@NonNull T[] elements, int size) {
            this.elements = elements;
            this.index = 0;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public T next() {
            return this.elements[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListIterator<T>
    implements Iterator<T> {
        @NonNull
        protected final List<T> elements;
        protected final int size;
        private int index;

        public ListIterator(@NonNull List<T> elements) {
            this.elements = elements;
            this.index = 0;
            this.size = elements.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public T next() {
            return this.elements.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullIterator
    implements Iterator<Object> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

