/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.core;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.papyrus.xwt.XWT;
import org.eclipse.papyrus.xwt.XWTException;
import org.eclipse.papyrus.xwt.core.SetterBase;
import org.eclipse.papyrus.xwt.core.TriggerBase;
import org.eclipse.papyrus.xwt.metadata.IMetaclass;
import org.eclipse.papyrus.xwt.metadata.IProperty;

public class Setter
extends SetterBase {
    protected String property;
    protected Object value;
    protected String targetName;

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object applyTo(Object element, boolean update) {
        IMetaclass metaclass;
        IProperty prop;
        String propName = this.getProperty();
        Object propValue = this.getValue();
        String targetName = this.getTargetName();
        Object setterTarget = element;
        Object oldValue = null;
        if (targetName != null) {
            setterTarget = TriggerBase.getElementByName(element, targetName);
        }
        if ((prop = (metaclass = XWT.getMetaclass(setterTarget)).findProperty(propName)) != null && propValue != null) {
            Object toValue = propValue;
            Class<?> valueType = propValue.getClass();
            Class<?> targetType = prop.getType();
            if (targetType != null && !targetType.isAssignableFrom(valueType)) {
                IConverter converter = XWT.findConvertor(valueType, targetType);
                if (converter != null) {
                    toValue = converter.convert(propValue);
                } else {
                    throw new XWTException("Converter doesn't exist from \"" + valueType.getName() + "\" to \"" + targetType.getName());
                }
            }
            try {
                oldValue = prop.getValue(setterTarget);
                if (update) {
                    prop.setValue(setterTarget, toValue);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return oldValue;
    }

    public void undo(Object element, Object value) {
        IMetaclass metaclass;
        IProperty prop;
        String propName = this.getProperty();
        String targetName = this.getTargetName();
        Object setterTarget = element;
        if (targetName != null) {
            setterTarget = TriggerBase.getElementByName(element, targetName);
        }
        if ((prop = (metaclass = XWT.getMetaclass(setterTarget)).findProperty(propName)) != null) {
            try {
                prop.setValue(setterTarget, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

