/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.IORuntimeException;

public class DiffieHellman {

    public static class Client {
        public Response handleChallenge(Server.Challenge challenge, byte[] clearText) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(challenge.getServerPubKeyEnc());
                PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
                DHParameterSpec dhParamSpec = ((DHPublicKey)pubKey).getParams();
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
                keyPairGenerator.initialize(dhParamSpec);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                KeyAgreement clientKeyAgree = KeyAgreement.getInstance("DH");
                clientKeyAgree.init(keyPair.getPrivate());
                byte[] pubKeyEnc = keyPair.getPublic().getEncoded();
                clientKeyAgree.doPhase(pubKey, true);
                SecretKey sharedSecret = clientKeyAgree.generateSecret(challenge.getSecretAlgorithm());
                Cipher clientCipher = Cipher.getInstance(challenge.getCypherTransformation());
                clientCipher.init(1, sharedSecret);
                byte[] ciphertext = clientCipher.doFinal(clearText);
                AlgorithmParameters params = clientCipher.getParameters();
                byte[] paramsEnc = params == null ? null : params.getEncoded();
                return new Response(pubKeyEnc, ciphertext, paramsEnc);
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }

        public static final class Response {
            private final byte[] clientPubKeyEnc;
            private final byte[] cipherText;
            private final byte[] paramsEnc;

            public Response(byte[] clientPubKeyEnc, byte[] cipherText, byte[] paramsEnc) {
                this.clientPubKeyEnc = clientPubKeyEnc;
                this.cipherText = cipherText;
                this.paramsEnc = paramsEnc;
            }

            public Response(ExtendedDataInput in) throws IOException {
                this.clientPubKeyEnc = in.readByteArray();
                this.cipherText = in.readByteArray();
                this.paramsEnc = in.readByteArray();
            }

            public void write(ExtendedDataOutput out) throws IOException {
                out.writeByteArray(this.clientPubKeyEnc);
                out.writeByteArray(this.cipherText);
                out.writeByteArray(this.paramsEnc);
            }

            public byte[] getClientPubKeyEnc() {
                return this.clientPubKeyEnc;
            }

            public byte[] getCipherText() {
                return this.cipherText;
            }

            public byte[] getParamsEnc() {
                return this.paramsEnc;
            }
        }
    }

    public static final class ParameterSpecGenerator {
        public static DHParameterSpec generate(int bits) {
            try {
                AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH");
                paramGen.init(bits);
                AlgorithmParameters params = paramGen.generateParameters();
                return params.getParameterSpec(DHParameterSpec.class);
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
        }
    }

    public static class Server {
        public static final String DEFAULT_SECRET_ALGORITHM = "DES";
        public static final String DEFAULT_CYPHER_TRANSFORMATION = "DES/CBC/PKCS5Padding";
        private final String realm;
        private final KeyAgreement keyAgree;
        private final Challenge challenge;

        public Server(String realm, DHParameterSpec dhParamSpec, String secretAlgorithm, String cypherTransformation) {
            this.realm = realm;
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
                keyPairGenerator.initialize(dhParamSpec);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                this.keyAgree = KeyAgreement.getInstance("DH");
                this.keyAgree.init(keyPair.getPrivate());
                byte[] pubKeyEnc = keyPair.getPublic().getEncoded();
                this.challenge = new Challenge(realm, secretAlgorithm, cypherTransformation, pubKeyEnc);
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
        }

        public Server(String realm, DHParameterSpec dhParamSpec) {
            this(realm, dhParamSpec, DEFAULT_SECRET_ALGORITHM, DEFAULT_CYPHER_TRANSFORMATION);
        }

        public Server(String realm) {
            this(realm, SkipParameterSpec.INSTANCE);
        }

        public final String getRealm() {
            return this.realm;
        }

        public final Challenge getChallenge() {
            return this.challenge;
        }

        public byte[] handleResponse(Client.Response response) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(response.getClientPubKeyEnc());
                PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
                this.keyAgree.doPhase(pubKey, true);
                SecretKey sharedSecret = this.keyAgree.generateSecret(this.challenge.getSecretAlgorithm());
                Cipher serverCipher = Cipher.getInstance(this.challenge.getCypherTransformation());
                byte[] encodedParams = response.getParamsEnc();
                if (encodedParams == null) {
                    serverCipher.init(2, sharedSecret);
                } else {
                    AlgorithmParameters params = AlgorithmParameters.getInstance(this.challenge.getSecretAlgorithm());
                    params.init(encodedParams);
                    serverCipher.init(2, (Key)sharedSecret, params);
                }
                return serverCipher.doFinal(response.getCipherText());
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }

        public static final class Challenge {
            private final String serverRealm;
            private final String secretAlgorithm;
            private final String cypherTransformation;
            private final byte[] serverPubKeyEnc;

            public Challenge(String serverRealm, String secretAlgorithm, String cypherTransformation, byte[] serverPubKeyEnc) {
                this.serverRealm = serverRealm;
                this.secretAlgorithm = secretAlgorithm;
                this.cypherTransformation = cypherTransformation;
                this.serverPubKeyEnc = serverPubKeyEnc;
            }

            public Challenge(ExtendedDataInput in) throws IOException {
                this.serverRealm = in.readString();
                this.secretAlgorithm = in.readString();
                this.cypherTransformation = in.readString();
                this.serverPubKeyEnc = in.readByteArray();
            }

            public void write(ExtendedDataOutput out) throws IOException {
                out.writeString(this.serverRealm);
                out.writeString(this.secretAlgorithm);
                out.writeString(this.cypherTransformation);
                out.writeByteArray(this.serverPubKeyEnc);
            }

            public String getServerRealm() {
                return this.serverRealm;
            }

            public String getSecretAlgorithm() {
                return this.secretAlgorithm;
            }

            public String getCypherTransformation() {
                return this.cypherTransformation;
            }

            public byte[] getServerPubKeyEnc() {
                return this.serverPubKeyEnc;
            }
        }
    }

    public static final class SkipParameterSpec {
        private static final byte[] skip1024ModulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
        private static final BigInteger skip1024Modulus = new BigInteger(1, skip1024ModulusBytes);
        private static final BigInteger skip1024Base = BigInteger.valueOf(2L);
        public static final DHParameterSpec INSTANCE = new DHParameterSpec(skip1024Modulus, skip1024Base);
    }
}

