/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.ast.IConstructorDeclaration;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SuperReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortMethod;

public class ConstructorDeclaration
extends AbstractMethodDeclaration
implements IConstructorDeclaration {
    public ExplicitConstructorCall constructorCall;
    public boolean isDefaultConstructor = false;

    public ConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public FlowInfo analyseCode(Scope classScope, FlowContext initializationContext, FlowInfo flowInfo) {
        this.analyseCode((ClassScope)classScope, (InitializationFlowContext)initializationContext, flowInfo, 0);
        return flowInfo;
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializerFlowContext, FlowInfo flowInfo, int initialReachMode) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        int nonStaticFieldInfoReachMode = flowInfo.reachMode();
        flowInfo.setReachMode(initialReachMode);
        MethodBinding constructorBinding = this.getBinding();
        if (constructorBinding == null || this.isDefaultConstructor || constructorBinding.isUsed() || (constructorBinding.isPrivate() ? (this.getBinding().declaringClass.tagBits & 0x10000000000000L) == 0L : (this.getBinding().declaringClass.tagBits & 0x30L) != 16L)) {
            // empty if block
        }
        try {
            int count;
            int i;
            int size;
            ArrayList computedExceptions;
            ExceptionHandlingFlowContext constructorContext = new ExceptionHandlingFlowContext(initializerFlowContext.parent, this, null, this.getScope(), FlowInfo.DEAD_END);
            initializerFlowContext.checkInitializerExceptions(this.getScope(), constructorContext, flowInfo);
            if (this.getBinding().declaringClass.isAnonymousType() && (computedExceptions = constructorContext.extendedExceptions) != null && (size = computedExceptions.size()) > 0) {
                computedExceptions.toArray(new ReferenceBinding[size]);
            }
            if (this.arguments != null) {
                int i2 = 0;
                int count2 = this.arguments.length;
                while (i2 < count2) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[i2].binding);
                    ++i2;
                }
            }
            if (this.constructorCall != null) {
                if (this.constructorCall.accessMode == 3) {
                    FieldBinding[] fields = this.getBinding().declaringClass.fields();
                    i = 0;
                    count = fields.length;
                    while (i < count) {
                        FieldBinding field = fields[i];
                        if (!field.isStatic()) {
                            flowInfo.markAsDefinitelyAssigned(field);
                        }
                        ++i;
                    }
                }
                flowInfo = this.constructorCall.analyseCode(this.getScope(), constructorContext, flowInfo);
            }
            flowInfo.setReachMode(nonStaticFieldInfoReachMode);
            if (this.statements != null) {
                boolean didAlreadyComplain = false;
                i = 0;
                count = this.statements.length;
                while (i < count) {
                    Statement stat = this.statements[i];
                    if (!stat.complainIfUnreachable(flowInfo, this.getScope(), didAlreadyComplain)) {
                        flowInfo = stat.analyseCode(this.getScope(), constructorContext, flowInfo);
                    } else {
                        didAlreadyComplain = true;
                    }
                    ++i;
                }
            }
            this.needFreeReturn = (flowInfo.tagBits & 1) == 0;
            flowInfo.setReachMode(initialReachMode);
            if (this.constructorCall != null && this.constructorCall.accessMode != 3) {
                flowInfo = flowInfo.mergedWith(constructorContext.initsOnReturn);
            }
            constructorContext.complainIfUnusedExceptionHandlers(this);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isDefaultConstructor() {
        return this.isDefaultConstructor;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isRecursive(ArrayList visited) {
        if (this.getBinding() == null || this.constructorCall == null || this.constructorCall.binding == null || this.constructorCall.isSuperAccess() || !this.constructorCall.binding.isValidBinding()) {
            return false;
        }
        ConstructorDeclaration targetConstructor = (ConstructorDeclaration)this.getScope().referenceType().declarationOf(this.constructorCall.binding.original());
        if (this == targetConstructor) {
            return true;
        }
        if (visited == null) {
            visited = new ArrayList<ConstructorDeclaration>(1);
        } else {
            int index = visited.indexOf(this);
            if (index >= 0) {
                return index == 0;
            }
        }
        visited.add(this);
        return targetConstructor.isRecursive(visited);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.isDefaultConstructor && this.constructorCall == null) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
            return;
        }
        parser.parse(this, unit);
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        output.append(" {");
        if (this.constructorCall != null) {
            output.append('\n');
            this.constructorCall.printStatement(indent, output);
        }
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                this.statements[i].printStatement(indent, output);
                ++i;
            }
        }
        output.append('\n');
        ConstructorDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    public void resolveJavadoc() {
        if (this.getBinding() == null || this.javadoc != null) {
            super.resolveJavadoc();
        } else if (!this.isDefaultConstructor) {
            this.getScope().problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.getBinding().modifiers);
        }
    }

    public void resolveStatements() {
        SourceTypeBinding sourceType = this.getScope().enclosingSourceType();
        if (!CharOperation.equals(sourceType.sourceName, this.selector)) {
            this.getScope().problemReporter().missingReturnType(this);
        }
        if (this.getBinding() != null && !this.getBinding().isPrivate()) {
            sourceType.tagBits |= 0x10000000000000L;
        }
        if (this.constructorCall != null) {
            if (sourceType.id == 1 && this.constructorCall.accessMode != 3) {
                this.constructorCall = null;
            } else {
                this.constructorCall.resolve(this.getScope());
            }
        }
        super.resolveStatements();
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.javadoc != null) {
                this.javadoc.traverse(visitor, this.getScope());
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, this.getScope());
                    ++i;
                }
            }
            if (this.constructorCall != null) {
                this.constructorCall.traverse(visitor, this.getScope());
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.getScope());
                    ++i;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    public int getASTType() {
        return 25;
    }
}

