/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class ExplicitConstructorCall
extends Statement
implements InvocationSite,
IExplicitConstructorCall {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    public int accessMode;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public static final int ImplicitSuper = 1;
    public static final int This = 3;
    public VariableBinding[][] implicitArguments;
    public int typeArgumentsSourceStart;

    public ExplicitConstructorCall(int accessMode) {
        this.accessMode = accessMode;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)currentScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                int i = 0;
                int max = this.arguments.length;
                while (i < max) {
                    flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                    ++i;
                }
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
            this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
            FlowInfo flowInfo2 = flowInfo;
            Object var6_7 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            return flowInfo2;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            throw throwable;
        }
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    public boolean isSuperAccess() {
        return this.accessMode != 3;
    }

    public boolean isTypeAccess() {
        return true;
    }

    void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        ReferenceBinding superTypeErasure = this.binding.declaringClass;
        if ((flowInfo.tagBits & 1) == 0 && superTypeErasure.isNestedType() && currentScope.enclosingSourceType().isLocalType() && superTypeErasure.isLocalType()) {
            ((LocalTypeBinding)superTypeErasure).addInnerEmulationDependent(currentScope, this.qualification != null);
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.codegenBinding = this.binding.original();
            if (this.binding.isPrivate() && this.accessMode != 3) {
                ReferenceBinding declaringClass = this.codegenBinding.declaringClass;
                if ((declaringClass.tagBits & 0x10L) != 0L && currentScope.compilerOptions().complianceLevel >= 0x300000L) {
                    this.codegenBinding.tagBits |= 0x400L;
                }
            }
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ExplicitConstructorCall.printIndent(indent, output);
        if (this.qualification != null) {
            this.qualification.printExpression(0, output).append('.');
        }
        if (this.typeArguments != null) {
            output.append('<');
            int max = this.typeArguments.length - 1;
            int j = 0;
            while (j < max) {
                this.typeArguments[j].print(0, output);
                output.append(", ");
                ++j;
            }
            this.typeArguments[max].print(0, output);
            output.append('>');
        }
        if (this.accessMode == 3) {
            output.append("this(");
        } else {
            output.append("super(");
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(");");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(BlockScope scope) {
        methodScope = scope.methodScope();
        try {
            block29: {
                block25: {
                    block26: {
                        methodDeclaration = methodScope.referenceMethod();
                        if (methodDeclaration == null || !methodDeclaration.isConstructor() || ((ConstructorDeclaration)methodDeclaration).constructorCall != this) {
                            if (this.qualification != null) {
                                this.qualification.resolveType(scope);
                            }
                            if (this.typeArguments != null) {
                                i = 0;
                                max = this.typeArguments.length;
                                while (i < max) {
                                    this.typeArguments[i].resolveType(scope, true);
                                    ++i;
                                }
                            }
                            if (this.arguments != null) {
                                i = 0;
                                max = this.arguments.length;
                                while (true) {
                                    if (i >= max) {
                                        break;
                                    }
                                    this.arguments[i].resolveType(scope);
                                    ++i;
                                }
                            }
lbl27:
                            // 8 sources

                            while (true) {
                                var12_10 = null;
                                methodScope.isConstructorCall = false;
                                return;
                            }
                        }
                        methodScope.isConstructorCall = true;
                        receiverType = scope.enclosingReceiverType();
                        if (this.accessMode != 3) {
                            receiverType = receiverType.getSuperBinding();
                        }
                        if (receiverType == null) ** GOTO lbl27
                        if (this.qualification != null) {
                            enclosingType = receiverType.enclosingType();
                            if (enclosingType == null) {
                                this.bits |= 8192;
                            } else {
                                this.qualification.resolveTypeExpecting(scope, enclosingType);
                            }
                        }
                        if (this.typeArguments == null) break block26;
                        length = this.typeArguments.length;
                        argHasError = false;
                        this.genericTypeArguments = new TypeBinding[length];
                        i = 0;
                        while (true) {
                            block27: {
                                if (i < length) break block27;
                                if (!argHasError) break;
                                ** GOTO lbl27
                            }
                            typeReference = this.typeArguments[i];
                            this.genericTypeArguments[i] = typeReference.resolveType(scope, true);
                            if (this.genericTypeArguments[i] == null) {
                                argHasError = true;
                            }
                            ++i;
                        }
                    }
                    argumentTypes = Binding.NO_PARAMETERS;
                    argsContainCast = false;
                    if (this.arguments == null) break block25;
                    argHasError = false;
                    length = this.arguments.length;
                    argumentTypes = new TypeBinding[length];
                    i = 0;
                    while (true) {
                        if (i >= length) {
                            if (argHasError) {
                                break;
                            }
                            break block25;
                        }
                        argument = this.arguments[i];
                        argumentTypes[i] = argument.resolveType(scope);
                        if (argumentTypes[i] == null) {
                            argHasError = true;
                        }
                        ++i;
                    }
                    pseudoArgs = new TypeBinding[length];
                    i = length;
                    while (true) {
                        block28: {
                            if (--i >= 0) break block28;
                            this.binding = scope.findMethod(receiverType, TypeConstants.INIT, pseudoArgs, this);
                            if (this.binding == null || this.binding.isValidBinding() || (closestMatch = ((ProblemMethodBinding)this.binding).closestMatch) == null) ** GOTO lbl27
                            this.binding = closestMatch;
                            closestMatchOriginal = closestMatch.original();
                            if (!closestMatchOriginal.isPrivate() && !closestMatchOriginal.declaringClass.isLocalType() || scope.isDefinedInMethod(closestMatchOriginal)) ** GOTO lbl27
                            closestMatchOriginal.modifiers |= 0x8000000;
                            ** continue;
                        }
                        pseudoArgs[i] = argumentTypes[i] == null ? TypeBinding.NULL : argumentTypes[i];
                    }
                }
                if (!(this.binding = scope.getConstructor(receiverType, argumentTypes, this)).isValidBinding()) break block29;
                if (this.isMethodUseDeprecated(this.binding, scope, this.accessMode != 1)) {
                    scope.problemReporter().deprecatedMethod(this.binding, this);
                }
                ExplicitConstructorCall.checkInvocationArguments(scope, null, receiverType, this.binding, this.arguments, argumentTypes, argsContainCast, this);
                if (this.binding.isPrivate() || receiverType.isLocalType()) {
                    this.binding.original().modifiers |= 0x8000000;
                }
                ** GOTO lbl-1000
            }
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = receiverType;
            }
            scope.problemReporter().invalidConstructor(this, this.binding);
        }
        catch (Throwable var13_23) {
            var12_11 = null;
            methodScope.isConstructorCall = false;
            throw var13_23;
        }
lbl-1000:
        // 2 sources

        {
            var12_12 = null;
            methodScope.isConstructorCall = false;
            return;
        }
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
    }

    public void setFieldIndex(int depth) {
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i;
            if (this.qualification != null) {
                this.qualification.traverse(visitor, scope);
            }
            if (this.typeArguments != null) {
                i = 0;
                int typeArgumentsLength = this.typeArguments.length;
                while (i < typeArgumentsLength) {
                    this.typeArguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.arguments != null) {
                i = 0;
                int argumentLength = this.arguments.length;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 32;
    }
}

