/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class FieldDeclaration
extends AbstractVariableDeclaration
implements IFieldDeclaration {
    public FieldBinding binding;
    public int endPart1Position;
    public int endPart2Position;

    public FieldDeclaration() {
    }

    public FieldDeclaration(char[] name, int sourceStart, int sourceEnd) {
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(MethodScope initializationScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.binding != null && !this.binding.isUsed() && (this.binding.isPrivate() || this.binding.declaringClass != null && this.binding.declaringClass.isLocalType()) && !initializationScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            initializationScope.problemReporter().unusedPrivateField(this);
        }
        if (this.initialization != null) {
            flowInfo = this.initialization.analyseCode(initializationScope, flowContext, flowInfo).unconditionalInits();
            flowInfo.markAsDefinitelyAssigned(this.binding);
        }
        return flowInfo;
    }

    public int getKind() {
        return 1;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        if (this.javadoc != null) {
            this.javadoc.print(indent, output);
        }
        return super.printStatement(indent, output);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(MethodScope initializationScope) {
        if ((this.bits & 0x10) != 0) {
            return;
        }
        if (this.binding == null) return;
        if (!this.binding.isValidBinding()) {
            return;
        }
        this.bits |= 0x10;
        ClassScope classScope = initializationScope.enclosingClassScope();
        if (classScope != null) {
            FieldBinding existingField;
            FieldBinding existingVariable;
            SourceTypeBinding declaringType = classScope.enclosingSourceType();
            if (declaringType.getSuperBinding0() != null && (existingVariable = classScope.findField(declaringType.getSuperBinding0(), this.name, this, false)) != null && existingVariable.isValidBinding() && (!(existingVariable instanceof FieldBinding) || (existingField = existingVariable).original() != this.binding)) {
                initializationScope.problemReporter().fieldHiding(this, existingVariable);
            } else {
                FieldBinding existingField2;
                Binding existingVariable2;
                Scope outerScope = classScope.parent;
                if (outerScope.kind != 4 && (existingVariable2 = outerScope.getBinding(this.name, 3, this, false)) != null && existingVariable2.isValidBinding() && existingVariable2 != this.binding && (!(existingVariable2 instanceof FieldBinding) || (existingField2 = (FieldBinding)existingVariable2).original() != this.binding && (existingField2.isStatic() || !declaringType.isStatic()))) {
                    initializationScope.problemReporter().fieldHiding(this, existingVariable2);
                }
            }
        }
        if (this.type != null) {
            this.type.resolvedType = this.binding.type;
        }
        FieldBinding previousField = initializationScope.initializedField;
        int previousFieldID = initializationScope.lastVisibleFieldID;
        try {
            initializationScope.initializedField = this.binding;
            initializationScope.lastVisibleFieldID = this.binding.id;
            if (this.initialization != null) {
                TypeBinding initializationType;
                TypeBinding fieldType = this.binding.type;
                this.initialization.setExpectedType(fieldType);
                if (this.initialization instanceof ArrayInitializer) {
                    initializationType = this.initialization.resolveTypeExpecting((BlockScope)initializationScope, fieldType);
                    if (initializationType != null) {
                        ((ArrayInitializer)this.initialization).binding = (ArrayBinding)initializationType;
                    }
                } else {
                    initializationType = this.initialization.resolveType(initializationScope);
                    if (initializationType != null) {
                        if (fieldType != initializationType) {
                            initializationScope.compilationUnitScope().recordTypeConversion(fieldType, initializationType);
                        }
                        if (!(this.initialization.isConstantValueOfTypeAssignableToType(initializationType, fieldType) || fieldType.isBaseType() && BaseTypeBinding.isWidening(fieldType.id, initializationType.id) || initializationType.isCompatibleWith(fieldType) || initializationScope.isBoxingCompatibleWith(initializationType, fieldType) || initializationType.isBaseType() && initializationScope.compilerOptions().sourceLevel >= 0x310000L && !fieldType.isBaseType() && this.initialization.isConstantValueOfTypeAssignableToType(initializationType, initializationScope.environment().computeBoxingType(fieldType)))) {
                            initializationScope.problemReporter().typeMismatchError(initializationType, fieldType, this);
                        }
                    }
                }
                if (this.binding == Assignment.getDirectBinding(this.initialization)) {
                    initializationScope.problemReporter().assignmentHasNoEffect(this, this.name);
                }
            }
            if (this.javadoc != null) {
                this.javadoc.resolve(initializationScope);
            } else if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
                initializationScope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
            }
            Object var7_10 = null;
            initializationScope.initializedField = previousField;
            initializationScope.lastVisibleFieldID = previousFieldID;
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            initializationScope.initializedField = previousField;
            initializationScope.lastVisibleFieldID = previousFieldID;
            throw throwable;
        }
    }

    public void traverse(ASTVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.javadoc != null) {
                this.javadoc.traverse(visitor, scope);
            }
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 36;
    }

    public IExpression getInitialization() {
        return this.initialization;
    }
}

