/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.dnd;

import java.util.Iterator;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.SemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.infra.hyperlink.commands.CreateHyperLinkPageCommand;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;

public class HyperlinkDropStrategy
extends TransactionalDropStrategy {
    public String getLabel() {
        return "Create hyperlinks";
    }

    public String getDescription() {
        return "Creates an hyperlink to Papyrus nested editor (e.g. Diagram, Table, ...) on a Diagram element";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return "org.eclipse.papyrus.infra.gmfdiag.dnd.CreateHyperlink";
    }

    @Deprecated
    public int getPriority() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if (!(request instanceof DropObjectsRequest)) return null;
        View view = this.getTargetView(targetEditPart);
        if (view == null) {
            return null;
        }
        final View mainView = SemanticElementHelper.findPrimaryView((EObject)view);
        if (mainView instanceof Diagram) {
            return null;
        }
        final DropObjectsRequest dropRequest = (DropObjectsRequest)request;
        try {
            Object droppedObject;
            final ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)mainView);
            IPageManager pageManager = ServiceUtils.getInstance().getIPageManager((Object)registry);
            Iterator iterator = dropRequest.getObjects().iterator();
            do {
                if (!iterator.hasNext()) {
                    return new Command(){

                        public void execute() {
                            try {
                                ILabelProvider labelProvider = ((LabelProviderService)registry.getService(LabelProviderService.class)).getLabelProvider();
                                TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)registry);
                                for (Object droppedObject : dropRequest.getObjects()) {
                                    String text = labelProvider.getText(droppedObject);
                                    CreateHyperLinkPageCommand command = new CreateHyperLinkPageCommand(domain, (EModelElement)mainView, text, text, (EObject)droppedObject, true);
                                    command.execute();
                                }
                            }
                            catch (ServiceException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    };
                }
                droppedObject = iterator.next();
                if (!(droppedObject instanceof EObject)) return null;
            } while (pageManager.allPages().contains(droppedObject));
            return null;
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }
}

