/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcoreUtils {
    private EcoreUtils() {
    }

    public static void replaceEObjectInstance(EObject original, EObject replacement) {
        Collection settings = EcoreUtil.UsageCrossReferencer.find((EObject)original, (ResourceSet)original.eResource().getResourceSet());
        HashSet<EStructuralFeature> referencingFeatures = new HashSet<EStructuralFeature>();
        for (EStructuralFeature.Setting setting : settings) {
            referencingFeatures.add(setting.getEStructuralFeature());
        }
        EcoreUtils.copyFeatures(original, replacement, referencingFeatures);
        for (EStructuralFeature.Setting setting : settings) {
            EStructuralFeature feature = setting.getEStructuralFeature();
            if (!feature.isChangeable() || feature.isDerived()) continue;
            EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)replacement);
            EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)original, (Object)replacement);
        }
        EcoreUtil.replace((EObject)original, (EObject)replacement);
    }

    private static void copyFeatures(EObject source, EObject target, Set<EStructuralFeature> referencingFeatures) {
        EList eAllStructuralFeatures = source.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : eAllStructuralFeatures) {
            EReference reference;
            if (referencingFeatures.contains(feature) || feature instanceof EReference && (reference = (EReference)feature).isContainer() || !feature.isChangeable() || feature.isDerived()) continue;
            if (feature.isMany()) {
                Object result = source.eGet(feature);
                if (!(result instanceof List)) continue;
                List list1 = (List)result;
                List list2 = (List)target.eGet(feature);
                list2.addAll(list1);
                continue;
            }
            Object value = source.eGet(feature);
            target.eSet(feature, value);
        }
    }

    public static <T> T getContaining(EObject element, Class<T> clazz) {
        EObject container = element;
        while (container != null) {
            if (clazz.isInstance(container)) {
                return (T)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    public static EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }
}

