/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestUtils {
    private RequestUtils() {
    }

    public static boolean isChangeBoundsRequestFor(Request request, EClass eClass) {
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            return RequestUtils.isGroupRequestFor((GroupRequest)changeBoundsRequest, eClass);
        }
        return false;
    }

    public static boolean isChangeBoundsRequestFor(Request request, Class<? extends EditPart> editPartClass) {
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            return RequestUtils.isGroupRequestFor((GroupRequest)changeBoundsRequest, editPartClass);
        }
        return false;
    }

    public static boolean isGroupRequestFor(GroupRequest groupRequest, EClass eClass) {
        List editParts = groupRequest.getEditParts();
        if (editParts == null) {
            return false;
        }
        for (EditPart editPart : editParts) {
            Object model = editPart.getModel();
            if (model instanceof View) {
                View view = (View)model;
                EObject element = view.getElement();
                if (eClass.isInstance((Object)element)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isGroupRequestFor(GroupRequest groupRequest, Class<? extends EditPart> editPartClass) {
        List editParts = groupRequest.getEditParts();
        for (EditPart editPart : editParts) {
            if (editPartClass.isInstance(editPart)) continue;
            return false;
        }
        return true;
    }
}

