/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.OperationForbiddenException;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.Constants;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.GeneralOrderingUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TimeElementUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLViewProvider;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StateInvariantUtils {
    private static final String STATE_INVARIANT_KEY = "org.eclipse.papyrus.uml.diagram.timing.StateInvariant";
    private static final String STATE_INVARIANT_STATE_DEFINITION_ID_KEY = "org.eclipse.papyrus.uml.diagram.timing.StateInvariantStateDefinitionId";

    private StateInvariantUtils() {
    }

    public static Node createStateInvariant(String stateDefinitionId, FullLifelineEditPartCN lifelineEditPart, int indexInFragments, int indexInCoveredBys, int indexInCompartment) {
        View timelineCompartmentView = (View)EditPartUtils.findFirstChildEditPartWithId((EditPart)lifelineEditPart, 8).getModel();
        View lifelineView = (View)lifelineEditPart.getModel();
        Lifeline lifeline = (Lifeline)lifelineView.getElement();
        StateInvariant newStateInvariant = UMLFactory.eINSTANCE.createStateInvariant();
        Constraint newConstraint = UMLFactory.eINSTANCE.createConstraint();
        newStateInvariant.setInvariant(newConstraint);
        OpaqueExpression newOpaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
        View stateDefinitionView = StateDefinitionUtils.getStateDefinitionViewWithId(stateDefinitionId, lifelineView);
        String stateDefinitionName = StateDefinitionUtils.getStateDefinitionName(stateDefinitionView);
        newConstraint.setSpecification((ValueSpecification)newOpaqueExpression);
        if (indexInFragments == -1) {
            lifeline.getInteraction().getFragments().add((Object)newStateInvariant);
        } else {
            lifeline.getInteraction().getFragments().add(indexInFragments, (Object)newStateInvariant);
        }
        if (indexInCoveredBys == -1) {
            lifeline.getCoveredBys().add((Object)newStateInvariant);
        } else {
            lifeline.getCoveredBys().add(indexInCoveredBys, (Object)newStateInvariant);
        }
        StateInvariantUtils.setStateInvariantId(newStateInvariant, stateDefinitionId);
        StateInvariantUtils.setInnerStateInvariantName(newStateInvariant, stateDefinitionName);
        UMLViewProvider umlViewProvider = new UMLViewProvider();
        Node stateInvariantNode = umlViewProvider.createStateInvariant_11((EObject)newStateInvariant, timelineCompartmentView, indexInCompartment, true, PreferencesHint.USE_DEFAULTS);
        return stateInvariantNode;
    }

    public static Node createCompactStateInvariant(View lifelineCompartmentView, int indexInFragments, int indexInCoveredBys, int indexInCompartment) {
        Lifeline lifeline = (Lifeline)lifelineCompartmentView.getElement();
        StateInvariant newStateInvariant = UMLFactory.eINSTANCE.createStateInvariant();
        Constraint newConstraint = UMLFactory.eINSTANCE.createConstraint();
        newStateInvariant.setInvariant(newConstraint);
        OpaqueExpression newOpaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
        newConstraint.setSpecification((ValueSpecification)newOpaqueExpression);
        if (indexInFragments == -1) {
            lifeline.getInteraction().getFragments().add((Object)newStateInvariant);
        } else {
            lifeline.getInteraction().getFragments().add(indexInFragments, (Object)newStateInvariant);
        }
        if (indexInCoveredBys == -1) {
            lifeline.getCoveredBys().add((Object)newStateInvariant);
        } else {
            lifeline.getCoveredBys().add(indexInCoveredBys, (Object)newStateInvariant);
        }
        UMLViewProvider umlViewProvider = new UMLViewProvider();
        Node stateInvariantNode = umlViewProvider.createStateInvariant_28((EObject)newStateInvariant, lifelineCompartmentView, indexInCompartment, true, PreferencesHint.USE_DEFAULTS);
        return stateInvariantNode;
    }

    public static void setInnerStateInvariantName(StateInvariant stateInvariant, String newName) {
        Constraint constraint = stateInvariant.getInvariant();
        Assert.isNotNull((Object)constraint, (String)"The StateInvariant must have a Constraint");
        constraint.setName("InState_" + newName);
        ValueSpecification specification = constraint.getSpecification();
        Assert.isNotNull((Object)specification, (String)"The Constraint must have a ValueSpecification");
        Assert.isLegal((boolean)(specification instanceof OpaqueExpression), (String)"The ValueSpecification must be an OpaqueExpression");
        OpaqueExpression opaqueExpression = (OpaqueExpression)specification;
        opaqueExpression.getBodies().clear();
        opaqueExpression.getBodies().add((Object)newName);
    }

    public static String getInnerStateInvariantName(StateInvariant stateInvariant) {
        Constraint constraint = stateInvariant.getInvariant();
        if (constraint == null) {
            return null;
        }
        ValueSpecification specification = constraint.getSpecification();
        if (specification == null || !(specification instanceof OpaqueExpression)) {
            return null;
        }
        OpaqueExpression opaqueExpression = (OpaqueExpression)specification;
        EList bodies = opaqueExpression.getBodies();
        if (bodies == null || bodies.size() < 1) {
            return null;
        }
        return (String)bodies.get(0);
    }

    public static void setStateInvariantId(StateInvariant stateInvariant, String id) {
        EAnnotation eAnnotation = StateInvariantUtils.getOrCreateStateInvariantEAnnotation(stateInvariant);
        eAnnotation.getDetails().put((Object)STATE_INVARIANT_STATE_DEFINITION_ID_KEY, (Object)id);
    }

    public static String getStateInvariantId(StateInvariant stateInvariant) {
        EAnnotation eAnnotation = stateInvariant.getEAnnotation(STATE_INVARIANT_KEY);
        if (eAnnotation != null) {
            return (String)eAnnotation.getDetails().get((Object)STATE_INVARIANT_STATE_DEFINITION_ID_KEY);
        }
        return null;
    }

    private static EAnnotation getOrCreateStateInvariantEAnnotation(StateInvariant stateInvariant) {
        EAnnotation eAnnotation = stateInvariant.getEAnnotation(STATE_INVARIANT_KEY);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(STATE_INVARIANT_KEY);
            stateInvariant.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    public static List<StateInvariant> findStateInvariantsWithId(String id, Interaction interaction) {
        ArrayList<StateInvariant> stateInvariants = new ArrayList<StateInvariant>();
        EList fragments = interaction.getFragments();
        for (InteractionFragment interactionFragment : fragments) {
            StateInvariant stateInvariant;
            String stateInvariantId;
            if (!(interactionFragment instanceof StateInvariant) || !id.equals(stateInvariantId = StateInvariantUtils.getStateInvariantId(stateInvariant = (StateInvariant)interactionFragment))) continue;
            stateInvariants.add(stateInvariant);
        }
        return stateInvariants;
    }

    public static Collection<EObject> getElementsToDelete(StateInvariant stateInvariant) throws OperationForbiddenException {
        HashSet<EObject> elementsToDestroy = new HashSet<EObject>();
        Set crossReferencingViews = CrossReferencerUtil.getCrossReferencingViews((EObject)stateInvariant, (String)"PapyrusUMLTimingDiagram");
        for (View view : crossReferencingViews) {
            elementsToDestroy.addAll(StateInvariantUtils.getElementsToRemove(view, false));
        }
        return elementsToDestroy;
    }

    public static Collection<View> getViewsToHide(View stateInvariantView) throws OperationForbiddenException {
        HashSet<View> viewsToHide = new HashSet<View>();
        Collection<EObject> elementsToRemove = StateInvariantUtils.getElementsToRemove(stateInvariantView, true);
        for (EObject eObject : elementsToRemove) {
            if (eObject instanceof View) {
                viewsToHide.add((View)eObject);
                continue;
            }
            throw new IllegalStateException("Only views should be returned");
        }
        return viewsToHide;
    }

    public static Collection<EObject> getElementsToRemove(View view, boolean hideOnly) throws OperationForbiddenException {
        HashSet<EObject> elementsToRemove = new HashSet<EObject>();
        boolean fullStateInvariant = view.getType().equals(Constants.fullStateInvariantId);
        boolean compactStateInvariant = view.getType().equals(Constants.compactStateInvariantId);
        if (fullStateInvariant || compactStateInvariant) {
            View interactionView = ViewUtils.findSuperViewWithId(view, 2);
            StateInvariant stateInvariant = (StateInvariant)view.getElement();
            elementsToRemove.addAll(StateInvariantUtils.getRelatedElementsToRemove((EObject)stateInvariant, hideOnly, interactionView));
            EObject eContainer = view.eContainer();
            if (eContainer instanceof Node) {
                Node node = (Node)eContainer;
                EList children = node.getChildren();
                int nStateInvariants = 0;
                for (View childView : children) {
                    if (!childView.getType().equals(Constants.fullStateInvariantId) && !childView.getType().equals(Constants.compactStateInvariantId)) continue;
                    ++nStateInvariants;
                }
                if (nStateInvariants <= 1) {
                    throw new OperationForbiddenException();
                }
                if (fullStateInvariant) {
                    elementsToRemove.addAll(StateInvariantUtils.getElementsToRemoveForFullStateInvariant(view, (EList<View>)children, hideOnly, interactionView));
                } else if (compactStateInvariant) {
                    elementsToRemove.addAll(StateInvariantUtils.getElementsToRemoveForCompactStateInvariant(view, (EList<View>)children, hideOnly, interactionView));
                }
            }
        }
        return elementsToRemove;
    }

    public static Collection<? extends EObject> getRelatedElementsToRemove(EObject stateInvariant, boolean hideOnly, View interactionView) {
        Assert.isLegal((boolean)(stateInvariant instanceof StateInvariant));
        HashSet<Object> elementsToRemove = new HashSet<Object>();
        elementsToRemove.addAll(TimeElementUtils.getTimeElementsToRemove(stateInvariant, hideOnly, interactionView));
        elementsToRemove.addAll(GeneralOrderingUtils.getReferencingGeneralOrderingsToRemove(stateInvariant, hideOnly, interactionView));
        return elementsToRemove;
    }

    private static Collection<EObject> getElementsToRemoveForFullStateInvariant(View stateInvariantView, EList<View> children, boolean hideOnly, View interactionView) {
        HashSet<EObject> elementsToRemove = new HashSet<EObject>();
        int childrenSize = children.size();
        int index = children.indexOf((Object)stateInvariantView);
        if (index == 0) {
            View following;
            if (index + 1 < childrenSize && OccurrenceSpecificationUtils.isOccurrenceSpecificationView(following = (View)children.get(index + 1))) {
                StateInvariantUtils.addElementToRemove(following, hideOnly, interactionView, elementsToRemove);
            }
            if (index + 2 < childrenSize && (following = (View)children.get(index + 2)).getType().equals(Constants.verticalLineId)) {
                elementsToRemove.add((EObject)following);
            }
        } else {
            View preceding;
            if (index >= 1) {
                preceding = (View)children.get(index - 1);
                if (preceding.getType().equals(Constants.verticalLineId)) {
                    elementsToRemove.add((EObject)preceding);
                }
                if (OccurrenceSpecificationUtils.isOccurrenceSpecificationView(preceding)) {
                    StateInvariantUtils.addElementToRemove(preceding, hideOnly, interactionView, elementsToRemove);
                }
            }
            if (index >= 2 && OccurrenceSpecificationUtils.isOccurrenceSpecificationView(preceding = (View)children.get(index - 2))) {
                StateInvariantUtils.addElementToRemove(preceding, hideOnly, interactionView, elementsToRemove);
            }
        }
        return elementsToRemove;
    }

    private static Collection<EObject> getElementsToRemoveForCompactStateInvariant(View stateInvariantView, EList<View> children, boolean hideOnly, View interactionView) {
        HashSet<EObject> elementsToRemove = new HashSet<EObject>();
        int index = children.indexOf((Object)stateInvariantView);
        if (index == 0) {
            int i = index + 1;
            while (i < children.size()) {
                View view = (View)children.get(i);
                if (OccurrenceSpecificationUtils.isOccurrenceSpecificationView(view)) {
                    StateInvariantUtils.addElementToRemove(view, hideOnly, interactionView, elementsToRemove);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            View preceding;
            if (index >= 1 && OccurrenceSpecificationUtils.isOccurrenceSpecificationView(preceding = (View)children.get(index - 1))) {
                StateInvariantUtils.addElementToRemove(preceding, hideOnly, interactionView, elementsToRemove);
            }
            int i = index + 1;
            while (i < children.size()) {
                View view;
                View following = null;
                if (i + 1 < children.size()) {
                    following = (View)children.get(i + 1);
                }
                if (OccurrenceSpecificationUtils.isOccurrenceSpecificationView(view = (View)children.get(i)) && (following == null || !StateInvariantUtils.isStateInvariantView(following))) {
                    StateInvariantUtils.addElementToRemove(view, hideOnly, interactionView, elementsToRemove);
                    ++i;
                    continue;
                }
                break;
            }
        }
        return elementsToRemove;
    }

    private static void addElementToRemove(View viewToRemove, boolean hideOnly, View interactionView, Set<EObject> elementsToRemove) {
        EObject element = viewToRemove.getElement();
        elementsToRemove.add((EObject)viewToRemove);
        if (!hideOnly) {
            elementsToRemove.add(element);
        }
        if (element instanceof StateInvariant) {
            elementsToRemove.addAll(StateInvariantUtils.getRelatedElementsToRemove(element, hideOnly, interactionView));
        } else if (element instanceof OccurrenceSpecification) {
            elementsToRemove.addAll(OccurrenceSpecificationUtils.getRelatedElementsToRemove(element, hideOnly, interactionView));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static boolean isStateInvariantView(View view) {
        int visualID = UMLVisualIDRegistry.getVisualID(view);
        return StateInvariantUtils.isStateInvariantEditPart(visualID);
    }

    public static boolean isStateInvariantEditPart(int visualID) {
        return visualID == 11 || visualID == 28;
    }
}

