/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLElementTypes {
    private static Map<IElementType, ENamedElement> elements;
    private static ImageRegistry imageRegistry;
    private static Set<IElementType> KNOWN_ELEMENT_TYPES;
    public static final IElementType Package_1;
    public static final IElementType Interaction_2;
    public static final IElementType Lifeline_19;
    public static final IElementType Lifeline_20;
    public static final IElementType StateInvariant_11;
    public static final IElementType StateInvariant_28;
    public static final IElementType OccurrenceSpecification_12;
    public static final IElementType MessageOccurrenceSpecification_13;
    public static final IElementType Node_9;
    public static final IElementType Node_39;
    public static final IElementType TimeConstraint_15;
    public static final IElementType TimeObservation_16;
    public static final IElementType DurationConstraint_18;
    public static final IElementType DurationObservation_17;
    public static final IElementType GeneralOrdering_67;
    public static final IElementType Node_24;
    public static final IElementType Node_25;
    public static final IElementType Node_26;
    public static final IElementType DestructionOccurrenceSpecification_27;
    public static final IElementType Lifeline_40;
    public static final IElementType Gate_69;
    public static final IElementType Message_3;
    public static final IElementType Message_4;
    public static final IElementType Message_41;
    public static final IElementType Message_44;
    public static final IElementType Message_47;
    public static final IElementType Message_50;
    public static final IElementType Message_53;

    static {
        Package_1 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Package_1");
        Interaction_2 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Interaction_2");
        Lifeline_19 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Lifeline_19");
        Lifeline_20 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Lifeline_20");
        StateInvariant_11 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.FullStateInvariant_11");
        StateInvariant_28 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.CompactStateInvariant_28");
        OccurrenceSpecification_12 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.OccurrenceSpecification_12");
        MessageOccurrenceSpecification_13 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.MessageOccurrenceSpecification_13");
        Node_9 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Node_9");
        Node_39 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Node_39");
        TimeConstraint_15 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.TimeConstraint_15");
        TimeObservation_16 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.TimeObservation_16");
        DurationConstraint_18 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.DurationConstraint_18");
        DurationObservation_17 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.DurationObservation_17");
        GeneralOrdering_67 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.GeneralOrdering_67");
        Node_24 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Node_24");
        Node_25 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Node_25");
        Node_26 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Node_26");
        DestructionOccurrenceSpecification_27 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.DestructionOccurrenceSpecification_27");
        Lifeline_40 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Lifeline_40");
        Gate_69 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.Gate_69");
        Message_3 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.MessageSync_3");
        Message_4 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.MessageAsync_4");
        Message_41 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.MessageReply_41");
        Message_44 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.MessageCreate_44");
        Message_47 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.MessageDelete_47");
        Message_50 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.MessageLost_50");
        Message_53 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.timing.MessageFound_53");
    }

    private UMLElementTypes() {
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static String getImageRegistryKey(ENamedElement element) {
        return element.getName();
    }

    private static ImageDescriptor getProvidedImageDescriptor(ENamedElement element) {
        EClass eClass;
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClass eContainingClass = feature.getEContainingClass();
            EClassifier eType = feature.getEType();
            if (eContainingClass != null && !eContainingClass.isAbstract()) {
                element = eContainingClass;
            } else if (eType instanceof EClass && !((EClass)eType).isAbstract()) {
                element = eType;
            }
        }
        if (element instanceof EClass && !(eClass = (EClass)element).isAbstract()) {
            return UMLDiagramEditorPlugin.getInstance().getItemImageDescriptor(eClass.getEPackage().getEFactoryInstance().create(eClass));
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ENamedElement element) {
        String key = UMLElementTypes.getImageRegistryKey(element);
        ImageDescriptor imageDescriptor = UMLElementTypes.getImageRegistry().getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = UMLElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            UMLElementTypes.getImageRegistry().put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(ENamedElement element) {
        String key = UMLElementTypes.getImageRegistryKey(element);
        Image image = UMLElementTypes.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = UMLElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            UMLElementTypes.getImageRegistry().put(key, imageDescriptor);
            image = UMLElementTypes.getImageRegistry().get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
        ENamedElement element = UMLElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return UMLElementTypes.getImageDescriptor(element);
    }

    public static Image getImage(IAdaptable hint) {
        ENamedElement element = UMLElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return UMLElementTypes.getImage(element);
    }

    public static ENamedElement getElement(IAdaptable hint) {
        Object type = hint.getAdapter(IElementType.class);
        if (elements == null) {
            elements = new IdentityHashMap<IElementType, ENamedElement>();
            elements.put(Package_1, (ENamedElement)UMLPackage.eINSTANCE.getPackage());
            elements.put(Interaction_2, (ENamedElement)UMLPackage.eINSTANCE.getInteraction());
            elements.put(Lifeline_19, (ENamedElement)UMLPackage.eINSTANCE.getLifeline());
            elements.put(Lifeline_20, (ENamedElement)UMLPackage.eINSTANCE.getLifeline());
            elements.put(StateInvariant_11, (ENamedElement)UMLPackage.eINSTANCE.getStateInvariant());
            elements.put(StateInvariant_28, (ENamedElement)UMLPackage.eINSTANCE.getStateInvariant());
            elements.put(OccurrenceSpecification_12, (ENamedElement)UMLPackage.eINSTANCE.getOccurrenceSpecification());
            elements.put(MessageOccurrenceSpecification_13, (ENamedElement)UMLPackage.eINSTANCE.getMessageOccurrenceSpecification());
            elements.put(TimeConstraint_15, (ENamedElement)UMLPackage.eINSTANCE.getTimeConstraint());
            elements.put(TimeObservation_16, (ENamedElement)UMLPackage.eINSTANCE.getTimeObservation());
            elements.put(DurationConstraint_18, (ENamedElement)UMLPackage.eINSTANCE.getDurationConstraint());
            elements.put(DurationObservation_17, (ENamedElement)UMLPackage.eINSTANCE.getDurationObservation());
            elements.put(GeneralOrdering_67, (ENamedElement)UMLPackage.eINSTANCE.getGeneralOrdering());
            elements.put(DestructionOccurrenceSpecification_27, (ENamedElement)UMLPackage.eINSTANCE.getDestructionOccurrenceSpecification());
            elements.put(Lifeline_40, (ENamedElement)UMLPackage.eINSTANCE.getLifeline());
            elements.put(Gate_69, (ENamedElement)UMLPackage.eINSTANCE.getGate());
            elements.put(Message_3, (ENamedElement)UMLPackage.eINSTANCE.getMessage());
            elements.put(Message_4, (ENamedElement)UMLPackage.eINSTANCE.getMessage());
            elements.put(Message_41, (ENamedElement)UMLPackage.eINSTANCE.getMessage());
            elements.put(Message_44, (ENamedElement)UMLPackage.eINSTANCE.getMessage());
            elements.put(Message_47, (ENamedElement)UMLPackage.eINSTANCE.getMessage());
            elements.put(Message_50, (ENamedElement)UMLPackage.eINSTANCE.getMessage());
            elements.put(Message_53, (ENamedElement)UMLPackage.eINSTANCE.getMessage());
        }
        return elements.get(type);
    }

    private static IElementType getElementType(String id) {
        return ElementTypeRegistry.getInstance().getType(id);
    }

    public static boolean isKnownElementType(IElementType elementType) {
        if (KNOWN_ELEMENT_TYPES == null) {
            KNOWN_ELEMENT_TYPES = new HashSet<IElementType>();
            KNOWN_ELEMENT_TYPES.add(Package_1);
            KNOWN_ELEMENT_TYPES.add(Interaction_2);
            KNOWN_ELEMENT_TYPES.add(Lifeline_19);
            KNOWN_ELEMENT_TYPES.add(Lifeline_20);
            KNOWN_ELEMENT_TYPES.add(StateInvariant_11);
            KNOWN_ELEMENT_TYPES.add(StateInvariant_28);
            KNOWN_ELEMENT_TYPES.add(OccurrenceSpecification_12);
            KNOWN_ELEMENT_TYPES.add(MessageOccurrenceSpecification_13);
            KNOWN_ELEMENT_TYPES.add(Node_9);
            KNOWN_ELEMENT_TYPES.add(Node_39);
            KNOWN_ELEMENT_TYPES.add(TimeConstraint_15);
            KNOWN_ELEMENT_TYPES.add(TimeObservation_16);
            KNOWN_ELEMENT_TYPES.add(DurationConstraint_18);
            KNOWN_ELEMENT_TYPES.add(DurationObservation_17);
            KNOWN_ELEMENT_TYPES.add(GeneralOrdering_67);
            KNOWN_ELEMENT_TYPES.add(Node_24);
            KNOWN_ELEMENT_TYPES.add(Node_25);
            KNOWN_ELEMENT_TYPES.add(Node_26);
            KNOWN_ELEMENT_TYPES.add(DestructionOccurrenceSpecification_27);
            KNOWN_ELEMENT_TYPES.add(Lifeline_40);
            KNOWN_ELEMENT_TYPES.add(Gate_69);
            KNOWN_ELEMENT_TYPES.add(Message_3);
            KNOWN_ELEMENT_TYPES.add(Message_4);
            KNOWN_ELEMENT_TYPES.add(Message_41);
            KNOWN_ELEMENT_TYPES.add(Message_44);
            KNOWN_ELEMENT_TYPES.add(Message_47);
            KNOWN_ELEMENT_TYPES.add(Message_50);
            KNOWN_ELEMENT_TYPES.add(Message_53);
        }
        return KNOWN_ELEMENT_TYPES.contains(elementType);
    }

    public static IElementType getElementType(int visualID) {
        switch (visualID) {
            case 1: {
                return Package_1;
            }
            case 2: {
                return Interaction_2;
            }
            case 19: {
                return Lifeline_19;
            }
            case 20: {
                return Lifeline_20;
            }
            case 11: {
                return StateInvariant_11;
            }
            case 28: {
                return StateInvariant_28;
            }
            case 12: {
                return OccurrenceSpecification_12;
            }
            case 13: {
                return MessageOccurrenceSpecification_13;
            }
            case 9: {
                return Node_9;
            }
            case 39: {
                return Node_39;
            }
            case 15: {
                return TimeConstraint_15;
            }
            case 16: {
                return TimeObservation_16;
            }
            case 18: {
                return DurationConstraint_18;
            }
            case 17: {
                return DurationObservation_17;
            }
            case 67: {
                return GeneralOrdering_67;
            }
            case 24: {
                return Node_24;
            }
            case 25: {
                return Node_25;
            }
            case 26: {
                return Node_26;
            }
            case 27: {
                return DestructionOccurrenceSpecification_27;
            }
            case 40: {
                return Lifeline_40;
            }
            case 69: {
                return Gate_69;
            }
            case 3: {
                return Message_3;
            }
            case 4: {
                return Message_4;
            }
            case 41: {
                return Message_41;
            }
            case 44: {
                return Message_44;
            }
            case 47: {
                return Message_47;
            }
            case 50: {
                return Message_50;
            }
            case 53: {
                return Message_53;
            }
        }
        return null;
    }
}

