/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpressionFactory;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;

public class DefaultConstructorFacade
extends SignatureFacade {
    private Class classToBeConstructed;
    private DataType datatypeToBeConstructed;

    public DefaultConstructorFacade(Class c) {
        super((EObject)c);
        this.classToBeConstructed = c;
        this.setReturnType(TypeExpressionFactory.eInstance.createTypeExpression((EObject)c));
    }

    public DefaultConstructorFacade(DataType d) {
        super((EObject)d);
        this.datatypeToBeConstructed = d;
        for (Property p : d.getAllAttributes()) {
            TypeExpression typeOfArgument = TypeExpressionFactory.eInstance.createTypeExpression((EObject)p);
            this.parameters.add(TypeExpressionFactory.eInstance.createTypeExpression((EObject)p));
            this.parametersMap.put(p.getName(), typeOfArgument);
        }
        this.setReturnType(TypeExpressionFactory.eInstance.createTypeExpression((EObject)d));
    }

    public String getName() {
        return this.classToBeConstructed.getName();
    }

    public boolean hasReturnType() {
        return true;
    }

    public String getLabel() {
        String label = this.classToBeConstructed != null ? this.classToBeConstructed.getName() : this.datatypeToBeConstructed.getName();
        label = String.valueOf(label) + "(";
        boolean first = true;
        for (TypeExpression t : this.parameters) {
            if (first) {
                first = false;
            } else {
                label = String.valueOf(label) + ", ";
            }
            label = String.valueOf(label) + t.getLabel();
        }
        label = String.valueOf(label) + ") : " + this.getReturnType().getLabel();
        return label;
    }

    public boolean isAConstructor() {
        return true;
    }

    public boolean isADestructor() {
        return false;
    }
}

