/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.alf.alf.LocalNameDeclarationStatement;
import org.eclipse.papyrus.uml.alf.alf.LoopVariableDefinition;
import org.eclipse.papyrus.uml.alf.validation.typing.MultiplicityFacade;
import org.eclipse.uml2.uml.MultiplicityElement;

public class MultiplicityFacadeFactory {
    public static MultiplicityFacadeFactory eInstance = new MultiplicityFacadeFactory();

    public MultiplicityFacade createMultiplicityFacade(int lowerBound, int upperBound, boolean isUnique, boolean isOrdered) {
        MultiplicityFacade result = new MultiplicityFacade();
        result.setLowerBound(lowerBound);
        result.setUpperBound(upperBound);
        result.setIsUnique(isUnique);
        result.setIsOrdered(isOrdered);
        return result;
    }

    public MultiplicityFacade createMultiplicityFacade(int upperBound) {
        if (upperBound == -1) {
            return this.createMultiplicityFacade(0, upperBound, false, true);
        }
        return this.createMultiplicityFacade(upperBound, upperBound, true, false);
    }

    public MultiplicityFacade createMultiplicityFacade() {
        return this.createMultiplicityFacade(1, 1, true, false);
    }

    public MultiplicityFacade createMultiplicityFacade(EObject multiplicityElement) {
        if (multiplicityElement instanceof MultiplicityElement) {
            MultiplicityElement m = (MultiplicityElement)multiplicityElement;
            return this.createMultiplicityFacade(m.getLower(), m.getUpper(), m.isUnique(), m.isOrdered());
        }
        if (multiplicityElement instanceof LocalNameDeclarationStatement) {
            LocalNameDeclarationStatement statement = (LocalNameDeclarationStatement)multiplicityElement;
            int lower = statement.isMultiplicityIndicator() ? 0 : 1;
            int upper = statement.isMultiplicityIndicator() ? -1 : 1;
            boolean isUnique = !statement.isMultiplicityIndicator();
            boolean isOrdered = statement.isMultiplicityIndicator();
            return this.createMultiplicityFacade(lower, upper, isUnique, isOrdered);
        }
        boolean cfr_ignored_0 = multiplicityElement instanceof LoopVariableDefinition;
        return this.createMultiplicityFacade();
    }
}

