/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeToFlatContentProvider
extends AbstractStaticContentProvider {
    private ITreeContentProvider contentProvider;
    private StructuredViewer viewer;

    public TreeToFlatContentProvider(ITreeContentProvider provider) {
        if (!(provider instanceof IStaticContentProvider)) {
            throw new IllegalArgumentException();
        }
        this.contentProvider = provider;
    }

    @Override
    public void dispose() {
        this.contentProvider.dispose();
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
        }
        this.contentProvider.inputChanged(viewer, oldInput, newInput);
    }

    @Override
    public Object[] getElements() {
        return this.getElementsList().toArray();
    }

    protected Object getValue(Object value) {
        if (this.contentProvider instanceof IAdaptableContentProvider) {
            return ((IAdaptableContentProvider)this.contentProvider).getAdaptedValue(value);
        }
        return value;
    }

    protected boolean exploreBranch(Object parentElement, Object element) {
        if (this.viewer == null) {
            return true;
        }
        ViewerFilter[] viewerFilterArray = this.viewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (!filter.select((Viewer)this.viewer, parentElement, element)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected Collection<Object> getElementsList() {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        HashSet<Object> browsedElements = new HashSet<Object>();
        Object[] objectArray = ((IStaticContentProvider)this.contentProvider).getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            if (this.exploreBranch(null, root)) {
                result.add(root);
                this.getElementsList(root, result, browsedElements);
            }
            ++n2;
        }
        return result;
    }

    protected void getElementsList(Object parent, Collection<Object> result, Set<Object> browsedElements) {
        Object[] objectArray = this.contentProvider.getChildren(parent);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            Object childValue = this.getValue(child);
            if (!result.contains(childValue)) {
                result.add(childValue);
                if (this.exploreBranch(parent, child)) {
                    this.getElementsList(child, result, browsedElements);
                }
            }
            ++n2;
        }
    }
}

