/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.selectors;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.strategy.StrategyBasedContentProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSelector
implements IElementSelector {
    protected TreeViewer treeViewer;
    protected EncapsulatedContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected boolean unique;
    protected boolean multiSelection;
    protected final List<ICommitListener> commitListeners;
    private Set<IElementSelectionListener> elementSelectionListeners = new HashSet<IElementSelectionListener>();
    protected Set<Object> selectedElements = new HashSet<Object>();

    public ReferenceSelector(boolean unique) {
        this.unique = unique;
        this.multiSelection = true;
        this.commitListeners = new LinkedList<ICommitListener>();
    }

    public ReferenceSelector() {
        this(false);
    }

    @Override
    public Object[] getSelectedElements() {
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] containerElementsToMove = this.getElementsToMove(((IStructuredSelection)selection).toArray());
            Object[] semanticElementsToMove = this.getSemanticElements(containerElementsToMove);
            this.addSelectedElements(semanticElementsToMove);
            return semanticElementsToMove;
        }
        return new Object[0];
    }

    private Object[] getSemanticElements(Object[] containerElements) {
        Object[] semanticElements = new Object[containerElements.length];
        int i = 0;
        Object[] objectArray = containerElements;
        int n = containerElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object containerElement = objectArray[n2];
            semanticElements[i++] = this.contentProvider.getAdaptedValue(containerElement);
            ++n2;
        }
        return semanticElements;
    }

    protected Object[] getElementsToMove(Object[] selection) {
        LinkedList<Object> elementsToMove = new LinkedList<Object>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.contentProvider.isValidValue(element)) {
                elementsToMove.add(element);
            }
            ++n2;
        }
        this.notifyCommitListeners();
        return elementsToMove.toArray();
    }

    private void addSelectedElements(Object[] semanticElements) {
        if (semanticElements.length > 0) {
            this.selectedElements.addAll(Arrays.asList(semanticElements));
            this.refresh();
        }
    }

    @Override
    public Object[] getAllElements() {
        if (this.contentProvider == null) {
            return new Object[0];
        }
        LinkedList<Object> visibleElements = new LinkedList<Object>();
        TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem rootItem = treeItemArray[n2];
            visibleElements.add(this.getElement(rootItem));
            if (rootItem.getExpanded()) {
                this.fillVisibleElements(rootItem, visibleElements);
            }
            ++n2;
        }
        Object[] containerElementsToMove = this.getElementsToMove(visibleElements.toArray());
        Object[] semanticElementsToMove = this.getSemanticElements(containerElementsToMove);
        this.addSelectedElements(semanticElementsToMove);
        return semanticElementsToMove;
    }

    private void fillVisibleElements(TreeItem item, Collection<Object> visibleElements) {
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            visibleElements.add(this.getElement(childItem));
            if (childItem.getExpanded()) {
                this.fillVisibleElements(childItem, visibleElements);
            }
            ++n2;
        }
    }

    private Object getElement(TreeItem item) {
        return item.getData();
    }

    @Override
    public void setSelectedElements(Object[] semanticElements) {
        this.selectedElements.clear();
        this.selectedElements.addAll(Arrays.asList(semanticElements));
        this.refresh();
    }

    @Override
    public void newObjectCreated(Object newObject) {
        this.contentProvider.addTemporaryElement(newObject);
        this.refresh();
    }

    @Override
    public void clearTemporaryElements() {
        this.contentProvider.clearTemporaryElements();
    }

    public void refresh() {
        ((SelectionFilteredBrowseStrategy)this.contentProvider.getBrowseStrategy()).refresh();
        this.treeViewer.refresh();
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        if (this.treeViewer != null) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
    }

    public void setContentProvider(IStaticContentProvider staticContentProvider) {
        EncapsulatedContentProvider provider = new EncapsulatedContentProvider(staticContentProvider);
        SelectionFilteredBrowseStrategy filteredBrowseStrategy = new SelectionFilteredBrowseStrategy(provider);
        ProviderBasedBrowseStrategy revealBrowseStrategy = new ProviderBasedBrowseStrategy(provider);
        this.contentProvider = new StrategyBasedContentProvider(filteredBrowseStrategy, revealBrowseStrategy);
        if (this.treeViewer != null) {
            this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
            this.treeViewer.setInput((Object)"");
        }
        if (this.contentProvider instanceof ICommitListener) {
            this.commitListeners.add(this.contentProvider);
        }
    }

    @Override
    public void createControls(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, true));
        this.treeViewer = new TreeViewer(content, 2050);
        this.treeViewer.setFilters(new ViewerFilter[]{new PatternFilter()});
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 300;
        data.minimumWidth = 300;
        this.treeViewer.getTree().setLayoutData((Object)data);
        if (this.labelProvider != null) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        if (this.contentProvider != null) {
            this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
            this.treeViewer.setInput((Object)"");
        }
        if (this.contentProvider instanceof IGraphicalContentProvider) {
            EncapsulatedContentProvider graphicalContentProvider = this.contentProvider;
            Composite beforeTreeComposite = new Composite(content, 0);
            beforeTreeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            FillLayout layout = new FillLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            beforeTreeComposite.setLayout((Layout)layout);
            graphicalContentProvider.createBefore(beforeTreeComposite);
            beforeTreeComposite.moveAbove((Control)this.treeViewer.getTree());
            Composite afterTreeComposite = new Composite(content, 0);
            layout = new FillLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            afterTreeComposite.setLayout((Layout)layout);
            afterTreeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            graphicalContentProvider.createAfter(afterTreeComposite);
        }
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object[] selectedElements;
                if (!ReferenceSelector.this.elementSelectionListeners.isEmpty() && (selectedElements = ReferenceSelector.this.getSelectedElements()).length > 0) {
                    ReferenceSelector.this.notifyCommitListeners();
                    for (IElementSelectionListener listener : ReferenceSelector.this.elementSelectionListeners) {
                        listener.addElements(selectedElements);
                    }
                }
            }
        });
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    @Override
    public void addElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.add(listener);
    }

    @Override
    public void removeElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.remove(listener);
    }

    protected void notifyCommitListeners() {
        for (ICommitListener commitListener : this.commitListeners) {
            commitListener.commit(null);
        }
    }

    private class SelectionFilteredBrowseStrategy
    extends ProviderBasedBrowseStrategy {
        public SelectionFilteredBrowseStrategy(ITreeContentProvider provider) {
            super(provider);
        }

        public boolean isValidValue(Object element) {
            if (!ReferenceSelector.this.unique) {
                return super.isValidValue(element);
            }
            if (!super.isValidValue(element)) {
                return false;
            }
            return !ReferenceSelector.this.selectedElements.contains(this.getAdaptedValue(element));
        }

        public void refresh() {
            if (ReferenceSelector.this.unique) {
                this.clearCache();
            }
        }
    }
}

