/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.strategy;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceRevealStrategy
extends ProviderBasedBrowseStrategy {
    public WorkspaceRevealStrategy(ITreeContentProvider provider) {
        super(provider);
    }

    public WorkspaceRevealStrategy() {
    }

    @Override
    public void revealSemanticElement(List<?> elementsToReveal) {
        if (this.viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)this.viewer;
            TreePath[] paths = new TreePath[elementsToReveal.size()];
            int i = 0;
            List<Object> roots = Arrays.asList(this.getElements());
            for (Object elementToReveal : elementsToReveal) {
                LinkedList<IResource> segments = new LinkedList<IResource>();
                if (elementToReveal instanceof IResource) {
                    IResource currentElement = (IResource)elementToReveal;
                    segments.add(currentElement);
                    currentElement = currentElement.getParent();
                    while (currentElement != null) {
                        segments.addFirst(currentElement);
                        if (roots.contains(currentElement)) break;
                        currentElement = currentElement.getParent();
                    }
                }
                paths[i++] = new TreePath(segments.toArray());
            }
            TreeSelection selection = new TreeSelection(paths);
            treeViewer.setSelection((ISelection)selection, true);
        } else {
            super.revealSemanticElement(elementsToReveal);
        }
    }
}

