/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPLabel
extends PlatformObject
implements ILabel,
ICPPInternalBinding {
    private IASTName statement;

    public CPPLabel(IASTName statement) {
        this.statement = statement;
        statement.setBinding(this);
    }

    @Override
    public IASTNode[] getDeclarations() {
        return null;
    }

    @Override
    public IASTNode getDefinition() {
        return this.statement;
    }

    @Override
    public IASTLabelStatement getLabelStatement() {
        if (this.statement instanceof IASTLabelStatement) {
            return (IASTLabelStatement)((Object)this.statement);
        }
        return null;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        return this.statement.getSimpleID();
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.statement);
    }

    public IASTNode getPhysicalNode() {
        return this.statement;
    }

    public void setLabelStatement(IASTName labelStatement) {
        this.statement = labelStatement;
    }

    @Override
    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return new char[][]{this.getNameCharArray()};
    }

    @Override
    public boolean isGloballyQualified() {
        return false;
    }

    @Override
    public void addDefinition(IASTNode node) {
    }

    @Override
    public void addDeclaration(IASTNode node) {
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        return CPPVisitor.findEnclosingFunction(this.statement);
    }

    public String toString() {
        return this.getName();
    }
}

