/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.importsources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.importsources.AbstractPackageImportSource;
import org.eclipse.papyrus.uml.tools.importsources.IPackageImportSource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositePackageImportSource
extends AbstractPackageImportSource {
    private static final Object[] NONE = new Object[0];
    private final Map<Object, Wrapper> wrappers = new HashMap<Object, Wrapper>();
    private List<IPackageImportSource> delegates = new ArrayList<IPackageImportSource>(3);
    private Map<String, String> extensionFilters;

    public CompositePackageImportSource(Collection<? extends IPackageImportSource> sources) {
        this.delegates.addAll(sources);
    }

    @Override
    public boolean canImportInto(Collection<?> selection) {
        boolean result = false;
        for (IPackageImportSource next : this.delegates) {
            result = next.canImportInto(selection);
            if (result) break;
        }
        return result;
    }

    @Override
    public void initialize(Collection<?> selection) {
        for (IPackageImportSource next : this.delegates) {
            try {
                next.initialize(selection);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in package import source initialization.", (Throwable)e);
            }
        }
    }

    @Override
    protected IStaticContentProvider createModelHierarchyContentProvider(Map<String, String> extensionFilters) {
        this.extensionFilters = extensionFilters;
        return new WrapperContentProvider();
    }

    @Override
    protected ILabelProvider createModelHierarchyLabelProvider() {
        return new WrapperLabelProvider();
    }

    @Override
    public List<Package> getPackages(ResourceSet resourceSet, Object model) throws CoreException {
        return this.getDelegate(model).getPackages(resourceSet, CompositePackageImportSource.unwrap(model));
    }

    IPackageImportSource getDelegate(Object element) {
        return ((Wrapper)element).getOwner();
    }

    ITreeContentProvider getTreeContentProvider(Object element) {
        IStaticContentProvider result = this.getDelegate(element).getModelHierarchyContentProvider(this.extensionFilters);
        return result instanceof ITreeContentProvider ? (ITreeContentProvider)result : null;
    }

    @Override
    public void dispose() {
        this.wrappers.clear();
        for (IPackageImportSource next : this.delegates) {
            try {
                next.dispose();
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in package import source disposal.", (Throwable)e);
            }
        }
        this.delegates.clear();
        super.dispose();
    }

    Object[] wrap(Collection<? extends IPackageImportSource> sources) {
        ArrayList<Wrapper> result = new ArrayList<Wrapper>(sources.size());
        for (IPackageImportSource iPackageImportSource : sources) {
            result.add(new Wrapper(iPackageImportSource, iPackageImportSource));
        }
        return result.toArray();
    }

    Object wrap(Object element, IPackageImportSource owner) {
        Object result = element;
        if (element != null && (result = this.wrappers.get(element)) == null) {
            Wrapper wrapper = new Wrapper(element, owner);
            this.wrappers.put(element, wrapper);
            result = wrapper;
        }
        return result;
    }

    Object[] wrap(Object[] elements, IPackageImportSource owner) {
        Object[] result;
        if (elements.length == 0) {
            result = NONE;
        } else {
            result = new Object[elements.length];
            int i = 0;
            while (i < elements.length) {
                result[i] = this.wrap(elements[i], owner);
                ++i;
            }
        }
        return result;
    }

    static Object unwrap(Object element) {
        return element instanceof Wrapper ? ((Wrapper)element).getElement() : element;
    }

    private static class Wrapper {
        private final Object element;
        private final IPackageImportSource owner;

        Wrapper(Object element, IPackageImportSource owner) {
            this.element = element;
            this.owner = owner;
        }

        Object getElement() {
            return this.element;
        }

        IPackageImportSource getOwner() {
            return this.owner;
        }
    }

    private final class WrapperContentProvider
    extends StaticContentProvider
    implements ITreeContentProvider {
        private Object input;

        WrapperContentProvider() {
            super(CompositePackageImportSource.this.wrap(CompositePackageImportSource.this.delegates));
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
            this.input = newInput;
            for (IPackageImportSource next : CompositePackageImportSource.this.delegates) {
                next.getModelHierarchyContentProvider(CompositePackageImportSource.this.extensionFilters).inputChanged(viewer, oldInput, newInput);
            }
        }

        public Object getParent(Object element) {
            ITreeContentProvider provider = CompositePackageImportSource.this.getTreeContentProvider(element);
            return provider == null ? null : CompositePackageImportSource.this.wrap(provider.getParent(CompositePackageImportSource.unwrap(element)), CompositePackageImportSource.this.getDelegate(element));
        }

        public boolean hasChildren(Object element) {
            Object realElement = CompositePackageImportSource.unwrap(element);
            if (!(realElement instanceof IPackageImportSource)) {
                ITreeContentProvider provider = CompositePackageImportSource.this.getTreeContentProvider(element);
                return provider == null ? false : provider.hasChildren(realElement);
            }
            boolean result = this.getChildren(element).length > 0;
            return result;
        }

        public Object[] getChildren(Object parentElement) {
            Object realParent = CompositePackageImportSource.unwrap(parentElement);
            if (!(realParent instanceof IPackageImportSource)) {
                ITreeContentProvider provider = CompositePackageImportSource.this.getTreeContentProvider(parentElement);
                return provider == null ? NONE : CompositePackageImportSource.this.wrap(provider.getChildren(realParent), CompositePackageImportSource.this.getDelegate(parentElement));
            }
            IPackageImportSource source = (IPackageImportSource)realParent;
            Object[] result = CompositePackageImportSource.this.wrap(source.getModelHierarchyContentProvider(CompositePackageImportSource.this.extensionFilters).getElements(this.input), source);
            return result;
        }
    }

    private final class WrapperLabelProvider
    implements ILabelProvider {
        private WrapperLabelProvider() {
        }

        public Image getImage(Object element) {
            return CompositePackageImportSource.this.getDelegate(element).getModelHierarchyLabelProvider().getImage(CompositePackageImportSource.unwrap(element));
        }

        public String getText(Object element) {
            return CompositePackageImportSource.this.getDelegate(element).getModelHierarchyLabelProvider().getText(CompositePackageImportSource.unwrap(element));
        }

        public boolean isLabelProperty(Object element, String property) {
            return CompositePackageImportSource.this.getDelegate(element).getModelHierarchyLabelProvider().isLabelProperty(CompositePackageImportSource.unwrap(element), property);
        }

        public void addListener(ILabelProviderListener listener) {
            for (IPackageImportSource next : CompositePackageImportSource.this.delegates) {
                next.getModelHierarchyLabelProvider().addListener(listener);
            }
        }

        public void removeListener(ILabelProviderListener listener) {
            for (IPackageImportSource next : CompositePackageImportSource.this.delegates) {
                next.getModelHierarchyLabelProvider().removeListener(listener);
            }
        }

        public void dispose() {
        }
    }
}

