/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.DataTypeUtil;
import org.eclipse.swt.graphics.Image;

public class GenericDataTypeLabelProvider
extends EMFLabelProvider
implements IFilteredLabelProvider {
    public boolean accept(Object element) {
        if (element instanceof Collection) {
            for (Object item : (Collection)element) {
                if (this.accept(item)) continue;
                return false;
            }
            return !((Collection)element).isEmpty();
        }
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject == null) {
            return false;
        }
        EClass definition = eObject.eClass();
        if (definition == null) {
            return false;
        }
        return DataTypeUtil.isDataTypeDefinition((EClass)definition);
    }

    public String getText(Object element) {
        EClass dataTypeDefinition;
        if (element instanceof Collection && !((Collection)element).isEmpty()) {
            HashSet<EClass> allEClasses = new HashSet<EClass>();
            for (Object item : (Collection)element) {
                EObject eObject = EMFHelper.getEObject(item);
                if (eObject == null) continue;
                allEClasses.add(eObject.eClass());
            }
            if (allEClasses.size() == 1) {
                return "Multiple " + ((EClass)allEClasses.iterator().next()).getName() + ": " + ((Collection)element).size();
            }
            return "Multiple DataTypeInstances: " + ((Collection)element).size();
        }
        EObject dataTypeInstance = EMFHelper.getEObject((Object)element);
        if (dataTypeInstance != null && (dataTypeDefinition = dataTypeInstance.eClass()) != null) {
            return dataTypeDefinition.getName();
        }
        return "Generic DataTypeInstance";
    }

    public Image getImage(Object element) {
        return null;
    }
}

