/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.osgi.util.NLS;

public class RepositoryQueryWizard
extends Wizard {
    private final TaskRepository repository;

    public RepositoryQueryWizard(TaskRepository repository) {
        Assert.isNotNull((Object)repository);
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.RepositoryQueryWizard_Edit_Repository_Query);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof AbstractRepositoryQueryPage) {
            return currentPage.isPageComplete();
        }
        return false;
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (!(currentPage instanceof AbstractRepositoryQueryPage)) {
            throw new AssertionError((Object)NLS.bind((String)"Current wizard page ''{0}'' does not extends AbstractRepositoryQueryPage", currentPage.getClass()));
        }
        AbstractRepositoryQueryPage page = (AbstractRepositoryQueryPage)currentPage;
        IRepositoryQuery query = page.getQuery();
        if (query != null) {
            String oldSummary = query.getSummary();
            page.applyTo(query);
            if (query instanceof RepositoryQuery) {
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)((RepositoryQuery)query));
            }
            if (oldSummary == null || !oldSummary.equals(query.getSummary())) {
                TasksUiPlugin.getTaskList().notifyElementsChanged(null);
            }
        } else {
            query = page.createQuery();
            TasksUiInternal.getTaskList().addQuery((RepositoryQuery)query);
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.getTaskRepository().getConnectorKind());
        TasksUiInternal.synchronizeQuery(connector, (RepositoryQuery)query, null, true);
        return true;
    }

    public TaskRepository getTaskRepository() {
        return this.repository;
    }
}

