/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.pivot2cs;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.DetailCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CSConversion;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.EssentialOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpSpecificationCS;
import org.eclipse.ocl.examples.xtext.essentialocl.pivot2cs.EssentialOCLDeclarationVisitor;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreCSTPackage;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreConstraintCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.SysMLCS;

public class OCLinEcoreDeclarationVisitor
extends EssentialOCLDeclarationVisitor {
    public OCLinEcoreDeclarationVisitor(@NonNull Pivot2CSConversion context) {
        super(context);
    }

    public ElementCS visitAnnotation(@NonNull Annotation object) {
        if ("http://www.omg.org/spec/SysML".equals(object.getName())) {
            SysMLCS csElement = (SysMLCS)((Pivot2CSConversion)this.context).refreshElement(SysMLCS.class, OCLinEcoreCSTPackage.Literals.SYS_MLCS, (Element)object);
            ((Pivot2CSConversion)this.context).refreshList((List)csElement.getOwnedDetail(), ((Pivot2CSConversion)this.context).visitDeclarations(DetailCS.class, object.getOwnedDetail(), null));
            return csElement;
        }
        return super.visitAnnotation(object);
    }

    public ElementCS visitConstraint(@NonNull Constraint object) {
        OCLinEcoreConstraintCS csElement = (OCLinEcoreConstraintCS)((Pivot2CSConversion)this.context).refreshNamedElement(OCLinEcoreConstraintCS.class, OCLinEcoreCSTPackage.Literals.OC_LIN_ECORE_CONSTRAINT_CS, (NamedElement)object);
        csElement.setCallable(object.isCallable());
        if (object.eContainmentFeature() == PivotPackage.Literals.OPERATION__POSTCONDITION) {
            csElement.setStereotype("postcondition");
        } else if (object.eContainmentFeature() == PivotPackage.Literals.OPERATION__PRECONDITION) {
            csElement.setStereotype("precondition");
        } else {
            csElement.setStereotype("invariant");
        }
        OpaqueExpression specification = object.getSpecification();
        if (specification != null) {
            csElement.setSpecification((SpecificationCS)((Pivot2CSConversion)this.context).visitDeclaration(SpecificationCS.class, (EObject)specification));
            String message = PivotUtil.getMessage((OpaqueExpression)specification);
            if (message != null && message.length() > 0) {
                int lastNewLine;
                int lastComment = message.lastIndexOf("--");
                if (lastComment >= 0 && (lastNewLine = message.lastIndexOf("\n")) < lastComment) {
                    message = String.valueOf(message) + "\n";
                }
                ExpSpecificationCS csMessageElement = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSTPackage.Literals.EXP_SPECIFICATION_CS, (Element)specification);
                csMessageElement.setExprString(message);
                csElement.setMessageSpecification((SpecificationCS)csMessageElement);
            }
        }
        return csElement;
    }

    public ElementCS visitExpressionInOCL(@NonNull ExpressionInOCL object) {
        ExpSpecificationCS csElement = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSTPackage.Literals.EXP_SPECIFICATION_CS, (Element)object);
        OCLExpression bodyExpression = object.getBodyExpression();
        if (bodyExpression != null) {
            String body = PrettyPrinter.print((Element)bodyExpression);
            csElement.setExprString(body);
        }
        return csElement;
    }

    public ElementCS visitOpaqueExpression(@NonNull OpaqueExpression object) {
        String body = PivotUtil.getBody((OpaqueExpression)object);
        if (body == null) {
            return null;
        }
        ExpSpecificationCS csElement = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSTPackage.Literals.EXP_SPECIFICATION_CS, (Element)object);
        csElement.setExprString(body);
        return csElement;
    }
}

