/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.utils.TextChangeListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NamespaceSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private Text namespaceTxt;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.namespaceTxt = this.getWidgetFactory().createText(composite, "");
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.namespaceTxt, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.namespaceTxt.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        TextChangeListener listener = new TextChangeListener(){

            public void textChanged(Control control) {
                NamespaceSection.this.handleTextModified();
            }
        };
        listener.startListeningTo((Control)this.namespaceTxt);
        listener.startListeningForEnter((Control)this.namespaceTxt);
    }

    protected void handleTextModified() {
        if (!this.isRefreshing) {
            final String newNamespace = this.namespaceTxt.getText();
            EditingDomain editingDomain = this.getEditingDomain();
            if (this.getEObjectList().size() == 1) {
                String oldNamespace = ExtendedMetaData.INSTANCE.getNamespace((EStructuralFeature)this.getEObject());
                if (oldNamespace == null || !oldNamespace.equals(newNamespace)) {
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)NamespaceSection.this.getEObject(), newNamespace);
                        }
                    });
                }
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (final EObject nextObject : this.getEObjectList()) {
                    String oldNamespace = ExtendedMetaData.INSTANCE.getNamespace((EStructuralFeature)nextObject);
                    if (oldNamespace == null || oldNamespace.equals(newNamespace)) continue;
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)nextObject, newNamespace);
                        }
                    });
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        String txt = ExtendedMetaData.INSTANCE.getNamespace((EStructuralFeature)this.getEObject());
        if (txt == null) {
            txt = "";
        }
        this.namespaceTxt.setText(txt);
        this.isRefreshing = false;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.NamespaceSection_Namespace;
    }
}

