/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonSpecification;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonSpecificationFactory;
import org.eclipse.emf.diffmerge.ui.specification.IScopeSpecification;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonSetup
implements IPropertyChangeNotifier {
    public static final String PROPERTY_ROLES = "ComparisonSetup.Property.Roles";
    public static final String PROPERTY_COMPARISON_METHOD = "ComparisonSetup.Property.ComparisonMethod";
    private final Map<Role, IScopeSpecification> _roleToScopeSpec = new HashMap<Role, IScopeSpecification>();
    private final List<IComparisonSpecificationFactory> _compatibleFactories;
    private IComparisonSpecificationFactory _selectedFactory;
    private IComparisonSpecification _comparisonSpecification;
    private final Set<IPropertyChangeListener> _listeners;

    public ComparisonSetup(IScopeSpecification scopeSpec1_p, IScopeSpecification scopeSpec2_p, IScopeSpecification scopeSpec3_p, List<IComparisonSpecificationFactory> compatibleFactories_p) {
        this._roleToScopeSpec.put(Role.TARGET, scopeSpec1_p);
        this._roleToScopeSpec.put(Role.REFERENCE, scopeSpec2_p);
        this._roleToScopeSpec.put(Role.ANCESTOR, scopeSpec3_p);
        this._comparisonSpecification = null;
        this._compatibleFactories = new ArrayList<IComparisonSpecificationFactory>(compatibleFactories_p);
        this._listeners = new HashSet<IPropertyChangeListener>();
    }

    public IComparisonSpecification getComparisonSpecification() {
        return this._comparisonSpecification;
    }

    public IScopeSpecification getScopeSpecification(Role role_p) {
        return this._roleToScopeSpec.get(role_p);
    }

    public IComparisonSpecificationFactory getSelectedFactory() {
        return this._selectedFactory;
    }

    public List<IComparisonSpecificationFactory> getCompatibleFactories() {
        return Collections.unmodifiableList(this._compatibleFactories);
    }

    public boolean isThreeWay() {
        return this.getScopeSpecification(Role.ANCESTOR) != null;
    }

    protected void notify(PropertyChangeEvent event_p) {
        for (IPropertyChangeListener listener : this._listeners) {
            listener.propertyChange(event_p);
        }
    }

    public void setSelectedFactory(IComparisonSpecificationFactory selectedFactory_p) {
        this._selectedFactory = selectedFactory_p;
        this._comparisonSpecification = this._selectedFactory != null ? this._selectedFactory.createComparisonSpecification(this.getScopeSpecification(Role.TARGET), this.getScopeSpecification(Role.REFERENCE), this.getScopeSpecification(Role.ANCESTOR)) : null;
        this.notify(new PropertyChangeEvent((Object)this, PROPERTY_COMPARISON_METHOD, null, null));
    }

    public boolean swapScopeSpecifications(Role role1_p, Role role2_p) {
        boolean result = true;
        if (this._comparisonSpecification != null) {
            result = this._comparisonSpecification.swapScopeSpecifications(role1_p, role2_p);
        }
        if (result) {
            IScopeSpecification scope1 = this.getScopeSpecification(role1_p);
            IScopeSpecification scope2 = this.getScopeSpecification(role2_p);
            if (scope1 != null && scope2 != null) {
                this._roleToScopeSpec.put(role1_p, scope2);
                this._roleToScopeSpec.put(role2_p, scope1);
            }
            this.notify(new PropertyChangeEvent((Object)this, PROPERTY_ROLES, null, null));
        }
        return result;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
        this._listeners.add(listener_p);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener_p) {
        this._listeners.remove(listener_p);
    }

    public void removePropertyChangeListeners() {
        this._listeners.clear();
    }
}

