/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.activitygroup;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IContainerNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.groupcontainment.ActivityContainment;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.groupcontainment.ActivityNodeContainment;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.groupcontainment.ActivityPartitionContainment;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.groupcontainment.ConditionalNodeContainment;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.groupcontainment.ExpansionRegionContainment;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.groupcontainment.InterruptibleActivityRegionContainment;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.groupcontainment.LoopNodeContainment;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.groupcontainment.SequenceNodeContainment;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.groupcontainment.StructuredActivityNodeContainment;
import org.eclipse.uml2.uml.UMLPackage;

public final class ContainerNodeDescriptorRegistry {
    private static Map<EClass, IContainerNodeDescriptor> registry = new HashMap<EClass, IContainerNodeDescriptor>();

    static {
        registry.put(UMLPackage.Literals.ACTIVITY_PARTITION, new ActivityPartitionContainment());
        registry.put(UMLPackage.Literals.STRUCTURED_ACTIVITY_NODE, new StructuredActivityNodeContainment());
        registry.put(UMLPackage.Literals.CONDITIONAL_NODE, new ConditionalNodeContainment());
        registry.put(UMLPackage.Literals.EXPANSION_REGION, new ExpansionRegionContainment());
        registry.put(UMLPackage.Literals.INTERRUPTIBLE_ACTIVITY_REGION, new InterruptibleActivityRegionContainment());
        registry.put(UMLPackage.Literals.LOOP_NODE, new LoopNodeContainment());
        registry.put(UMLPackage.Literals.SEQUENCE_NODE, new SequenceNodeContainment());
        registry.put(UMLPackage.Literals.ACTIVITY_NODE, new ActivityNodeContainment());
        registry.put(UMLPackage.Literals.ACTIVITY, new ActivityContainment());
    }

    private ContainerNodeDescriptorRegistry() {
    }

    public IContainerNodeDescriptor getContainerNodeDescriptor(EClass eclass) {
        try {
            IContainerNodeDescriptor result = registry.get(eclass);
            if (result == null) {
                ArrayList superTypes = Lists.newArrayList((Iterable)eclass.getEAllSuperTypes());
                for (EClass aux : Iterables.reverse((List)superTypes)) {
                    result = registry.get(aux);
                    if (result == null) continue;
                    return result;
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("wrong use of the ContainerNodeDescriptorRegistry");
        }
    }

    public static ContainerNodeDescriptorRegistry getInstance() {
        return SingletonHolder.instance;
    }

    /* synthetic */ ContainerNodeDescriptorRegistry(ContainerNodeDescriptorRegistry containerNodeDescriptorRegistry) {
        this();
    }

    private static class SingletonHolder {
        public static final ContainerNodeDescriptorRegistry instance = new ContainerNodeDescriptorRegistry(null);

        private SingletonHolder() {
        }
    }
}

