/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.diagram.activity.part.CustomMessages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmPinAndParameterSyncDialog
extends MessageDialog {
    protected ConfirmPinAndParameterSyncDialog(Shell parentShell, String dialogMessage) {
        super(parentShell, CustomMessages.ConfirmPinAndParameterSync_Title, null, dialogMessage, 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
    }

    public static boolean openConfirmFromParameter(Shell parentShell, List<? extends NamedElement> listOfActions, ILabelProvider labelprovider) {
        IPreferenceStore prefStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        boolean showPopup = prefStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.confirmPinSyncFromParameter");
        if (showPopup) {
            StringBuffer parsedList = new StringBuffer();
            for (NamedElement namedElement : listOfActions) {
                parsedList.append(labelprovider.getText((Object)namedElement));
                parsedList.append(System.getProperty("line.separator"));
            }
            String string = NLS.bind((String)CustomMessages.ConfirmPinAndParameterSync_FromParameterMsg, (Object)parsedList.toString());
            ConfirmPinAndParameterSyncDialog dialog = new ConfirmPinAndParameterSyncDialog(parentShell, string);
            return dialog.open() == 0;
        }
        return true;
    }

    protected Control createCustomArea(Composite parent) {
        Button checkBox = new Button(parent, 16416);
        checkBox.setText(CustomMessages.DiagramsPreferencePage_disableNotification);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    boolean doNotShow = ((Button)e.getSource()).getSelection();
                    IPreferenceStore prefStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
                    prefStore.putValue("org.eclipse.papyrus.uml.diagram.activity.confirmPinSyncFromParameter", Boolean.toString(!doNotShow));
                }
            }
        });
        return checkBox;
    }
}

