/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionConverter {
    protected static final ICElement[] EMPTY_RESULT = new ICElement[0];

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws CModelException {
        ISelection selection;
        if (part instanceof CEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((CEditor)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IStructuredSelection convertSelectionToCElements(ISelection s) {
        return SelectionConverter.convertSelectionToCElements(s, false);
    }

    public static IStructuredSelection convertSelectionToCElements(ISelection s, boolean keepNonCElements) {
        ArrayList<Object> converted = new ArrayList<Object>();
        if (s instanceof IStructuredSelection) {
            Object[] elements = ((IStructuredSelection)s).toArray();
            int i = 0;
            while (i < elements.length) {
                Object e = elements[i];
                if (e instanceof ICElement) {
                    converted.add(e);
                } else if (e instanceof IAdaptable) {
                    ICElement c = (ICElement)((IAdaptable)e).getAdapter(ICElement.class);
                    if (c != null) {
                        converted.add(c);
                    } else if (keepNonCElements) {
                        converted.add(e);
                    }
                } else if (keepNonCElements) {
                    converted.add(e);
                }
                ++i;
            }
        }
        return new StructuredSelection(converted.toArray());
    }

    public static IStructuredSelection convertSelectionToResources(ISelection s) {
        ArrayList<Object> converted = new ArrayList<Object>();
        if (s instanceof StructuredSelection) {
            Object[] elements = ((StructuredSelection)s).toArray();
            int i = 0;
            while (i < elements.length) {
                IResource r;
                Object e = elements[i];
                if (e instanceof IResource) {
                    converted.add(e);
                } else if (e instanceof IAdaptable && (r = (IResource)((IAdaptable)e).getAdapter(IResource.class)) != null) {
                    converted.add(r);
                }
                ++i;
            }
        }
        return new StructuredSelection(converted.toArray());
    }

    public static boolean allResourcesAreOfType(IStructuredSelection selection, int resourceMask) {
        for (Object next : selection) {
            if (!(next instanceof IAdaptable)) continue;
            IAdaptable element = (IAdaptable)next;
            IResource resource = (IResource)element.getAdapter(IResource.class);
            if (resource == null) {
                return false;
            }
            if (SelectionConverter.resourceIsType(resource, resourceMask)) continue;
            return false;
        }
        return true;
    }

    public static IStructuredSelection allResources(IStructuredSelection selection, int resourceMask) {
        Iterator adaptables = selection.iterator();
        ArrayList<IResource> result = new ArrayList<IResource>();
        while (adaptables.hasNext()) {
            Object next = adaptables.next();
            if (next instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)next).getAdapter(IResource.class);
                if (resource == null) {
                    return null;
                }
                if (!SelectionConverter.resourceIsType(resource, resourceMask)) continue;
                result.add(resource);
                continue;
            }
            return null;
        }
        return new StructuredSelection(result);
    }

    public static ICElement getElementAtOffset(ITextEditor editor) throws CModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static ICElement[] getElementsAtOffset(ITextEditor editor) throws CModelException {
        return SelectionConverter.getElementsAtOffset(SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICElement getElementAtOffset(ICElement input, ITextSelection selection) throws CModelException {
        if (input instanceof ITranslationUnit) {
            ICElement ref;
            ITranslationUnit tunit = (ITranslationUnit)input;
            if (tunit.isWorkingCopy() && tunit.isOpen()) {
                ITranslationUnit iTranslationUnit = tunit;
                synchronized (iTranslationUnit) {
                    if (tunit instanceof IWorkingCopy) {
                        ((IWorkingCopy)tunit).reconcile();
                    }
                }
            }
            if ((ref = tunit.getElementAtOffset(selection.getOffset())) == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICElement[] getElementsAtOffset(ICElement input, ITextSelection selection) throws CModelException {
        if (input instanceof ITranslationUnit) {
            ICElement[] refs;
            ITranslationUnit tunit = (ITranslationUnit)input;
            if (tunit.isWorkingCopy() && tunit.isOpen()) {
                ITranslationUnit iTranslationUnit = tunit;
                synchronized (iTranslationUnit) {
                    if (tunit instanceof IWorkingCopy) {
                        ((IWorkingCopy)tunit).reconcile();
                    }
                }
            }
            if ((refs = tunit.getElementsAtOffset(selection.getOffset())) == null) {
                return new ICElement[]{input};
            }
            return refs;
        }
        return null;
    }

    public static ICElement getInput(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    public static boolean resourceIsType(IResource resource, int resourceMask) {
        return (resource.getType() & resourceMask) != 0;
    }

    public static ICElement[] codeResolve(CEditor editor) throws CModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICElement[] codeResolve(ICElement input, ITextSelection selection) throws CModelException {
        if (input instanceof ITranslationUnit) {
            ICElement[] elems;
            ITranslationUnit tunit = (ITranslationUnit)input;
            if (tunit.isWorkingCopy() && tunit.isOpen()) {
                ITranslationUnit iTranslationUnit = tunit;
                synchronized (iTranslationUnit) {
                    if (tunit instanceof IWorkingCopy) {
                        ((IWorkingCopy)tunit).reconcile();
                    }
                }
            }
            if ((elems = tunit.getElementsAtOffset(selection.getOffset())) != null) {
                ICElement elem;
                int i = 0;
                while (i < elems.length) {
                    String text;
                    elem = elems[i];
                    if (elem instanceof ISourceReference && (text = selection.getText()).equals(elem.getElementName())) {
                        return new ICElement[]{elem};
                    }
                    ++i;
                }
                i = 0;
                while (i < elems.length) {
                    ISourceRange range;
                    elem = elems[i];
                    if (elem instanceof ISourceReference && (range = ((ISourceReference)elem).getSourceRange()).getStartPos() == selection.getOffset()) {
                        return new ICElement[]{elem};
                    }
                    ++i;
                }
            }
        }
        return EMPTY_RESULT;
    }

    public static ICElement codeResolve(CEditor editor, Shell shell, String title, String message) throws CModelException {
        ICElement[] elements = SelectionConverter.codeResolve(editor);
        if (elements == null || elements.length == 0) {
            return null;
        }
        ICElement candidate = elements[0];
        if (elements.length > 1) {
            candidate = OpenActionUtil.selectCElement(elements, shell, title, message);
        }
        return candidate;
    }

    public static ICElement[] codeResolveOrInput(CEditor editor) throws CModelException {
        ITextSelection selection;
        ICElement input = SelectionConverter.getInput(editor);
        ICElement[] result = SelectionConverter.codeResolve(input, selection = (ITextSelection)editor.getSelectionProvider().getSelection());
        if (result.length == 0) {
            result = new ICElement[]{input};
        }
        return result;
    }

    public static ICElement[] codeResolveOrInputHandled(CEditor editor, Shell shell, String title) {
        try {
            return SelectionConverter.codeResolveOrInput(editor);
        }
        catch (CModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, ActionMessages.SelectionConverter_codeResolve_failed);
            return null;
        }
    }

    public static boolean canOperateOn(CEditor editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }
}

