/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.selection;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstSelectionAction
extends Action {
    private XtextEditor xtextEditor;

    public XtextEditor getXtextEditor() {
        return this.xtextEditor;
    }

    public AstSelectionAction(String text, XtextEditor xtextEditor) {
        super(text);
        Assert.isNotNull((Object)((Object)xtextEditor));
        this.xtextEditor = xtextEditor;
    }

    public void run() {
        ITextSelection selection = (ITextSelection)this.xtextEditor.getSelectionProvider().getSelection();
        TextRegion currentEditorSelection = new TextRegion(selection.getOffset(), selection.getLength());
        ITextRegion nextSelection = (ITextRegion)this.xtextEditor.getDocument().readOnly(this.createTextSelectionWork((ITextRegion)currentEditorSelection));
        if (nextSelection == null || nextSelection == ITextRegion.EMPTY_REGION || nextSelection.equals(currentEditorSelection)) {
            return;
        }
        this.xtextEditor.selectAndReveal(nextSelection.getOffset(), nextSelection.getLength());
    }

    protected IUnitOfWork<ITextRegion, XtextResource> createTextSelectionWork(final ITextRegion selection) {
        return new IUnitOfWork<ITextRegion, XtextResource>(){

            public ITextRegion exec(XtextResource xtextResource) throws Exception {
                IParseResult parseResult;
                ITextRegion result = selection;
                if (xtextResource != null && (parseResult = xtextResource.getParseResult()) != null) {
                    result = AstSelectionAction.this.internalSelect(xtextResource, selection);
                }
                return result;
            }
        };
    }

    protected abstract ITextRegion internalSelect(XtextResource var1, ITextRegion var2);
}

