/**
 * <copyright>
 *
 * Copyright (c) 2010, 2013 E.D.Willink and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: RealValue.java,v 1.4 2011/02/21 08:37:52 ewillink Exp $
 */
package org.eclipse.ocl.examples.domain.values;

import java.math.BigDecimal;
import java.math.BigInteger;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface RealValue extends Value, OCLValue, Comparable<RealValue>
{
	/**
	 * @generated NOT
	 */
	@NonNull RealValue abs();

	/**
	 * @generated NOT
	 */
	@NonNull RealValue addInteger(@NonNull IntegerValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue addReal(@NonNull RealValue right);
	
	/**
	 * @generated NOT
	 */
	@NonNull Number asNumber();

	/**
	 * @generated NOT
	 */
	@NonNull BigDecimal bigDecimalValue();
	
	/**
	 * @generated NOT
	 */
	@NonNull BigInteger bigIntegerValue();

	/**
	 * @generated NOT
	 */
	@NonNull RealValue commutatedAdd(@NonNull RealValue left);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue commutatedDivide(@NonNull RealValue left);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue commutatedMultiply(@NonNull RealValue left);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue commutatedSubtract(@NonNull RealValue left);

	/**
	 * @generated NOT
	 */
	int compareToInteger(@NonNull IntegerValue right);

	/**
	 * @generated NOT
	 */
	int compareToReal(@NonNull RealValue right);

	/**
	 * @generated NOT
	 */
	int compareToUnlimited(@NonNull UnlimitedValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue divideInteger(@NonNull IntegerValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue divideReal(@NonNull RealValue right);

	/**
	 * @generated NOT
	 */
	double doubleValue();

	/**
	 * @generated NOT
	 */
	@NonNull IntegerValue floor();
	
	/**
	 * @generated NOT
	 */
	@Nullable IntegerValue isIntegerValue();

	/**
	 * @generated NOT
	 */
	boolean isUnlimited();

	/**
	 * @generated NOT
	 */
	@NonNull RealValue max(@NonNull RealValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue maxInteger(@NonNull IntegerValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue maxReal(@NonNull RealValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue maxUnlimited(@NonNull UnlimitedValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue min(@NonNull RealValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue minInteger(@NonNull IntegerValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue minUnlimited(@NonNull UnlimitedValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue multiplyInteger(@NonNull IntegerValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue minReal(@NonNull RealValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue multiplyReal(@NonNull RealValue right);

	/**
	 * @generated NOT
	 */
	@NonNull IntegerValue round();

	/**
	 * @generated NOT
	 */
	@NonNull RealValue negate();	

	/**
	 * @generated NOT
	 */
	int signum();

	/**
	 * @generated NOT
	 */
	@NonNull RealValue subtractInteger(@NonNull IntegerValue right);

	/**
	 * @generated NOT
	 */
	@NonNull RealValue subtractReal(@NonNull RealValue right);
}
