/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.xtext.glue.concurrency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.concurrency.SimpleDirtyResource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.shared.Access;

public class EditingDomainAdapter
extends AdapterImpl
implements ResourceSetListener,
TransactionalEditingDomainListener {
    private final TransactionalEditingDomain editingDomain;
    private IDirtyStateManager dirtyStateManager;
    private Map<URI, IDirtyResource> uri2dirtyResource;
    private static final Logger LOG = Logger.getLogger(EditingDomainAdapter.class);

    protected EditingDomainAdapter(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        editingDomain.addResourceSetListener((ResourceSetListener)this);
        this.dirtyStateManager = (IDirtyStateManager)Access.getIDirtyStateManager().get();
        this.uri2dirtyResource = Maps.newHashMap();
        TransactionalEditingDomain.Lifecycle lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)editingDomain, TransactionalEditingDomain.Lifecycle.class);
        lifecycle.addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        ArrayList remainingURIs = Lists.newArrayList(this.uri2dirtyResource.keySet());
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            if (!(resource instanceof XtextResource)) continue;
            XtextResource xtextResource = (XtextResource)resource;
            remainingURIs.remove(xtextResource.getURI());
            IDirtyResource dirtyResource = this.uri2dirtyResource.get(xtextResource.getURI());
            if (xtextResource.isModified()) {
                if (dirtyResource != null) continue;
                this.createAndRegisterDirtyState(xtextResource);
                continue;
            }
            if (dirtyResource == null) continue;
            this.uri2dirtyResource.remove(xtextResource.getURI());
            this.dirtyStateManager.discardDirtyState(dirtyResource);
        }
        for (URI remainingURI : remainingURIs) {
            IDirtyResource dirtyResource = this.uri2dirtyResource.get(remainingURI);
            this.dirtyStateManager.discardDirtyState(dirtyResource);
            this.uri2dirtyResource.remove(remainingURI);
        }
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        List resourcesWithConflicts = null;
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            XtextResource xtextResource;
            IDirtyResource dirtyResource;
            if (!(resource instanceof XtextResource) || !resource.isModified() || (dirtyResource = this.uri2dirtyResource.get((xtextResource = (XtextResource)resource).getURI())) != null || this.createAndRegisterDirtyState(xtextResource)) continue;
            if (resourcesWithConflicts == null) {
                resourcesWithConflicts = Lists.newArrayList();
            }
            resourcesWithConflicts.add(xtextResource);
        }
        if (resourcesWithConflicts != null) {
            if (this.queryApplyChanges()) {
                for (XtextResource resourceWithConflicts : resourcesWithConflicts) {
                    try {
                        IDirtyResource dirtyResource = this.createDirtyResource(resourceWithConflicts);
                        dirtyResource.getContents();
                        this.dirtyStateManager.announceDirtyStateChanged(dirtyResource);
                    }
                    catch (Exception exc) {
                        LOG.error((Object)"Error serializing resource", (Throwable)exc);
                    }
                }
            } else {
                throw new RollbackException((IStatus)new Status(4, "org.eclipse.papyrus.infra.gmfdiag.xtext.glue", "Transaction aborted by user"));
            }
        }
        return null;
    }

    protected boolean createAndRegisterDirtyState(XtextResource xtextResource) {
        IDirtyResource dirtyResource = this.createDirtyResource(xtextResource);
        if (dirtyResource == null) {
            return true;
        }
        boolean isSuccess = this.dirtyStateManager.manageDirtyState(dirtyResource);
        if (isSuccess) {
            this.uri2dirtyResource.put(xtextResource.getURI(), dirtyResource);
        }
        return isSuccess;
    }

    protected IDirtyResource createDirtyResource(XtextResource xtextResource) {
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(xtextResource.getURI());
        if (resourceServiceProvider == null) {
            return null;
        }
        return new SimpleDirtyResource(xtextResource, resourceServiceProvider);
    }

    public void editingDomainDisposing(TransactionalEditingDomainEvent event) {
        this.dispose();
    }

    public void dispose() {
        TransactionalEditingDomain.Lifecycle lifecycle;
        if (this.uri2dirtyResource != null) {
            for (IDirtyResource dirtyResource : this.uri2dirtyResource.values()) {
                this.dirtyStateManager.discardDirtyState(dirtyResource);
            }
            this.uri2dirtyResource = null;
        }
        if ((lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)this.editingDomain, TransactionalEditingDomain.Lifecycle.class)) != null) {
            lifecycle.removeTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
        }
        this.editingDomain.removeResourceSetListener((ResourceSetListener)this);
    }

    protected boolean queryApplyChanges() {
        DialogPrompter dialogPrompter = new DialogPrompter();
        Display.getDefault().syncExec((Runnable)dialogPrompter);
        boolean yesResult = dialogPrompter.isYesResult();
        return yesResult;
    }

    public void transactionClosed(TransactionalEditingDomainEvent event) {
    }

    public void transactionClosing(TransactionalEditingDomainEvent event) {
    }

    public void transactionInterrupted(TransactionalEditingDomainEvent event) {
    }

    public void transactionStarted(TransactionalEditingDomainEvent event) {
    }

    public void transactionStarting(TransactionalEditingDomainEvent event) {
    }

    protected class DialogPrompter
    implements Runnable {
        private boolean isYesResult;

        protected DialogPrompter() {
        }

        public boolean isYesResult() {
            return this.isYesResult;
        }

        public void run() {
            Shell shell = Display.getDefault().getActiveShell();
            this.isYesResult = MessageDialog.open((int)3, (Shell)shell, (String)"Concurrent Modification", (String)"Other editors have a modified version of models you are going to change.\nIf apply your changes you are loosing the possibility to save the others.\nApply changes anyway?", (int)0);
        }
    }

    public static class Factory
    extends AdapterFactoryImpl {
        public boolean isFactoryForType(Object type) {
            return super.isFactoryForType((Object)(type == EditingDomainAdapter.class ? 1 : 0));
        }

        protected Object resolve(Object object, Object type) {
            if (object instanceof TransactionalEditingDomain) {
                return this.adapt((Notifier)((TransactionalEditingDomain)object).getResourceSet(), type);
            }
            return super.resolve(object, type);
        }

        protected Adapter createAdapter(Notifier target) {
            if (target instanceof ResourceSet) {
                return new EditingDomainAdapter(TransactionUtil.getEditingDomain((Object)target));
            }
            return null;
        }
    }
}

