/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.xtext.glue.editingdomain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.xtext.resource.XtextResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeAggregatorAdapter
extends EContentAdapter {
    private Collection<EObject> modifiedObjects = new LinkedHashSet<EObject>();
    private boolean isRecording = false;
    private boolean isSuspended = false;

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (!this.doRecord(notification)) {
            return;
        }
        if (notification.getNotifier() instanceof EObject) {
            this.recordObjectModification((EObject)notification.getNotifier());
        }
    }

    protected void recordObjectModification(EObject obj) {
        if (obj.eResource() == null || !(obj.eResource() instanceof XtextResource)) {
            this.modifiedObjects.remove(obj);
        } else {
            this.modifiedObjects.add(obj);
        }
    }

    protected boolean doRecord(Notification notification) {
        if (!this.isRecording || this.isSuspended || notification.isTouch()) {
            return false;
        }
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    private void reset() {
        this.modifiedObjects.clear();
    }

    public void beginRecording() {
        this.reset();
        this.isRecording = true;
    }

    public void endRecording() {
        this.isRecording = false;
    }

    public void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
    }

    public List<EObject> getModificationRoots() {
        HashMap<Resource, LinkedList<EObject>> resource2ChangePathMap = new HashMap<Resource, LinkedList<EObject>>();
        for (EObject eObject : this.modifiedObjects) {
            if (eObject.eIsProxy()) continue;
            Resource resource = eObject.eResource();
            LinkedList<EObject> resourceChangePath = (LinkedList<EObject>)resource2ChangePathMap.get(resource);
            if (resourceChangePath == null) {
                resourceChangePath = this.allContainers(eObject);
                resource2ChangePathMap.put(resource, resourceChangePath);
                continue;
            }
            resourceChangePath.retainAll(this.allContainers(eObject));
        }
        ArrayList<EObject> modificationRoots = new ArrayList<EObject>(resource2ChangePathMap.size());
        for (List changePath : resource2ChangePathMap.values()) {
            if (changePath.isEmpty()) continue;
            modificationRoots.add((EObject)changePath.get(changePath.size() - 1));
        }
        return modificationRoots;
    }

    private LinkedList<EObject> allContainers(EObject eObject) {
        LinkedList allContainers = Lists.newLinkedList();
        allContainers.add(eObject);
        EObject currentContainer = eObject.eContainer();
        Resource resource = eObject.eResource();
        while (currentContainer != null && resource == currentContainer.eResource()) {
            allContainers.addFirst(currentContainer);
            currentContainer = currentContainer.eContainer();
        }
        return allContainers;
    }

    protected void setTarget(Resource target) {
        if (target instanceof XtextResource) {
            super.setTarget(target);
        }
    }

    protected void setTarget(EObject target) {
        if (target.eResource() instanceof XtextResource) {
            super.setTarget(target);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == ChangeAggregatorAdapter.class;
    }
}

