/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactMultipleValueEditor
extends AbstractListEditor
implements IChangeListener,
DisposeListener,
SelectionListener {
    protected static final String DEFAULT_VALUE_SEPARATOR = ", ";
    protected Label valueLabel;
    protected Button edit;
    protected ILabelProvider labelProvider;
    protected String separator;
    protected MultipleValueSelectorDialog dialog;
    protected IElementSelector selector;

    public CompactMultipleValueEditor(Composite parent, int style, IElementSelector selector) {
        this(parent, style, selector, false, false, DEFAULT_VALUE_SEPARATOR, null);
    }

    public CompactMultipleValueEditor(Composite parent, int style, IElementSelector selector, boolean ordered, boolean unique) {
        this(parent, style, selector, ordered, unique, DEFAULT_VALUE_SEPARATOR, null);
    }

    public CompactMultipleValueEditor(Composite parent, int style, IElementSelector selector, boolean ordered, boolean unique, String separator, String label) {
        super(parent, label);
        ((GridLayout)this.getLayout()).numColumns = 3;
        this.valueLabel = factory.createLabel((Composite)this, null, style);
        this.valueLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.edit = new Button((Composite)this, 8);
        this.edit.setText("...");
        this.edit.addSelectionListener((SelectionListener)this);
        this.edit.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.selector = selector;
        this.dialog = new MultipleValueSelectorDialog(parent.getShell(), selector, unique);
        this.labelProvider = new LabelProvider();
        this.separator = separator;
    }

    @Override
    public Object getEditableType() {
        return Collection.class;
    }

    @Override
    protected void doBinding() {
        this.modelProperty.addChangeListener((IChangeListener)this);
        this.handleChange(null);
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.dialog.setLabelProvider(provider);
        this.labelProvider = provider;
    }

    public void handleChange(ChangeEvent event) {
        if (this.modelProperty != null) {
            LinkedList<String> labels = new LinkedList<String>();
            for (Object element : this.modelProperty) {
                labels.add(this.labelProvider.getText(element));
            }
            this.valueLabel.setText(this.createValueLabel(labels));
        }
    }

    protected String createValueLabel(List<String> labels) {
        if (labels.size() == 0) {
            return "";
        }
        String result = labels.get(0);
        int i = 1;
        while (i < labels.size()) {
            result = String.valueOf(result) + this.separator + labels.get(i);
            ++i;
        }
        return result;
    }

    public void dispose() {
        if (this.modelProperty != null) {
            this.modelProperty.removeChangeListener((IChangeListener)this);
        }
        super.dispose();
    }

    public void widgetSelected(SelectionEvent e) {
        this.dialog.setInitialSelections(this.modelProperty.toArray());
        int returnCode = this.dialog.open();
        if (returnCode == 1) {
            return;
        }
        this.modelProperty.clear();
        Object[] result = this.dialog.getResult();
        if (result == null) {
            return;
        }
        LinkedList<Object> resultElements = new LinkedList<Object>();
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object r = objectArray[n2];
            resultElements.add(r);
            ++n2;
        }
        this.modelProperty.addAll(resultElements);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.valueLabel.setEnabled(!readOnly);
        this.edit.setEnabled(!readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return !this.valueLabel.isEnabled() || !this.edit.isEnabled();
    }

    @Override
    public void setToolTipText(String text) {
        this.valueLabel.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    @Override
    public void refreshValue() {
        this.handleChange(null);
    }
}

