/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.AbstractFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.HierarchicToFlatContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IFlattenableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FlattenableRestrictedFilteredContentProvider
extends AbstractFilteredContentProvider
implements IStaticContentProvider,
IRestrictedContentProvider,
IFlattenableContentProvider {
    private boolean isFlat = false;
    private ReferenceSelector selector;
    protected IRestrictedContentProvider provider;
    protected HierarchicToFlatContentProvider flatProvider;

    public FlattenableRestrictedFilteredContentProvider(IRestrictedContentProvider provider, ReferenceSelector selector) {
        this.provider = provider;
        this.flatProvider = new HierarchicToFlatContentProvider(provider);
        this.selector = selector;
    }

    public void createAfter(Composite parent) {
        super.createAfter(parent);
        Composite checkboxSection = new Composite(parent, 0);
        checkboxSection.setLayout((Layout)new FillLayout(512));
        final Button onlyCurrentContainersCheckbox = new Button(checkboxSection, 32);
        onlyCurrentContainersCheckbox.setText(Messages.FlattenableRestrictedFilteredContentProvider_AllPossibleContentsMessage);
        final Button showFlatListOfFeaturesCheckbox = new Button(checkboxSection, 32);
        showFlatListOfFeaturesCheckbox.setText(Messages.FlattenableRestrictedFilteredContentProvider_FlatViewMessage);
        onlyCurrentContainersCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FlattenableRestrictedFilteredContentProvider.this.setRestriction(!onlyCurrentContainersCheckbox.getSelection());
                FlattenableRestrictedFilteredContentProvider.this.viewer.refresh();
                FlattenableRestrictedFilteredContentProvider.this.selector.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        showFlatListOfFeaturesCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FlattenableRestrictedFilteredContentProvider.this.setFlat(showFlatListOfFeaturesCheckbox.getSelection());
                FlattenableRestrictedFilteredContentProvider.this.viewer.refresh();
                FlattenableRestrictedFilteredContentProvider.this.selector.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public Object[] getElements(Object inputElement) {
        if (this.isFlat) {
            return this.flatProvider.getElements(inputElement);
        }
        return this.provider.getElements(inputElement);
    }

    public void dispose() {
        this.flatProvider.dispose();
        this.provider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.flatProvider.inputChanged(viewer, oldInput, newInput);
        this.provider.inputChanged(viewer, oldInput, newInput);
    }

    public boolean isValidValue(Object element) {
        return this.provider.isValidValue(element);
    }

    public Object[] getChildren(Object parentElement) {
        if (this.isFlat) {
            return new Object[0];
        }
        return this.provider.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (this.isFlat) {
            return null;
        }
        return this.provider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        if (this.isFlat) {
            return false;
        }
        return this.provider.hasChildren(element);
    }

    public void setRestriction(boolean isRestricted) {
        this.provider.setRestriction(isRestricted);
    }

    public void setFlat(boolean flat) {
        this.isFlat = flat;
    }

    public Object[] getElements() {
        return null;
    }

    public void setIgnoreInheritedElements(boolean ignoreInheritedElements) {
        this.provider.setIgnoreInheritedElements(ignoreInheritedElements);
    }

    public boolean isIgnoringInheritedElements() {
        return this.provider.isIgnoringInheritedElements();
    }

    public boolean isRestricted() {
        return this.provider.isRestricted();
    }
}

