/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.selectors;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardSelector
implements IElementSelector {
    protected Class<? extends AbstractValueEditor> editorClass;
    protected AbstractValueEditor editor;
    protected Set<IElementSelectionListener> elementSelectionListeners = new HashSet<IElementSelectionListener>();

    public StandardSelector(Class<? extends AbstractValueEditor> editorClass) {
        Assert.isNotNull(editorClass, (String)"The StandardSelector editor class should not be null");
        this.editorClass = editorClass;
    }

    @Override
    public Object[] getSelectedElements() {
        Object value = this.editor.getValue();
        if (value == null) {
            return new Object[0];
        }
        return new Object[]{value};
    }

    @Override
    public void setSelectedElements(Object[] elements) {
    }

    @Override
    public Object[] getAllElements() {
        return this.getSelectedElements();
    }

    @Override
    public void createControls(Composite parent) {
        try {
            Constructor<? extends AbstractValueEditor> construct = this.editorClass.getDeclaredConstructor(Composite.class, Integer.TYPE);
            this.editor = construct.newInstance(parent, 2048);
            this.editor.addCommitListener(new ICommitListener(){

                public void commit(AbstractEditor editor) {
                    if (!StandardSelector.this.elementSelectionListeners.isEmpty()) {
                        Object value = StandardSelector.this.editor.getValue();
                        for (IElementSelectionListener listener : StandardSelector.this.elementSelectionListeners) {
                            listener.addElements(new Object[]{value});
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public void newObjectCreated(Object newObject) {
    }

    @Override
    public void clearTemporaryElements() {
    }

    @Override
    public void addElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.add(listener);
    }

    @Override
    public void removeElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.remove(listener);
    }
}

