/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RevertOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class FileReplaceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        try {
            final ArrayList added = new ArrayList();
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource().getType() == 1 && (delta.getKind() == 1 || delta.getKind() == 4)) {
                        added.add((IFile)delta.getResource());
                    }
                    return true;
                }
            });
            if (!added.isEmpty()) {
                this.processResources(added.toArray(new IResource[0]));
            }
        }
        catch (CoreException e) {
            LoggedOperation.reportError(this.getClass().getName(), e);
        }
    }

    protected void processResources(IResource[] resources) {
        AbstractWorkingCopyOperation mainOp = new AbstractWorkingCopyOperation("Operation_FileReplaceListener", SVNMessages.class, resources){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                IResource[] iResourceArray = this.operableData();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block27: {
                        IResource file = iResourceArray[n2];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(file);
                        if (IStateFilter.SF_DELETED.accept(local) || IStateFilter.SF_PREREPLACEDREPLACED.accept(local)) {
                            IContainer parent = file.getParent();
                            ILocalResource localParent = SVNRemoteStorage.instance().asLocalResource((IResource)parent);
                            if (!IStateFilter.SF_DELETED.accept(localParent)) {
                                File fileWithOriginalContent;
                                File tmpFile;
                                File originalFile;
                                boolean hasError;
                                block26: {
                                    hasError = true;
                                    originalFile = new File(FileUtility.getWorkingCopyPath(file));
                                    tmpFile = new File(originalFile + ".svntmp");
                                    fileWithOriginalContent = originalFile;
                                    try {
                                        try {
                                            if (tmpFile.exists()) {
                                                tmpFile.delete();
                                            }
                                            if (originalFile.renameTo(tmpFile)) {
                                                fileWithOriginalContent = tmpFile;
                                                RevertOperation revertOp = new RevertOperation(new IResource[]{file}, false);
                                                ProgressMonitorUtility.doTask(revertOp, monitor, 100, 60);
                                                if (revertOp.getExecutionState() == 0) {
                                                    if (!originalFile.delete()) {
                                                        throw new Exception("Failed to delete file: " + originalFile);
                                                    }
                                                    if (!tmpFile.renameTo(originalFile)) {
                                                        throw new Exception("Failed to rename file: " + originalFile);
                                                    }
                                                    fileWithOriginalContent = originalFile;
                                                    hasError = false;
                                                } else {
                                                    this.reportStatus(revertOp.getStatus());
                                                }
                                                break block26;
                                            }
                                            throw new Exception("Failed to rename file: " + originalFile.getAbsolutePath());
                                        }
                                        catch (Throwable t) {
                                            this.reportStatus(4, null, t);
                                            if (hasError) {
                                                if (fileWithOriginalContent.equals(tmpFile)) {
                                                    originalFile.delete();
                                                    tmpFile.renameTo(originalFile);
                                                } else if (fileWithOriginalContent.equals(originalFile)) {
                                                    tmpFile.delete();
                                                }
                                            }
                                            break block27;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (hasError) {
                                            if (fileWithOriginalContent.equals(tmpFile)) {
                                                originalFile.delete();
                                                tmpFile.renameTo(originalFile);
                                            } else if (fileWithOriginalContent.equals(originalFile)) {
                                                tmpFile.delete();
                                            }
                                        }
                                        throw throwable;
                                    }
                                }
                                if (hasError) {
                                    if (fileWithOriginalContent.equals(tmpFile)) {
                                        originalFile.delete();
                                        tmpFile.renameTo(originalFile);
                                    } else if (fileWithOriginalContent.equals(originalFile)) {
                                        tmpFile.delete();
                                    }
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
        };
        CompositeOperation cmpOp = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        cmpOp.add(mainOp);
        cmpOp.add(new RefreshResourcesOperation(resources));
        ProgressMonitorUtility.doTaskScheduledDefault(cmpOp);
    }
}

