/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryResource;

public class CreatePatchOperation
extends AbstractFileOperation {
    protected String fileName;
    protected boolean recurse;
    protected boolean ignoreDeleted;
    protected boolean processBinary;
    protected boolean useRelativePath;

    public CreatePatchOperation(File file, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean useRelativePath) {
        super("Operation_CreatePatchFile", SVNMessages.class, new File[]{file});
        this.fileName = fileName;
        this.recurse = recurse;
        this.ignoreDeleted = ignoreDeleted;
        this.processBinary = processBinary;
        this.useRelativePath = useRelativePath;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File file = this.operableData()[0];
        IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(file, false);
        ISVNConnector proxy = remote.getRepositoryLocation().acquireSVNProxy();
        try {
            this.writeToConsole(0, "svn diff " + (this.recurse ? "" : " -N") + (this.ignoreDeleted ? " --no-diff-deleted" : "") + "\n");
            String path = file.getAbsolutePath();
            long options = 512L;
            options |= this.ignoreDeleted ? 8192L : 0L;
            proxy.diff(new SVNEntryRevisionReference(path, null, SVNRevision.BASE), new SVNEntryRevisionReference(path, null, SVNRevision.WORKING), this.useRelativePath ? path : null, this.fileName, ISVNConnector.Depth.infinityOrFiles(this.recurse), options |= this.processBinary ? 4L : 0L, null, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            remote.getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }
}

